/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildPropertyPage;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BuildSettingsBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "BuildSettingsBlock";
    private static final String LABEL = "BuildSettingsBlock.label";
    private static final String SETTINGS_LABEL = "BuildSettingsBlock.label.Settings";
    private static final String GROUP = "BuildSettingsBlock.label.makecmdgroup";
    private static final String DEF_BTN = "BuildSettingsBlock.label.makecmddef";
    private static final String OUTPUT_GROUP = "BuildSettingsBlock.label.output.group";
    private static final String OUTPUT_EXT = "BuildSettingsBlock.label.output.extension";
    private static final String OUTPUT_NAME = "BuildSettingsBlock.label.output.name";
    private static final String MACROS_GROUP = "BuildSettingsBlock.label.macros.group";
    private static final String PACROS_EXPAND_BTN = "BuildSettingsBlock.label.macros.expand";
    private static final String EMPTY_STRING = new String();
    protected Text buildArtifactExt;
    protected Text buildArtifactName;
    protected Button makeCommandDefault;
    protected Text makeCommandEntry;
    protected Button buildMacrosExpand;
    protected Group buildMacrosExpandGroup;
    private BuildPropertyPage parent;
    private String artifactExt;
    private String artifactName;
    private String makeCommand;
    private boolean useDefaultMake;
    private boolean dirty = false;
    private ModifyListener widgetModified = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            BuildSettingsBlock.this.setDirty(true);
        }
    };

    public BuildSettingsBlock(BuildPropertyPage parent) {
        super(ManagedBuilderUIMessages.getResourceString(SETTINGS_LABEL));
        super.setContainer((ICOptionContainer)parent);
        this.parent = parent;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setFont(parent.getFont());
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)comp);
        this.createBuildArtifactGroup(comp);
        this.createMakeCommandGroup(comp);
        this.createExpandMacrosGroup(comp);
    }

    private void createBuildArtifactGroup(Composite parent) {
        Group outputGroup = new Group(parent, 0);
        outputGroup.setFont(parent.getFont());
        outputGroup.setText(ManagedBuilderUIMessages.getResourceString(OUTPUT_GROUP));
        outputGroup.setLayout((Layout)new GridLayout(3, false));
        outputGroup.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label((Composite)outputGroup, 16384);
        nameLabel.setFont(outputGroup.getFont());
        nameLabel.setText(ManagedBuilderUIMessages.getResourceString(OUTPUT_NAME));
        nameLabel.setLayoutData((Object)new GridData(768));
        Label placeHolder = new Label((Composite)outputGroup, 0x1000000);
        placeHolder.setText(new String());
        placeHolder.setLayoutData((Object)new GridData());
        Label extLabel = new Label((Composite)outputGroup, 16384);
        extLabel.setFont(outputGroup.getFont());
        extLabel.setText(ManagedBuilderUIMessages.getResourceString(OUTPUT_EXT));
        extLabel.setLayoutData((Object)new GridData(768));
        this.buildArtifactName = new Text((Composite)outputGroup, 2052);
        this.buildArtifactName.setFont(outputGroup.getFont());
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.buildArtifactName.setLayoutData((Object)data);
        this.buildArtifactName.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BuildSettingsBlock.this.buildArtifactName = null;
            }
        });
        this.buildArtifactName.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ManagedBuilderUIMessages.getResourceString(BuildSettingsBlock.OUTPUT_NAME);
            }
        });
        this.buildArtifactName.addModifyListener(this.widgetModified);
        Label dotLabel = new Label((Composite)outputGroup, 0x1000000);
        dotLabel.setFont(outputGroup.getFont());
        dotLabel.setText(new String("."));
        dotLabel.setLayoutData((Object)new GridData());
        this.buildArtifactExt = new Text((Composite)outputGroup, 2052);
        this.buildArtifactExt.setFont(outputGroup.getFont());
        data = new GridData(768);
        data.widthHint = 100;
        this.buildArtifactExt.setLayoutData((Object)data);
        this.buildArtifactExt.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BuildSettingsBlock.this.buildArtifactExt = null;
            }
        });
        this.buildArtifactExt.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ManagedBuilderUIMessages.getResourceString(BuildSettingsBlock.OUTPUT_EXT);
            }
        });
        this.buildArtifactExt.addModifyListener(this.widgetModified);
    }

    private void createMakeCommandGroup(Composite parent) {
        Group makeCommandGroup = new Group(parent, 0);
        makeCommandGroup.setFont(parent.getFont());
        makeCommandGroup.setText(ManagedBuilderUIMessages.getResourceString(GROUP));
        makeCommandGroup.setLayout((Layout)new GridLayout(1, true));
        makeCommandGroup.setLayoutData((Object)new GridData(768));
        this.makeCommandDefault = new Button((Composite)makeCommandGroup, 16416);
        this.makeCommandDefault.setFont(makeCommandGroup.getFont());
        this.makeCommandDefault.setText(ManagedBuilderUIMessages.getResourceString(DEF_BTN));
        this.makeCommandDefault.setBackground(makeCommandGroup.getBackground());
        this.makeCommandDefault.setForeground(makeCommandGroup.getForeground());
        this.makeCommandDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildSettingsBlock.this.handleUseDefaultPressed();
                BuildSettingsBlock.this.setDirty(true);
            }
        });
        this.makeCommandDefault.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BuildSettingsBlock.this.makeCommandDefault = null;
            }
        });
        this.makeCommandEntry = new Text((Composite)makeCommandGroup, 2052);
        this.makeCommandEntry.setFont(makeCommandGroup.getFont());
        this.makeCommandEntry.setLayoutData((Object)new GridData(768));
        this.makeCommandEntry.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BuildSettingsBlock.this.makeCommandEntry = null;
            }
        });
        this.makeCommandEntry.addModifyListener(this.widgetModified);
    }

    private void createExpandMacrosGroup(Composite parent) {
        this.buildMacrosExpandGroup = new Group(parent, 0);
        this.buildMacrosExpandGroup.setFont(parent.getFont());
        this.buildMacrosExpandGroup.setText(ManagedBuilderUIMessages.getResourceString(MACROS_GROUP));
        this.buildMacrosExpandGroup.setLayout((Layout)new GridLayout(1, true));
        this.buildMacrosExpandGroup.setLayoutData((Object)new GridData(768));
        this.buildMacrosExpand = new Button((Composite)this.buildMacrosExpandGroup, 16416);
        this.buildMacrosExpand.setFont(this.buildMacrosExpandGroup.getFont());
        this.buildMacrosExpand.setText(ManagedBuilderUIMessages.getResourceString(PACROS_EXPAND_BTN));
        this.buildMacrosExpand.setBackground(this.buildMacrosExpandGroup.getBackground());
        this.buildMacrosExpand.setForeground(this.buildMacrosExpandGroup.getForeground());
        this.buildMacrosExpand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildSettingsBlock.this.setDirty(true);
            }
        });
        this.buildMacrosExpand.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BuildSettingsBlock.this.buildMacrosExpand = null;
            }
        });
    }

    protected void initializeValues() {
        this.setValues();
    }

    public void updateValues() {
        this.setValues();
        this.useDefaultMake = !this.parent.getSelectedConfiguration().hasOverriddenBuildCommand();
        this.makeCommandDefault.setSelection(this.useDefaultMake);
        this.makeCommandEntry.setEditable(!this.makeCommandDefault.getSelection());
    }

    protected void setValues() {
        this.artifactName = this.parent.getSelectedConfiguration().getArtifactName();
        this.buildArtifactName.setText(this.artifactName);
        this.artifactExt = this.parent.getSelectedConfiguration().getArtifactExtension();
        this.buildArtifactExt.setText(this.artifactExt);
        this.makeCommand = this.parent.getSelectedConfiguration().getBuildCommand();
        String makeArgs = this.parent.getSelectedConfiguration().getBuildArguments();
        if (makeArgs != null) {
            this.makeCommand = String.valueOf(this.makeCommand) + " " + makeArgs;
        }
        this.makeCommandEntry.setText(this.makeCommand);
        BuildMacroProvider provider = (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider();
        if (!provider.canKeepMacrosInBuildfile(this.parent.getSelectedConfiguration())) {
            this.buildMacrosExpandGroup.setVisible(false);
        } else {
            this.buildMacrosExpandGroup.setVisible(true);
            this.buildMacrosExpand.setSelection(provider.areMacrosExpandedInBuildfile(this.parent.getSelectedConfiguration()));
        }
        this.setDirty(false);
    }

    public void removeValues(String id) {
    }

    public void performDefaults() {
        Shell shell = ManagedBuilderUIPlugin.getDefault().getShell();
        boolean shouldDefault = MessageDialog.openConfirm((Shell)shell, (String)ManagedBuilderUIMessages.getResourceString("BuildSettingsBlock.defaults.title"), (String)ManagedBuilderUIMessages.getResourceString("BuildSettingsBlock.defaults.message"));
        if (!shouldDefault) {
            return;
        }
        IConfiguration config = this.parent.getSelectedConfiguration();
        config.setArtifactName(config.getManagedProject().getDefaultArtifactName());
        config.setArtifactExtension(null);
        IBuilder builder = config.getToolChain().getBuilder();
        if (!builder.isExtensionElement()) {
            config.getToolChain().removeLocalBuilder();
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)this.parent.getProject(), (IConfiguration)this.parent.getSelectedConfiguration());
        ManagedBuildManager.saveBuildInfo((IProject)this.parent.getProject(), (boolean)false);
        BuildMacroProvider provider = (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider();
        provider.expandMacrosInBuildfile(config, false);
        this.setValues();
        this.makeCommandDefault.setSelection(true);
        this.makeCommandEntry.setEditable(false);
        this.setDirty(false);
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        BuildMacroProvider provider;
        this.useDefaultMake = this.makeCommandDefault.getSelection();
        this.makeCommand = this.makeCommandEntry.getText().trim();
        this.artifactName = this.buildArtifactName.getText().trim();
        this.artifactExt = this.buildArtifactExt.getText().trim();
        IConfiguration selectedConfiguration = this.parent.getSelectedConfiguration();
        IBuilder builder = selectedConfiguration.getToolChain().getBuilder();
        boolean setBuilderValues = false;
        if (!selectedConfiguration.getArtifactName().equals(this.artifactName)) {
            setBuilderValues = true;
        }
        if (!selectedConfiguration.getArtifactExtension().equals(this.artifactExt)) {
            setBuilderValues = true;
        }
        String makeCommandOnly = null;
        String makeArguments = null;
        if (this.useDefaultMake) {
            if (!builder.isExtensionElement()) {
                setBuilderValues = true;
            }
        } else {
            String rawCommand = this.makeCommand;
            makeCommandOnly = this.parseMakeCommand(rawCommand);
            if (!selectedConfiguration.getBuildCommand().equals(makeCommandOnly)) {
                setBuilderValues = true;
            }
            makeArguments = this.parseMakeArgs(rawCommand);
            if (!selectedConfiguration.getBuildArguments().equals(makeArguments)) {
                setBuilderValues = true;
            }
        }
        if (setBuilderValues) {
            if (builder.isExtensionElement()) {
                IToolChain tc = selectedConfiguration.getToolChain();
                int nnn = ManagedBuildManager.getRandomNumber();
                String tmpId = builder.getId();
                String version = ManagedBuildManager.getVersionFromIdAndVersion((String)tmpId);
                String subId = version != null ? String.valueOf(ManagedBuildManager.getIdFromIdAndVersion((String)tmpId)) + "." + nnn + "_" + version : String.valueOf(tmpId) + "." + nnn;
                String name = String.valueOf(builder.getName()) + "." + selectedConfiguration.getName();
                tc.createBuilder(builder, subId, name, false);
            }
            selectedConfiguration.setArtifactName(this.artifactName);
            selectedConfiguration.setArtifactExtension(this.artifactExt);
            selectedConfiguration.setBuildCommand(makeCommandOnly);
            selectedConfiguration.setBuildArguments(makeArguments);
        }
        if ((provider = (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider()).canKeepMacrosInBuildfile(this.parent.getSelectedConfiguration())) {
            provider.expandMacrosInBuildfile(selectedConfiguration, this.buildMacrosExpand.getSelection());
        }
        this.setDirty(false);
    }

    private String parseMakeArgs(String rawCommand) {
        StringBuffer result = new StringBuffer();
        String actualCommand = this.parseMakeCommand(rawCommand);
        String arguments = rawCommand.substring(actualCommand.length());
        if (arguments.length() == 0) {
            return result.toString().trim();
        }
        String[] tokens = arguments.trim().split("\\s");
        Pattern flagPattern = Pattern.compile("C|f|I|j|l|O|W");
        Pattern mixedFlagWithArg = Pattern.compile("-[^CfIjloW]*[CfIjloW]{1}.+");
        int i = 0;
        while (i < tokens.length) {
            String currentToken = tokens[i];
            if (currentToken.startsWith("--")) {
                result.append(currentToken);
                result.append(" ");
            } else if (currentToken.startsWith("-")) {
                if (i + 1 >= tokens.length) {
                    result.append(currentToken);
                } else {
                    String nextToken = tokens[i + 1];
                    Matcher flagMatcher = flagPattern.matcher(currentToken);
                    if (!flagMatcher.find()) {
                        result.append(currentToken);
                        result.append(" ");
                    } else if (mixedFlagWithArg.matcher(currentToken).matches()) {
                        result.append(currentToken);
                        result.append(" ");
                    } else {
                        result.append(currentToken);
                        result.append(" ");
                        result.append(nextToken);
                        result.append(" ");
                        ++i;
                    }
                }
            }
            ++i;
        }
        return result.toString().trim();
    }

    private String parseMakeCommand(String rawCommand) {
        StringBuffer command = new StringBuffer();
        String[] result = rawCommand.split("\\s");
        int i = 0;
        while (i < result.length) {
            String cmdSegment = result[i];
            if (i + 1 >= result.length) {
                command.append(cmdSegment);
            } else {
                String nextSegment = result[i + 1];
                if (nextSegment.startsWith("-")) {
                    command.append(cmdSegment);
                    break;
                }
                command.append(cmdSegment);
                command.append(" ");
            }
            ++i;
        }
        return command.toString().trim();
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.useDefaultMake = !this.parent.getSelectedConfiguration().hasOverriddenBuildCommand();
            this.makeCommandDefault.setSelection(this.useDefaultMake);
            this.makeCommandEntry.setEditable(!this.makeCommandDefault.getSelection());
        }
        super.setVisible(visible);
    }

    protected void handleUseDefaultPressed() {
        boolean checked = this.makeCommandDefault.getSelection();
        if (checked) {
            this.parent.getSelectedConfiguration().setBuildCommand(null);
            this.parent.getSelectedConfiguration().setBuildArguments(null);
            this.makeCommandEntry.setEditable(false);
        } else {
            this.makeCommandEntry.setEditable(true);
        }
        this.setValues();
    }

    public void setDirty(boolean b) {
        this.dirty = b;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

