/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.cindexstorage.Index;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexInput;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FieldDeclarationPattern
extends CSearchPattern {
    private char[][] qualifications;
    private char[][] decodedQualifications;
    private char[] simpleName;
    private char[] decodedSimpleName;
    private ICSearchConstants.SearchFor searchFor;

    public FieldDeclarationPattern(char[] name, char[][] qual, int matchMode, ICSearchConstants.SearchFor sfor, ICSearchConstants.LimitTo limitTo, boolean caseSensitive) {
        super(matchMode, caseSensitive, limitTo);
        this.qualifications = qual;
        this.searchFor = sfor;
        this.simpleName = name;
    }

    public int matchLevel(ISourceElementCallbackDelegate node, ICSearchConstants.LimitTo limit) {
        if (node instanceof IASTField) {
            if (this.searchFor != ICSearchConstants.FIELD || !this.canAccept(limit)) {
                return 0;
            }
        } else if (node instanceof IASTVariable) {
            if (this.searchFor != ICSearchConstants.VAR || !this.canAccept(limit)) {
                return 0;
            }
        } else if (node instanceof IASTEnumerator) {
            if (this.searchFor != ICSearchConstants.ENUMTOR || !this.canAccept(limit)) {
                return 0;
            }
        } else if (node instanceof IASTParameterDeclaration) {
            if (this.searchFor != ICSearchConstants.VAR || !this.canAccept(limit)) {
                return 0;
            }
        } else if (node instanceof IASTTemplateParameter) {
            if (this.searchFor != ICSearchConstants.VAR || !this.canAccept(limit)) {
                return 0;
            }
        } else {
            return 0;
        }
        char[] nodeName = ((IASTOffsetableNamedElement)node).getNameCharArray();
        if (this.simpleName != null && !this.matchesName(this.simpleName, nodeName)) {
            return 0;
        }
        char[][] qualName = null;
        if (node instanceof IASTEnumerator) {
            IASTEnumerationSpecifier enumeration = ((IASTEnumerator)node).getOwnerEnumerationSpecifier();
            qualName = enumeration.getFullyQualifiedNameCharArrays();
        } else if (node instanceof IASTQualifiedNameElement) {
            qualName = ((IASTQualifiedNameElement)node).getFullyQualifiedNameCharArrays();
        }
        if (qualName != null && !this.matchQualifications(this.qualifications, qualName, true)) {
            return 0;
        }
        return 2;
    }

    public char[] indexEntryPrefix() {
        if (this.searchFor == ICSearchConstants.FIELD) {
            return Index.bestFieldPrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
        }
        if (this.searchFor == ICSearchConstants.VAR) {
            return Index.bestVariablePrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
        }
        if (this.searchFor == ICSearchConstants.ENUMTOR) {
            return Index.bestEnumeratorPrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
        }
        return null;
    }

    protected void resetIndexInfo() {
        this.decodedSimpleName = null;
        this.decodedQualifications = null;
    }

    protected void decodeIndexEntry(IEntryResult entryResult) {
        this.decodedSimpleName = entryResult.extractSimpleName().toCharArray();
        String[] missmatch = entryResult.getEnclosingNames();
        if (missmatch != null) {
            this.decodedQualifications = new char[missmatch.length][];
            int i = 0;
            while (i < missmatch.length) {
                this.decodedQualifications[i] = missmatch[i].toCharArray();
                ++i;
            }
        }
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] fileRefs, int[][] offsets, int[][] offsetLengths, IndexInput input, ICSearchScope scope) throws IOException {
        int i = 0;
        int max = fileRefs.length;
        while (i < max) {
            IndexedFileEntry file = input.getIndexedFile(fileRefs[i]);
            String path = null;
            if (file != null && scope.encloses(path = file.getPath())) {
                int j = 0;
                while (j < offsets[i].length) {
                    BasicSearchMatch match = new BasicSearchMatch();
                    match.setName(new String(this.decodedSimpleName));
                    match.setLocatable(CSearchPattern.getMatchLocatable(offsets[i][j], offsetLengths[i][j]));
                    match.setParentName("");
                    if (this.searchFor == ICSearchConstants.FIELD) {
                        match.setType(72);
                    } else if (this.searchFor == ICSearchConstants.VAR) {
                        match.setType(76);
                    } else if (this.searchFor == ICSearchConstants.ENUMTOR) {
                        match.setType(81);
                    }
                    IFile tempFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
                    if (tempFile != null && tempFile.exists()) {
                        match.setResource((IResource)tempFile);
                    } else {
                        IPath tempPath = PathUtil.getWorkspaceRelativePath(file.getPath());
                        match.setPath(tempPath);
                        match.setReferringElement(tempPath);
                    }
                    requestor.acceptSearchMatch(match);
                    ++j;
                }
            }
            ++i;
        }
    }

    protected boolean matchIndexEntry() {
        if (this.simpleName != null && !this.matchesName(this.simpleName, this.decodedSimpleName)) {
            return false;
        }
        return this.matchQualifications(this.qualifications, this.decodedQualifications);
    }
}

