/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.errorparsers;

import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MakeErrorParser
implements IErrorParser {
    static int getDirectoryLevel(String line) {
        int s = line.indexOf(91);
        int num = 0;
        if (s != -1) {
            int e = line.indexOf(93);
            String number = line.substring(s + 1, e).trim();
            try {
                num = Integer.parseInt(number);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return num;
    }

    public boolean processLine(String line, ErrorParserManager eoParser) {
        int firstColon = line.indexOf(58);
        if (firstColon != -1 && line.startsWith("make")) {
            boolean enter = false;
            String msg = line.substring(firstColon + 1).trim();
            enter = msg.startsWith("Entering directory");
            if (enter || msg.startsWith("Leaving directory")) {
                int s = msg.indexOf(96);
                int e = msg.indexOf(39);
                if (s != -1 && e != -1) {
                    String dir = msg.substring(s + 1, e);
                    if (enter) {
                        int level = MakeErrorParser.getDirectoryLevel(line);
                        int parseLevel = eoParser.getDirectoryLevel();
                        while (level < parseLevel) {
                            eoParser.popDirectory();
                            ++level;
                        }
                        eoParser.pushDirectory((IPath)new Path(dir));
                    } else {
                        eoParser.popDirectory();
                    }
                }
            } else if (msg.startsWith("***")) {
                boolean warning = false;
                if (msg.length() > 4) {
                    String s = msg.substring(3).trim();
                    warning = s.startsWith("Warning");
                }
                if (warning) {
                    eoParser.generateMarker(null, -1, msg, 1, null);
                } else {
                    eoParser.generateMarker(null, -1, msg, 3, null);
                }
            }
        }
        return false;
    }
}

