/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.io.OutputStream;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ScannerInfoConsoleParserFactory {
    public static ConsoleOutputSniffer getESIProviderOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject currentProject, String providerId, IScannerConfigBuilderInfo2 scBuildInfo, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        if (scBuildInfo.isProviderOutputParserEnabled(providerId)) {
            SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(currentProject, scBuildInfo.getSelectedProfileId());
            IScannerInfoConsoleParser clParser = profileInstance.createExternalScannerInfoParser(providerId);
            clParser.startup(currentProject, currentProject.getLocation(), collector, markerGenerator);
            return new ConsoleOutputSniffer(outputStream, errorStream, (IConsoleParser[])new IScannerInfoConsoleParser[]{clParser});
        }
        return null;
    }

    public static ConsoleOutputSniffer getMakeBuilderOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject currentProject, IPath workingDirectory, IScannerConfigBuilderInfo2 scBuildInfo, IMarkerGenerator markerGenerator, IScannerInfoCollector collector) {
        block7: {
            try {
                if (!currentProject.hasNature(ScannerConfigNature.NATURE_ID)) break block7;
                if (scBuildInfo == null) {
                    try {
                        scBuildInfo = ScannerConfigProfileManager.createScannerConfigBuildInfo2(currentProject);
                    }
                    catch (CoreException coreException) {}
                }
                if (scBuildInfo != null && scBuildInfo.isAutoDiscoveryEnabled() && scBuildInfo.isBuildOutputParserEnabled()) {
                    SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(currentProject, scBuildInfo.getSelectedProfileId());
                    IScannerInfoConsoleParser clParser = profileInstance.createBuildOutputParser();
                    if (collector == null) {
                        collector = profileInstance.getScannerInfoCollector();
                    }
                    clParser.startup(currentProject, workingDirectory, collector, (IMarkerGenerator)(scBuildInfo.isProblemReportingEnabled() ? markerGenerator : null));
                    return new ConsoleOutputSniffer(outputStream, errorStream, (IConsoleParser[])new IScannerInfoConsoleParser[]{clParser});
                }
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e.getStatus());
            }
        }
        return null;
    }
}

