/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.command;

import org.eclipse.cdt.debug.mi.core.command.Command;

public class MICommand
extends Command {
    static final String[] empty = new String[0];
    String[] options = empty;
    String[] parameters = empty;
    String operation = new String();
    String fMIVersion;

    public MICommand(String miVersion, String oper) {
        this(miVersion, oper, empty);
    }

    public MICommand(String miVersion, String oper, String[] params) {
        this(miVersion, oper, empty, params);
    }

    public MICommand(String miVersion, String oper, String[] opt, String[] params) {
        this.fMIVersion = miVersion;
        this.operation = oper;
        this.options = opt;
        this.parameters = params;
    }

    public String getMIVersion() {
        return this.fMIVersion;
    }

    public void setMIVersion(String miVersion) {
        this.fMIVersion = miVersion;
    }

    public boolean isMI1() {
        return "mi1".equalsIgnoreCase(this.fMIVersion);
    }

    public boolean isMI2() {
        return "mi2".equalsIgnoreCase(this.fMIVersion);
    }

    public String getOperation() {
        return this.operation;
    }

    protected void setOperation(String op) {
        this.operation = op;
    }

    public String[] getOptions() {
        return this.options;
    }

    public void setOptions(String[] opt) {
        this.options = opt;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setParameters(String[] p) {
        this.parameters = p;
    }

    protected String optionsToString() {
        StringBuffer sb = new StringBuffer();
        if (this.options != null && this.options.length > 0) {
            int i = 0;
            while (i < this.options.length) {
                String option = this.options[i];
                if (option.indexOf(34) != -1 || option.indexOf(92) != -1) {
                    StringBuffer buf = new StringBuffer();
                    int j = 0;
                    while (j < option.length()) {
                        char c = option.charAt(j);
                        if (c == '\"' || c == '\\') {
                            buf.append('\\');
                        }
                        buf.append(c);
                        ++j;
                    }
                    option = buf.toString();
                }
                if (option.indexOf(9) != -1 || option.indexOf(32) != -1) {
                    sb.append(' ').append('\"').append(option).append('\"');
                } else {
                    sb.append(' ').append(option);
                }
                ++i;
            }
        }
        return sb.toString().trim();
    }

    protected String parametersToString() {
        StringBuffer buffer = new StringBuffer();
        if (this.parameters != null && this.parameters.length > 0) {
            if (this.options != null && this.options.length > 0) {
                int i = 0;
                while (i < this.parameters.length) {
                    if (this.parameters[i].startsWith("-")) {
                        buffer.append('-').append('-');
                        break;
                    }
                    ++i;
                }
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.parameters.length) {
                sb.setLength(0);
                String param = this.parameters[i];
                int j = 0;
                while (j < param.length()) {
                    char c = param.charAt(j);
                    if (c == '\"' || c == '\\') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    ++j;
                }
                if (this.containsWhitespace(param)) {
                    sb.insert(0, '\"');
                    sb.append('\"');
                }
                buffer.append(' ').append(sb);
                ++i;
            }
        }
        return buffer.toString().trim();
    }

    public String toString() {
        String p;
        StringBuffer command = new StringBuffer(String.valueOf(this.getToken()) + this.getOperation());
        String opt = this.optionsToString();
        if (opt.length() > 0) {
            command.append(' ').append(opt);
        }
        if ((p = this.parametersToString()).length() > 0) {
            command.append(' ').append(p);
        }
        command.append('\n');
        return command.toString();
    }

    protected boolean containsWhitespace(String s) {
        int i = 0;
        while (i < s.length()) {
            if (Character.isWhitespace(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

