/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.sourcelookup.CDirectorySourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.IDirectorySourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.InternalSourceLookupMessages;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SourceUtils {
    private static final String NAME_COMMON_SOURCE_LOCATIONS = "commonSourceLocations";
    private static final String NAME_SOURCE_LOCATION = "sourceLocation";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_MEMENTO = "memento";

    public static String getCommonSourceLocationsMemento(ICSourceLocation[] locations) {
        Document document = null;
        Exception ex = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(NAME_COMMON_SOURCE_LOCATIONS);
            document.appendChild(element);
            SourceUtils.saveSourceLocations(document, element, locations);
            return CDebugUtils.serializeDocument(document);
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        catch (TransformerException e) {
            ex = e;
        }
        CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 0, "Error saving common source settings.", (Throwable)ex));
        return null;
    }

    private static void saveSourceLocations(Document doc, Element node, ICSourceLocation[] locations) {
        int i = 0;
        while (i < locations.length) {
            block3: {
                Element child = doc.createElement(NAME_SOURCE_LOCATION);
                child.setAttribute(ATTR_CLASS, locations[i].getClass().getName());
                try {
                    child.setAttribute(ATTR_MEMENTO, locations[i].getMemento());
                }
                catch (CoreException e) {
                    CDebugCorePlugin.log(e);
                    break block3;
                }
                node.appendChild(child);
            }
            ++i;
        }
    }

    public static ICSourceLocation[] getCommonSourceLocationsFromMemento(String memento) {
        ICSourceLocation[] result = new ICSourceLocation[]{};
        if (!SourceUtils.isEmpty(memento)) {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                StringReader reader = new StringReader(memento);
                InputSource source = new InputSource(reader);
                Element root = parser.parse(source).getDocumentElement();
                if (root.getNodeName().equalsIgnoreCase(NAME_COMMON_SOURCE_LOCATIONS)) {
                    result = SourceUtils.initializeSourceLocations(root);
                }
            }
            catch (ParserConfigurationException e) {
                CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 0, "Error initializing common source settings.", (Throwable)e));
            }
            catch (SAXException e) {
                CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 0, "Error initializing common source settings.", (Throwable)e));
            }
            catch (IOException e) {
                CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 0, "Error initializing common source settings.", (Throwable)e));
            }
        }
        return result;
    }

    public static ICSourceLocation[] initializeSourceLocations(Element root) {
        LinkedList<ICSourceLocation> sourceLocations = new LinkedList<ICSourceLocation>();
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            block11: {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(NAME_SOURCE_LOCATION)) {
                    String className = entry.getAttribute(ATTR_CLASS);
                    String data = entry.getAttribute(ATTR_MEMENTO);
                    if (className == null || className.trim().length() == 0) {
                        CDebugCorePlugin.log("Unable to restore common source locations - invalid format.");
                    } else {
                        Class clazz = null;
                        try {
                            clazz = CDebugCorePlugin.getDefault().getBundle().loadClass(className);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            CDebugCorePlugin.log(MessageFormat.format("Unable to restore source location - class not found {0}", className));
                            break block11;
                        }
                        ICSourceLocation location = null;
                        try {
                            location = (ICSourceLocation)clazz.newInstance();
                        }
                        catch (IllegalAccessException e) {
                            CDebugCorePlugin.log("Unable to restore source location: " + e.getMessage());
                            break block11;
                        }
                        catch (InstantiationException e) {
                            CDebugCorePlugin.log("Unable to restore source location: " + e.getMessage());
                            break block11;
                        }
                        try {
                            location.initializeFrom(data);
                            sourceLocations.add(location);
                        }
                        catch (CoreException e) {
                            CDebugCorePlugin.log("Unable to restore source location: " + e.getMessage());
                        }
                    }
                }
            }
            ++i;
        }
        return sourceLocations.toArray(new ICSourceLocation[sourceLocations.size()]);
    }

    private static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static ISourceContainer[] convertSourceLocations(ICSourceLocation[] locations) {
        ArrayList<Object> containers = new ArrayList<Object>(locations.length);
        int mappingCount = 0;
        int i = 0;
        while (i < locations.length) {
            if (locations[i] instanceof IProjectSourceLocation) {
                containers.add(new ProjectSourceContainer(((IProjectSourceLocation)locations[i]).getProject(), false));
            } else if (locations[i] instanceof IDirectorySourceLocation) {
                IDirectorySourceLocation d = (IDirectorySourceLocation)locations[i];
                IPath a = d.getAssociation();
                if (a != null) {
                    MappingSourceContainer mapping = new MappingSourceContainer(String.valueOf(InternalSourceLookupMessages.getString("SourceUtils.0")) + ++mappingCount);
                    mapping.addMapEntries(new MapEntrySourceContainer[]{new MapEntrySourceContainer(a, d.getDirectory())});
                    containers.add((Object)mapping);
                }
                containers.add((Object)new CDirectorySourceContainer(d.getDirectory(), d.searchSubfolders()));
            }
            ++i;
        }
        return containers.toArray(new ISourceContainer[containers.size()]);
    }
}

