/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.domsourceindexer;

import java.io.IOException;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMIndexRequest;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class DOMAddFileToIndex
extends DOMIndexRequest {
    protected IFile resource;
    private boolean checkEncounteredHeaders;

    public DOMAddFileToIndex(IFile resource, IPath indexPath, DOMSourceIndexer indexer, boolean checkEncounteredHeaders) {
        super(indexPath, indexer);
        this.resource = resource;
        this.checkEncounteredHeaders = checkEncounteredHeaders;
    }

    public DOMAddFileToIndex(IFile resource, IPath indexPath, DOMSourceIndexer indexer) {
        this(resource, indexPath, indexer, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        IProject resourceProject;
        boolean isHeader;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (this.checkEncounteredHeaders && (isHeader = CoreModel.isValidHeaderUnitName(resourceProject = this.resource.getProject(), this.resource.getName())) && this.indexer.haveEncounteredHeader(resourceProject.getFullPath(), this.resource.getLocation(), true)) {
            return true;
        }
        IIndex index = this.indexer.getIndex(this.indexPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.indexer.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterWrite();
                if (!this.indexDocument(index)) {
                    Object var5_5 = null;
                    monitor.exitWrite();
                    return false;
                }
            }
            catch (IOException e) {
                Util.log(null, "Index I/O Exception: " + e.getMessage() + " on File: " + this.resource.getName(), ICLogConstants.CDT);
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> failed to index " + this.resource + " because of the following exception:");
                    e.printStackTrace();
                }
                Object var5_6 = null;
                monitor.exitWrite();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.exitWrite();
            throw throwable;
        }
        {
            Object var5_8 = null;
            monitor.exitWrite();
            return true;
        }
    }

    protected abstract boolean indexDocument(IIndex var1) throws IOException;

    public String toString() {
        return "indexing " + this.resource.getFullPath();
    }

    public IResource getResource() {
        return this.resource;
    }
}

