/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ILineLocatable;
import org.eclipse.cdt.core.search.IMatchLocatable;
import org.eclipse.cdt.core.search.IOffsetLocatable;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.editor.ExternalSearchFile;
import org.eclipse.cdt.internal.ui.search.CSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.CSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchTableContentProvider;
import org.eclipse.cdt.internal.ui.search.CountLabelProvider;
import org.eclipse.cdt.internal.ui.search.ElementNameSorter;
import org.eclipse.cdt.internal.ui.search.LevelTreeContentProvider;
import org.eclipse.cdt.internal.ui.search.ParentNameSorter;
import org.eclipse.cdt.internal.ui.search.PathNameSorter;
import org.eclipse.cdt.internal.ui.search.actions.GroupAction;
import org.eclipse.cdt.internal.ui.search.actions.SortAction;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CSearchResultLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class CSearchResultPage
extends AbstractTextSearchViewPage {
    private CSearchContentProvider _contentProvider;
    private int _currentSortOrder = 1;
    private int _currentGrouping;
    private SortAction _parentSortAction = new SortAction(CSearchMessages.getString("CSearchResultPage.parent_name"), this, 2);
    private SortAction _pathSortAction = new SortAction(CSearchMessages.getString("CSearchResultPage.path_name"), this, 3);
    private SortAction _elementNameSortAction = new SortAction(CSearchMessages.getString("CSearchResultPage.element_name"), this, 1);
    private GroupAction _groupFileAction;
    private GroupAction _groupFoldersAction;
    private GroupAction _groupProjectAction;
    private GroupAction _groupClassAction;
    private static final String KEY_GROUPING = "org.eclipse.cdt.search.resultpage.grouping";

    public CSearchResultPage() {
        this.initGroupingActions();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.cdt.ui.search_view");
    }

    private void initGroupingActions() {
        this._groupProjectAction = new GroupAction(CSearchMessages.getString("CSearchResultPage.groupby_project"), CSearchMessages.getString("CSearchResultPage.groupby_project.tooltip"), this, 4);
        this._groupProjectAction.setImageDescriptor(CPluginImages.DESC_OBJS_SEARCHHIERPROJECT);
        this._groupFoldersAction = new GroupAction(CSearchMessages.getString("CSearchResultPage.groupby_folder"), CSearchMessages.getString("CSearchResultPage.groupby_folder.tooltip"), this, 3);
        this._groupFoldersAction.setImageDescriptor(CPluginImages.DESC_OBJS_SEARCHHIERFODLER);
        this._groupFileAction = new GroupAction(CSearchMessages.getString("CSearchResultPage.groupby_file"), CSearchMessages.getString("CSearchResultPage.groupby_file.tooltip"), this, 2);
        this._groupFileAction.setImageDescriptor(CPluginImages.DESC_OBJS_TUNIT);
        this._groupClassAction = new GroupAction(CSearchMessages.getString("CSearchResultPage.groupby_class"), CSearchMessages.getString("CSearchResultPage.groupby_class.tooltip"), this, 1);
        this._groupClassAction.setImageDescriptor(CPluginImages.DESC_OBJS_CLASS);
        try {
            this._currentGrouping = this.getSettings().getInt(KEY_GROUPING);
        }
        catch (NumberFormatException numberFormatException) {
            this._currentGrouping = 4;
        }
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activateEditor) throws PartInitException {
        block21: {
            IEditorPart editor = null;
            if (match instanceof CSearchMatch) {
                BasicSearchMatch searchMatch = ((CSearchMatch)match).getSearchMatch();
                if (searchMatch.getResource() != null) {
                    editor = IDE.openEditor((IWorkbenchPage)CUIPlugin.getActivePage(), (IFile)this.getCanonicalFile((IFile)searchMatch.getResource()), (boolean)false);
                    IMatchLocatable searchLocatable = searchMatch.getLocatable();
                    this.showWithMarker(editor, this.getCanonicalFile((IFile)searchMatch.getResource()), searchLocatable, currentOffset, currentLength);
                    return;
                }
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(searchMatch.getPath());
                if (files != null && files.length > 0) {
                    int i = 0;
                    while (i < files.length) {
                        if (EditorUtility.isLinked(files[i])) {
                            try {
                                editor = EditorUtility.openInEditor(files[i]);
                            }
                            catch (PartInitException partInitException) {
                            }
                            catch (CModelException cModelException) {}
                            IMatchLocatable searchLocatable = searchMatch.getLocatable();
                            this.showWithMarker(editor, this.getCanonicalFile(files[i]), searchLocatable, currentOffset, currentLength);
                            return;
                        }
                        ++i;
                    }
                }
                try {
                    IEditorInput input = EditorUtility.getEditorInput((Object)new ExternalSearchFile(searchMatch.getPath(), searchMatch));
                    IWorkbenchPage p = CUIPlugin.getActivePage();
                    IEditorPart editorPart = p.openEditor(input, "org.eclipse.cdt.ui.editor.ExternalSearchEditor");
                    if (!(editorPart instanceof ITextEditor)) break block21;
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    IMatchLocatable searchLocatable = searchMatch.getLocatable();
                    int startOffset = 0;
                    int length = 0;
                    if (searchLocatable instanceof IOffsetLocatable) {
                        startOffset = ((IOffsetLocatable)searchLocatable).getNameStartOffset();
                        length = ((IOffsetLocatable)searchLocatable).getNameEndOffset() - startOffset;
                    } else if (searchLocatable instanceof ILineLocatable) {
                        int tempstartLine = ((ILineLocatable)searchLocatable).getStartLine();
                        int tempendLine = ((ILineLocatable)searchLocatable).getEndLine();
                        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)input);
                        if (doc == null) {
                            return;
                        }
                        try {
                            startOffset = doc.getLineOffset(tempstartLine - 1);
                            length = doc.getLineLength(tempstartLine - 1);
                        }
                        catch (BadLocationException badLocationException) {}
                        if (tempendLine > 0 && tempendLine > tempstartLine) {
                            try {
                                int endOffset = doc.getLineOffset(tempendLine - 1);
                                length = endOffset - startOffset;
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                    }
                    textEditor.selectAndReveal(startOffset, length);
                }
                catch (CModelException cModelException) {
                }
                catch (CoreException coreException) {}
            }
        }
    }

    protected void elementsChanged(Object[] objects) {
        if (this._contentProvider != null) {
            this._contentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this._contentProvider != null) {
            this._contentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setSorter(new ViewerSorter());
        CSearchResultLabelProvider labelProvider = new CSearchResultLabelProvider();
        labelProvider.setOrder(0);
        viewer.setLabelProvider((IBaseLabelProvider)new CountLabelProvider(this, (ILabelProvider)labelProvider));
        this._contentProvider = new LevelTreeContentProvider((AbstractTreeViewer)viewer, this._currentGrouping);
        viewer.setContentProvider((IContentProvider)this._contentProvider);
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new CountLabelProvider(this, (ILabelProvider)new CSearchResultLabelProvider()));
        this._contentProvider = new CSearchTableContentProvider(viewer);
        viewer.setContentProvider((IContentProvider)this._contentProvider);
        this.setSortOrder(this._currentSortOrder);
    }

    private void showWithMarker(IEditorPart editor, IFile file, IMatchLocatable searchLocatable, int offset, int length) throws PartInitException {
        try {
            IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            if (searchLocatable instanceof IOffsetLocatable) {
                attributes.put("charStart", new Integer(offset));
                attributes.put("charEnd", new Integer(offset + length));
            } else if (searchLocatable instanceof ILineLocatable) {
                attributes.put("lineNumber", new Integer(offset));
            }
            marker.setAttributes(attributes);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException e) {
            throw new PartInitException("Search Result Error", (Throwable)e);
        }
    }

    public void setSortOrder(int sortOrder) {
        this._currentSortOrder = sortOrder;
        StructuredViewer viewer = this.getViewer();
        CountLabelProvider lpWrapper = (CountLabelProvider)viewer.getLabelProvider();
        ((CSearchResultLabelProvider)lpWrapper.getLabelProvider()).setOrder(sortOrder);
        if (sortOrder == 1) {
            viewer.setSorter((ViewerSorter)new ElementNameSorter());
        } else if (sortOrder == 3) {
            viewer.setSorter((ViewerSorter)new PathNameSorter());
        } else {
            viewer.setSorter((ViewerSorter)new ParentNameSorter());
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(CSearchMessages.getString("CSearchResultPage.sort"));
        sortMenu.add((IAction)this._elementNameSortAction);
        sortMenu.add((IAction)this._pathSortAction);
        sortMenu.add((IAction)this._parentSortAction);
        this._elementNameSortAction.setChecked(this._currentSortOrder == this._elementNameSortAction.getSortOrder());
        this._pathSortAction.setChecked(this._currentSortOrder == this._pathSortAction.getSortOrder());
        this._parentSortAction.setChecked(this._currentSortOrder == this._parentSortAction.getSortOrder());
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    private void addGroupActions(IToolBarManager mgr) {
        mgr.appendToGroup("group.viewerSetup", (IAction)this._groupProjectAction);
        mgr.appendToGroup("group.viewerSetup", (IAction)this._groupFoldersAction);
        mgr.appendToGroup("group.viewerSetup", (IAction)this._groupFileAction);
        mgr.appendToGroup("group.viewerSetup", (IAction)this._groupClassAction);
        this.updateGroupingActions();
    }

    public void setGrouping(int groupOrder) {
        this._currentGrouping = groupOrder;
        StructuredViewer viewer = this.getViewer();
        LevelTreeContentProvider cp = (LevelTreeContentProvider)viewer.getContentProvider();
        cp.setLevel(groupOrder);
        this.updateGroupingActions();
        this.getSettings().put(KEY_GROUPING, this._currentGrouping);
    }

    private void updateGroupingActions() {
        this._groupProjectAction.setChecked(this._currentGrouping == 4);
        this._groupFoldersAction.setChecked(this._currentGrouping == 3);
        this._groupFileAction.setChecked(this._currentGrouping == 2);
        this._groupClassAction.setChecked(this._currentGrouping == 1);
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        if (this.getLayout() != 1) {
            this.addGroupActions(tbm);
        }
    }

    private IFile getCanonicalFile(IFile originalFile) {
        if (originalFile == null) {
            return null;
        }
        File tempFile = originalFile.getRawLocation().toFile();
        String canonicalPath = null;
        try {
            canonicalPath = tempFile.getCanonicalPath();
        }
        catch (IOException iOException) {}
        if (canonicalPath != null && !originalFile.isLinked()) {
            Path path = new Path(canonicalPath);
            IFile[] matches = CUIPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
            if (matches.length > 0) {
                originalFile = matches[0];
            }
        }
        return originalFile;
    }
}

