/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.IWorkingCopyProvider;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.ui.CElementAdapterFactory;
import org.eclipse.cdt.internal.ui.ResourceAdapterFactory;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleManager;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.CustomBufferFactory;
import org.eclipse.cdt.internal.ui.editor.ExternalSearchDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.SharedTextColors;
import org.eclipse.cdt.internal.ui.editor.WorkingCopyManager;
import org.eclipse.cdt.internal.ui.editor.asm.AsmTextTools;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.cdt.internal.ui.text.c.hover.CEditorTextHoverDescriptor;
import org.eclipse.cdt.internal.ui.text.folding.CFoldingStructureProviderRegistry;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.internal.ui.util.ProblemMarkerManager;
import org.eclipse.cdt.internal.ui.util.Util;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.osgi.framework.BundleContext;

public class CUIPlugin
extends AbstractUIPlugin {
    private ISharedTextColors fSharedTextColors;
    public static final String PLUGIN_ID = "org.eclipse.cdt.ui";
    public static final String PLUGIN_CORE_ID = "org.eclipse.cdt.core";
    public static final String EDITOR_ID = "org.eclipse.cdt.ui.editor.CEditor";
    public static final String CVIEW_ID = "org.eclipse.cdt.ui.CView";
    public static final String C_PROBLEMMARKER = "org.eclipse.cdt.core.problem";
    public static final String C_PROJECT_WIZARD_ID = "org.eclipse.cdt.ui.wizards.StdCWizard";
    public static final String CPP_PROJECT_WIZARD_ID = "org.eclipse.cdt.ui.wizards.StdCCWizard";
    public static final String CWIZARD_CATEGORY_ID = "org.eclipse.cdt.ui.newCWizards";
    public static final String CCWIZARD_CATEGORY_ID = "org.eclipse.cdt.ui.newCCWizards";
    public static final String SEARCH_ACTION_SET_ID = "org.eclipse.cdt.ui.SearchActionSet";
    public static final String BUILDER_ID = "org.eclipse.cdt.core.cbuilder";
    private static CUIPlugin fgCPlugin;
    private static ResourceBundle fgResourceBundle;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private CEditorTextHoverDescriptor[] fCEditorTextHoverDescriptors;
    private CFoldingStructureProviderRegistry fFoldingStructureProviderRegistry;
    private IPreferenceStore fCombinedPreferenceStore;
    static String SEPARATOR;
    private static final String CONTENTASSIST = "org.eclipse.cdt.ui/debug/contentassist";
    public static final String ID_CPERSPECTIVE = "org.eclipse.cdt.ui.CPerspective";
    public static final String ID_CHIERARCHY_PERSPECTIVE = "org.eclipse.cdt.ui.CHierarchyPerspective";
    public static final String ID_CBROWSING_PERSPECTIVE = "org.eclipse.cdt.ui.CBrowsingPerspective";
    public static String ID_PROJECTS_VIEW;
    public static String ID_NAMESPACES_VIEW;
    public static String ID_TYPES_VIEW;
    public static String ID_MEMBERS_VIEW;
    public static final String ID_TYPE_HIERARCHY = "org.eclipse.cdt.ui.TypeHierarchyView";
    private static final String CUSTOM_TEMPLATES_KEY = "org.eclipse.cdt.ui.text.templates.custom";
    public static final String ID_CELEMENT_CREATION_ACTION_SET = "org.eclipse.cdt.ui.CElementCreationActionSet";
    private CoreModel fCoreModel;
    private CDocumentProvider fDocumentProvider;
    private ExternalSearchDocumentProvider fExternalDocumentProvider;
    private IBufferFactory fBufferFactory;
    private WorkingCopyManager fWorkingCopyManager;
    private CTextTools fTextTools;
    private AsmTextTools fAsmTextTools;
    private ProblemMarkerManager fProblemMarkerManager;
    private BuildConsoleManager fBuildConsoleManager;
    private ResourceAdapterFactory fResourceAdapterFactory;
    private CElementAdapterFactory fCElementAdapterFactory;
    private ContributionContextTypeRegistry fContextTypeRegistry;
    private TemplateStore fTemplateStore;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        SEPARATOR = System.getProperty("file.separator");
        ID_PROJECTS_VIEW = "org.eclipse.cdt.ui.ProjectsView";
        ID_NAMESPACES_VIEW = "org.eclipse.cdt.ui.NamespacesView";
        ID_TYPES_VIEW = "org.eclipse.cdt.ui.TypesView";
        ID_MEMBERS_VIEW = "org.eclipse.cdt.ui.MembersView";
        try {
            fgResourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.internal.ui.CPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            fgResourceBundle = null;
        }
    }

    public synchronized IBufferFactory getBufferFactory() {
        if (this.fBufferFactory == null) {
            this.fBufferFactory = new CustomBufferFactory();
        }
        return this.fBufferFactory;
    }

    public static IWorkingCopy[] getSharedWorkingCopies() {
        return CCorePlugin.getSharedWorkingCopies((IBufferFactory)CUIPlugin.getDefault().getBufferFactory());
    }

    public static String getResourceString(String key) {
        try {
            return fgResourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
        catch (NullPointerException nullPointerException) {
            return "#" + key + "#";
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getFormattedString(String key, String arg) {
        return MessageFormat.format(CUIPlugin.getResourceString(key), arg);
    }

    public static String getFormattedString(String key, String[] args) {
        return MessageFormat.format(CUIPlugin.getResourceString(key), args);
    }

    public static ResourceBundle getResourceBundle() {
        return fgResourceBundle;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return CUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = CUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = CUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static CUIPlugin getDefault() {
        return fgCPlugin;
    }

    public void log(Throwable e) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", e));
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void logErrorMessage(String message) {
        this.log((IStatus)new Status(4, CUIPlugin.getPluginId(), 10001, message, null));
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s, boolean logError) {
        if (logError) {
            CUIPlugin.getDefault().log(s);
        }
        if (s != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t, boolean logError) {
        IStatus status;
        if (logError) {
            CUIPlugin.getDefault().log(t);
        }
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, PLUGIN_ID, -1, "Internal Error: ", t);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public CUIPlugin() {
        fgCPlugin = this;
        this.fDocumentProvider = null;
        this.fTextTools = null;
    }

    public synchronized CDocumentProvider getDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new CDocumentProvider();
        }
        return this.fDocumentProvider;
    }

    public synchronized ExternalSearchDocumentProvider getExternalSearchDocumentProvider() {
        if (this.fExternalDocumentProvider == null) {
            this.fExternalDocumentProvider = new ExternalSearchDocumentProvider();
        }
        return this.fExternalDocumentProvider;
    }

    public synchronized IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            CDocumentProvider provider = this.getDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(provider);
        }
        return this.fWorkingCopyManager;
    }

    public CTextTools getTextTools() {
        if (this.fTextTools == null) {
            this.fTextTools = new CTextTools(this.getPreferenceStore(), CCorePlugin.getDefault().getPluginPreferences());
        }
        return this.fTextTools;
    }

    public AsmTextTools getAsmTextTools() {
        if (this.fAsmTextTools == null) {
            this.fAsmTextTools = new AsmTextTools(this.getPreferenceStore(), CCorePlugin.getDefault().getPluginPreferences());
        }
        return this.fAsmTextTools;
    }

    public IBuildConsoleManager getConsoleManager() {
        if (this.fBuildConsoleManager == null) {
            this.fBuildConsoleManager = new BuildConsoleManager();
            this.fBuildConsoleManager.startup();
        }
        return this.fBuildConsoleManager;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.configurePluginDebugOptions();
        this.registerAdapters();
        IWorkingCopyProvider workingCopyProvider = new IWorkingCopyProvider(){

            public IWorkingCopy[] getWorkingCopies() {
                return CUIPlugin.getSharedWorkingCopies();
            }
        };
        AllTypesCache.initialize((IWorkingCopyProvider)workingCopyProvider);
        CCorePlugin.getDefault().getDOM().setWorkingCopyProvider(workingCopyProvider);
    }

    public void stop(BundleContext context) throws Exception {
        AllTypesCache.terminate();
        if (this.fTextTools != null) {
            this.fTextTools.dispose();
        }
        if (this.fImageDescriptorRegistry != null) {
            this.fImageDescriptorRegistry.dispose();
        }
        if (this.fBuildConsoleManager != null) {
            this.fBuildConsoleManager.shutdown();
            this.fBuildConsoleManager = null;
        }
        this.unregisterAdapters();
        if (this.fWorkingCopyManager != null) {
            this.fWorkingCopyManager.shutdown();
            this.fWorkingCopyManager = null;
        }
        if (this.fDocumentProvider != null) {
            this.fDocumentProvider.shutdown();
            this.fDocumentProvider = null;
        }
        Refactoring.getUndoManager().shutdown();
        super.stop(context);
    }

    public CoreModel getCoreModel() {
        return this.fCoreModel;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return CUIPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    protected void registerAdapters() {
        this.fResourceAdapterFactory = new ResourceAdapterFactory();
        this.fCElementAdapterFactory = new CElementAdapterFactory();
        IAdapterManager manager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fResourceAdapterFactory, (Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fCElementAdapterFactory, (Class)clazz2);
    }

    private void unregisterAdapters() {
        IAdapterManager manager = Platform.getAdapterManager();
        manager.unregisterAdapters((IAdapterFactory)this.fResourceAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fCElementAdapterFactory);
    }

    public ISharedTextColors getSharedTextColors() {
        if (this.fSharedTextColors == null) {
            this.fSharedTextColors = new SharedTextColors();
        }
        return this.fSharedTextColors;
    }

    public void configurePluginDebugOptions() {
        String option;
        if (this.isDebugging() && (option = Platform.getDebugOption((String)CONTENTASSIST)) != null) {
            Util.VERBOSE_CONTENTASSIST = option.equalsIgnoreCase("true");
        }
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(CCorePlugin.getDefault().getPluginPreferences()), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = CUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input)) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static IEditorPart[] getInstanciatedEditors() {
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = CUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int windowIndex = 0;
        while (windowIndex < windows.length) {
            IWorkbenchPage[] pages = windows[windowIndex].getPages();
            int pageIndex = 0;
            while (pageIndex < pages.length) {
                IEditorReference[] references = pages[pageIndex].getEditorReferences();
                int refIndex = 0;
                while (refIndex < references.length) {
                    IEditorPart editor = references[refIndex].getEditor(false);
                    if (editor != null) {
                        result.add(editor);
                    }
                    ++refIndex;
                }
                ++pageIndex;
            }
            ++windowIndex;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    public CEditorTextHoverDescriptor[] getCEditorTextHoverDescriptors() {
        if (this.fCEditorTextHoverDescriptors == null) {
            this.fCEditorTextHoverDescriptors = CEditorTextHoverDescriptor.getContributedHovers();
            ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

                public IConfigurationElement getConfigurationElement(Object object) {
                    return ((CEditorTextHoverDescriptor)object).getConfigurationElement();
                }
            };
            sorter.sort((Object[])this.fCEditorTextHoverDescriptors);
            int length = this.fCEditorTextHoverDescriptors.length;
            int first = -1;
            int last = length - 1;
            int problemHoverIndex = -1;
            int annotationHoverIndex = -1;
            int i = 0;
            while (i < length) {
                if (!this.fCEditorTextHoverDescriptors[i].getId().startsWith(PLUGIN_ID)) {
                    if (problemHoverIndex != -1 && annotationHoverIndex != -1) {
                        last = i - 1;
                        break;
                    }
                } else {
                    if (first == -1) {
                        first = i;
                    }
                    if (this.fCEditorTextHoverDescriptors[i].getId().equals("org.eclipse.cdt.ui.AnnotationHover")) {
                        annotationHoverIndex = i;
                    } else if (this.fCEditorTextHoverDescriptors[i].getId().equals("org.eclipse.cdt.ui.ProblemHover")) {
                        problemHoverIndex = i;
                    }
                }
                ++i;
            }
            CEditorTextHoverDescriptor hoverDescriptor = null;
            if (first > -1 && problemHoverIndex > -1 && problemHoverIndex != first) {
                hoverDescriptor = this.fCEditorTextHoverDescriptors[first];
                this.fCEditorTextHoverDescriptors[first] = this.fCEditorTextHoverDescriptors[problemHoverIndex];
                this.fCEditorTextHoverDescriptors[problemHoverIndex] = hoverDescriptor;
                if (annotationHoverIndex == first) {
                    annotationHoverIndex = problemHoverIndex;
                }
            }
            if (annotationHoverIndex > -1 && annotationHoverIndex != last) {
                hoverDescriptor = this.fCEditorTextHoverDescriptors[last];
                this.fCEditorTextHoverDescriptors[last] = this.fCEditorTextHoverDescriptors[annotationHoverIndex];
                this.fCEditorTextHoverDescriptors[annotationHoverIndex] = hoverDescriptor;
            }
        }
        return this.fCEditorTextHoverDescriptors;
    }

    public void resetCEditorTextHoverDescriptors() {
        this.fCEditorTextHoverDescriptors = null;
    }

    public synchronized CFoldingStructureProviderRegistry getFoldingStructureProviderRegistry() {
        if (this.fFoldingStructureProviderRegistry == null) {
            this.fFoldingStructureProviderRegistry = new CFoldingStructureProviderRegistry();
        }
        return this.fFoldingStructureProviderRegistry;
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.fContextTypeRegistry == null) {
            this.fContextTypeRegistry = new ContributionContextTypeRegistry();
            this.fContextTypeRegistry.addContextType("org.eclipse.cdt.ui.text.templates.c");
        }
        return this.fContextTypeRegistry;
    }

    public TemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            this.fTemplateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), CUSTOM_TEMPLATES_KEY);
            try {
                this.fTemplateStore.load();
            }
            catch (IOException e) {
                this.log(e);
            }
        }
        return this.fTemplateStore;
    }
}

