/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.refactoring.ASTManager;
import org.eclipse.cdt.internal.refactoring.CRefactoringArgument;
import org.eclipse.cdt.internal.refactoring.CRenameProcessor;
import org.eclipse.cdt.internal.refactoring.Messages;
import org.eclipse.cdt.refactoring.CRefactoringMatch;
import org.eclipse.cdt.refactoring.CRefactory;
import org.eclipse.cdt.refactoring.ICRefactoringSearch;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public abstract class CRenameProcessorDelegate {
    private CRenameProcessor fTopProcessor;
    private ArrayList fMatches = null;
    protected String fProcessorBaseName;
    private int fAvailableOptions = 151;
    private int fOptionsForcingPreview;
    private int fOptionsEnablingScope = this.fOptionsForcingPreview = 182;
    static /* synthetic */ Class class$0;

    protected CRenameProcessorDelegate(CRenameProcessor topProcessor, String name) {
        this.fTopProcessor = topProcessor;
        this.fProcessorBaseName = name;
    }

    public final CRefactoringArgument getArgument() {
        return this.fTopProcessor.getArgument();
    }

    public final String getReplacementText() {
        return this.fTopProcessor.getReplacementText();
    }

    public final int getSelectedScope() {
        return this.fTopProcessor.getScope();
    }

    public final int getSelectedOptions() {
        return this.fTopProcessor.getSelectedOptions();
    }

    public final String getSelectedWorkingSet() {
        return this.fTopProcessor.getWorkingSet();
    }

    public final CRefactory getManager() {
        return this.fTopProcessor.getManager();
    }

    public final ASTManager getAstManager() {
        return this.fTopProcessor.getAstManager();
    }

    public final String getProcessorName() {
        String identifier = this.getArgument().getName();
        if (identifier != null) {
            return MessageFormat.format(Messages.getString("CRenameProcessorDelegate.wizard.title"), this.fProcessorBaseName, identifier);
        }
        return null;
    }

    public void setAvailableOptions(int options) {
        this.fAvailableOptions = options;
    }

    final int getAvailableOptions() {
        return this.fAvailableOptions;
    }

    public void setOptionsForcingPreview(int options) {
        this.fOptionsForcingPreview = options;
    }

    final int getOptionsForcingPreview() {
        return this.fOptionsForcingPreview;
    }

    public void setOptionsEnablingScope(int options) {
        this.fOptionsEnablingScope = options;
    }

    final int getOptionsEnablingScope() {
        return this.fOptionsEnablingScope;
    }

    protected int getSearchScope() {
        return this.getSelectedScope();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        String msg;
        RefactoringStatus result = new RefactoringStatus();
        monitor.beginTask(Messages.getString("CRenameProcessorDelegate.task.checkFinalCondition"), 2);
        IFile file = this.getArgument().getSourceFile();
        this.fMatches = new ArrayList();
        ICRefactoringSearch txtSearch = this.getManager().getTextSearch();
        IStatus stat = txtSearch.searchWord(this.getSearchScope(), file, this.getSelectedWorkingSet(), this.getManager().getCCppPatterns(), this.getArgument().getName(), (IProgressMonitor)new SubProgressMonitor(monitor, 1), this.fMatches);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        result.merge(RefactoringStatus.create((IStatus)stat));
        if (result.hasFatalError()) {
            return result;
        }
        this.selectMatchesByLocation(this.fMatches);
        this.analyzeTextMatches(this.fMatches, (IProgressMonitor)new SubProgressMonitor(monitor, 1), result);
        if (result.hasFatalError()) {
            return result;
        }
        HashSet<IFile> fileset = new HashSet<IFile>();
        int potentialMatchCount = 0;
        int commentCount = 0;
        Iterator iter = this.fMatches.iterator();
        while (iter.hasNext()) {
            CRefactoringMatch tm = (CRefactoringMatch)iter.next();
            if (tm.isInComment()) {
                ++commentCount;
                fileset.add(tm.getFile());
                continue;
            }
            switch (tm.getAstInformation()) {
                case 3: {
                    iter.remove();
                    break;
                }
                case 0: {
                    ++potentialMatchCount;
                    fileset.add(tm.getFile());
                    break;
                }
                default: {
                    fileset.add(tm.getFile());
                }
            }
        }
        if (potentialMatchCount != 0) {
            msg = null;
            msg = potentialMatchCount == 1 ? Messages.getString("CRenameProcessorDelegate.warning.potentialMatch.singular") : MessageFormat.format(Messages.getString("CRenameProcessorDelegate.warning.potentialMatch.plural"), new Integer(potentialMatchCount));
            result.addWarning(msg);
        }
        if (commentCount != 0) {
            msg = null;
            msg = commentCount == 1 ? Messages.getString("CRenameProcessorDelegate.warning.commentMatch.singular") : MessageFormat.format(Messages.getString("CRenameProcessorDelegate.warning.commentMatch.plural"), new Integer(commentCount));
            result.addWarning(msg);
        }
        IFile[] files = fileset.toArray(new IFile[fileset.size()]);
        if (context != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ValidateEditChecker editChecker = (ValidateEditChecker)context.getChecker((Class)clazz);
            editChecker.addFiles(files);
        }
        monitor.done();
        return result;
    }

    protected void analyzeTextMatches(ArrayList matches, IProgressMonitor monitor, RefactoringStatus status) {
        CRefactoringArgument argument = this.getArgument();
        IBinding[] renameBindings = this.getBindingsToBeRenamed(status);
        if (renameBindings != null && renameBindings.length > 0 && argument.getArgumentKind() != 0) {
            ASTManager mngr = this.getAstManager();
            mngr.setValidBindings(renameBindings);
            mngr.setRenameTo(this.getReplacementText());
            mngr.analyzeTextMatches(matches, monitor, status);
        }
    }

    private void selectMatchesByLocation(ArrayList matches) {
        int acceptTextLocation = this.getAcceptedLocations(this.getSelectedOptions());
        Iterator iter = matches.iterator();
        while (iter.hasNext()) {
            CRefactoringMatch match = (CRefactoringMatch)iter.next();
            int location = match.getLocation();
            if (location == 0 || (location & acceptTextLocation) != 0) continue;
            iter.remove();
        }
    }

    protected int getAcceptedLocations(int selectedOptions) {
        return selectedOptions;
    }

    /*
     * Unable to fully structure code
     */
    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fMatches.size() == 0) {
            return null;
        }
        Collections.sort(this.fMatches, new Comparator(){

            public int compare(Object o1, Object o2) {
                CRefactoringMatch m1 = (CRefactoringMatch)o1;
                CRefactoringMatch m2 = (CRefactoringMatch)o2;
                IFile f1 = m1.getFile();
                IFile f2 = m2.getFile();
                int cmp = f1.getName().compareTo(f2.getName());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = f1.getFullPath().toString().compareTo(f2.getFullPath().toString());
                if (cmp != 0) {
                    return cmp;
                }
                return m1.getOffset() - m2.getOffset();
            }
        });
        pm.beginTask(Messages.getString("CRenameProcessorDelegate.task.createChange"), this.fMatches.size());
        identifier = this.getArgument().getName();
        replacement = this.getReplacementText();
        overallChange = new CompositeChange(this.getProcessorName());
        file = null;
        fileChange = null;
        fileEdit = null;
        iter = this.fMatches.iterator();
        while (iter.hasNext()) {
            match = (CRefactoringMatch)iter.next();
            switch (match.getAstInformation()) {
                case 3: {
                    break;
                }
                ** case 0:
                ** case 2:
lbl18:
                // 2 sources

                default: {
                    if (match.getAstInformation() != 3) {
                        mfile = match.getFile();
                        if (file == null || !file.equals((Object)mfile)) {
                            file = mfile;
                            fileEdit = new MultiTextEdit();
                            fileChange = new TextFileChange(file.getName(), file);
                            fileChange.setEdit((TextEdit)fileEdit);
                            overallChange.add((Change)fileChange);
                        }
                        replaceEdit = new ReplaceEdit(match.getOffset(), identifier.length(), replacement);
                        fileEdit.addChild((TextEdit)replaceEdit);
                        editGroup = new TextEditGroup(match.getLabel(), (TextEdit)replaceEdit);
                        changeGroup = new TextEditChangeGroup((TextChange)fileChange, editGroup);
                        fileChange.addTextEditChangeGroup(changeGroup);
                    }
                    pm.worked(1);
                }
            }
        }
        return overallChange;
    }

    protected IBinding[] getBindingsToBeRenamed(RefactoringStatus status) {
        return new IBinding[]{this.getArgument().getBinding()};
    }
}

