/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.index.Indexer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.cdt.internal.ui.search.CSearchScopeFactory;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.internal.ui.util.RowLayouter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CSearchPage
extends DialogPage
implements ISearchPage,
ICSearchConstants {
    public static final String EXTENSION_POINT_ID = "org.eclipse.cdt.ui.CSearchPage";
    private static final String PAGE_NAME = "CSearchPage";
    private static final String STORE_CASE_SENSITIVE = "CSearchPageCASE_SENSITIVE";
    public static final String EXTERNALMATCH_ENABLED = "externMatchEnable";
    public static final String EXTERNALMATCH_VISIBLE = "externMatchVisible";
    private static List fgPreviousSearchPatterns = new ArrayList(20);
    private Button[] fSearchFor;
    private ICSearchConstants.SearchFor[] fSearchForValues;
    private String[] fSearchForText = new String[]{CSearchMessages.getString("CSearchPage.searchFor.classStruct"), CSearchMessages.getString("CSearchPage.searchFor.function"), CSearchMessages.getString("CSearchPage.searchFor.variable"), CSearchMessages.getString("CSearchPage.searchFor.union"), CSearchMessages.getString("CSearchPage.searchFor.method"), CSearchMessages.getString("CSearchPage.searchFor.field"), CSearchMessages.getString("CSearchPage.searchFor.enum"), CSearchMessages.getString("CSearchPage.searchFor.enumr"), CSearchMessages.getString("CSearchPage.searchFor.namespace"), CSearchMessages.getString("CSearchPage.searchFor.typedef"), CSearchMessages.getString("CSearchPage.searchFor.macro"), CSearchMessages.getString("CSearchPage.searchFor.any")};
    private Button[] fLimitTo;
    private static final int LIMIT_TO_ALL = 3;
    private static final int LIMIT_TO_DEFINITIONS = 1;
    private ICSearchConstants.LimitTo[] fLimitToValues = new ICSearchConstants.LimitTo[]{ICSearchConstants.DECLARATIONS_DEFINITIONS, ICSearchConstants.DEFINITIONS, ICSearchConstants.REFERENCES, ICSearchConstants.ALL_OCCURRENCES};
    private String[] fLimitToText = new String[]{CSearchMessages.getString("CSearchPage.limitTo.declarations"), CSearchMessages.getString("CSearchPage.limitTo.definitions"), CSearchMessages.getString("CSearchPage.limitTo.references"), CSearchMessages.getString("CSearchPage.limitTo.allOccurrences")};
    private SearchPatternData fInitialData;
    private IStructuredSelection fStructuredSelection;
    private ICElement fCElement;
    private boolean fFirstTime = true;
    private IDialogSettings fDialogSettings;
    private boolean fIsCaseSensitive;
    private Combo fPattern;
    private ISearchPageContainer fContainer;
    private Button fCaseSensitive;
    private IStatusLineManager fLineManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CSearchPage() {
        int size = CSearchPattern.fSearchForValues.length;
        this.fSearchForValues = new ICSearchConstants.SearchFor[size + 1];
        System.arraycopy(CSearchPattern.fSearchForValues, 0, this.fSearchForValues, 0, size);
        this.fSearchForValues[size] = ICSearchConstants.UNKNOWN_SEARCH_FOR;
    }

    public boolean performAction() {
        this.fLineManager.setErrorMessage(null);
        SearchPatternData data = this.getPatternData();
        IWorkspace workspace = CUIPlugin.getWorkspace();
        ICSearchScope scope = null;
        String scopeDescription = "";
        switch (this.getContainer().getSelectedScope()) {
            case 3: {
                if (this.fStructuredSelection == null || !this.fStructuredSelection.iterator().hasNext()) break;
                scopeDescription = CSearchMessages.getString("ProjectScope");
                scope = CSearchScopeFactory.getInstance().createEnclosingProjectScope(this.fStructuredSelection);
                break;
            }
            case 1: {
                if (this.fStructuredSelection != null && this.fStructuredSelection.iterator().hasNext()) {
                    scopeDescription = CSearchMessages.getString("SelectionScope");
                    scope = CSearchScopeFactory.getInstance().createCSearchScope(this.fStructuredSelection);
                    break;
                }
            }
            case 0: {
                scopeDescription = CSearchMessages.getString("WorkspaceScope");
                scope = SearchEngine.createWorkspaceScope();
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                if (workingSets == null || workingSets.length < 1) {
                    return false;
                }
                scopeDescription = CSearchMessages.getFormattedString("WorkingSetScope", CSearchUtil.toString(workingSets));
                scope = CSearchScopeFactory.getInstance().createCSearchScope(this.getContainer().getSelectedWorkingSets());
                CSearchUtil.updateLRUWorkingSets(this.getContainer().getSelectedWorkingSets());
            }
        }
        data.cElement = null;
        LinkedList<ICSearchConstants.SearchFor> searching = null;
        if (data.searchFor.contains(ICSearchConstants.UNKNOWN_SEARCH_FOR)) {
            searching = new LinkedList<ICSearchConstants.SearchFor>();
            int i = 0;
            while (i < this.fSearchFor.length - 1) {
                searching.add(this.fSearchForValues[i]);
                ++i;
            }
            searching.add(ICSearchConstants.MACRO);
            searching.add(ICSearchConstants.TYPEDEF);
        } else {
            searching = data.searchFor;
        }
        CSearchQuery job = new CSearchQuery(workspace, data.pattern, data.isCaseSensitive, searching, data.limitTo, scope, scopeDescription);
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)job);
        return true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(768));
        RowLayouter layouter = new RowLayouter(layout.numColumns);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 18;
        layouter.setDefaultGridData(gd, 0);
        layouter.setDefaultGridData(gd, 1);
        layouter.setDefaultSpan();
        layouter.perform(this.createExpression(result));
        layouter.perform(this.createSearchFor(result), this.createLimitTo(result), -1);
        SelectionAdapter cElementInitializer = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (CSearchPage.this.getSearchFor() == ((CSearchPage)CSearchPage.this).fInitialData.searchFor) {
                    CSearchPage.this.fCElement = ((CSearchPage)CSearchPage.this).fInitialData.cElement;
                } else {
                    CSearchPage.this.fCElement = null;
                }
                CSearchPage.this.handleAllElements(event);
                List searchFor = CSearchPage.this.getSearchFor();
                CSearchPage.this.getContainer().setPerformActionEnabled(searchFor.size() != 0 && CSearchPage.this.getPattern().length() > 0);
                CSearchPage.this.setLimitTo(searchFor);
                CSearchPage.this.updateCaseSensitiveCheckbox();
            }
        };
        int i = 0;
        while (i < this.fSearchFor.length) {
            this.fSearchFor[i].addSelectionListener((SelectionListener)cElementInitializer);
            ++i;
        }
        this.setControl((Control)result);
        this.fLineManager = this.getStatusLineManager();
        this.setIndexerMessages();
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)result, "org.eclipse.cdt.ui.cdt_u_search");
    }

    private void setIndexerMessages() {
        if (this.fLineManager == null) {
            return;
        }
        if (Indexer.indexEnabledOnAllProjects()) {
            return;
        }
        if (Indexer.indexEnabledOnAnyProjects()) {
            this.fLineManager.setErrorMessage(CSearchMessages.getString("CSearchPage.warning.indexersomeprojects"));
        } else {
            this.fLineManager.setErrorMessage(CSearchMessages.getString("CSearchPage.warning.indexernoprojects"));
        }
    }

    private IStatusLineManager getStatusLineManager() {
        IWorkbenchPage page;
        IWorkbenchWindow wbWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wbWindow != null && (page = wbWindow.getActivePage()) != null) {
            IWorkbenchPartSite workbenchSite = page.getActivePart().getSite();
            if (workbenchSite instanceof IViewSite) {
                return ((IViewSite)workbenchSite).getActionBars().getStatusLineManager();
            }
            if (workbenchSite instanceof IEditorSite) {
                return ((IEditorSite)workbenchSite).getActionBars().getStatusLineManager();
            }
        }
        return null;
    }

    private Control createExpression(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 0;
        result.setLayoutData((Object)gd);
        Label label = new Label(result, 16384);
        label.setText(CSearchMessages.getString("CSearchPage.expression.label"));
        gd = new GridData(1);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fPattern = new Combo(result, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSearchPage.this.handlePatternSelected();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSearchPage.this.getContainer().setPerformActionEnabled(CSearchPage.this.getPattern().length() > 0 && CSearchPage.this.getSearchFor().size() != 0);
                CSearchPage.this.updateCaseSensitiveCheckbox();
            }
        });
        gd = new GridData(768);
        gd.horizontalIndent = -gd.horizontalIndent;
        this.fPattern.setLayoutData((Object)gd);
        this.fCaseSensitive = new Button(result, 32);
        this.fCaseSensitive.setText(CSearchMessages.getString("CSearchPage.expression.caseSensitive"));
        gd = new GridData();
        this.fCaseSensitive.setLayoutData((Object)gd);
        this.fCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSearchPage.this.fIsCaseSensitive = CSearchPage.this.fCaseSensitive.getSelection();
                CSearchPage.this.writeConfiguration();
            }
        });
        return result;
    }

    private void handleAllElements(SelectionEvent event) {
        Button allElements = this.fSearchFor[this.fSearchFor.length - 1];
        if (event.widget == allElements) {
            int i = 0;
            while (i < this.fSearchFor.length - 1) {
                this.fSearchFor[i].setEnabled(!allElements.getSelection());
                ++i;
            }
        }
    }

    private void handlePatternSelected() {
        if (this.fPattern.getSelectionIndex() < 0) {
            return;
        }
        int index = fgPreviousSearchPatterns.size() - 1 - this.fPattern.getSelectionIndex();
        this.fInitialData = (SearchPatternData)fgPreviousSearchPatterns.get(index);
        this.updateSelections();
        if (this.fInitialData.workingSets != null) {
            this.getContainer().setSelectedWorkingSets(this.fInitialData.workingSets);
        } else {
            this.getContainer().setSelectedScope(this.fInitialData.scope);
        }
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    private Control createLimitTo(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(CSearchMessages.getString("CSearchPage.limitTo.label"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        this.fLimitTo = new Button[this.fLimitToText.length];
        int i = 0;
        while (i < this.fLimitToText.length) {
            Button button = new Button((Composite)result, 16);
            button.setText(this.fLimitToText[i]);
            this.fLimitTo[i] = button;
            ++i;
        }
        Button filler = new Button((Composite)result, 16);
        filler.setVisible(false);
        filler = new Button((Composite)result, 16);
        filler.setVisible(false);
        return result;
    }

    private ICSearchConstants.LimitTo getLimitTo() {
        int i = 0;
        while (i < this.fLimitTo.length) {
            if (this.fLimitTo[i].getSelection()) {
                return this.fLimitToValues[i];
            }
            ++i;
        }
        return null;
    }

    private void setLimitTo(List searchFor) {
        HashSet<ICSearchConstants.LimitTo> set = new HashSet<ICSearchConstants.LimitTo>();
        set.add(ICSearchConstants.DECLARATIONS_DEFINITIONS);
        set.add(ICSearchConstants.REFERENCES);
        set.add(ICSearchConstants.ALL_OCCURRENCES);
        Iterator iter = searchFor.iterator();
        while (iter.hasNext()) {
            ICSearchConstants.SearchFor element = (ICSearchConstants.SearchFor)iter.next();
            if (element != ICSearchConstants.FUNCTION && element != ICSearchConstants.METHOD && element != ICSearchConstants.VAR && element != ICSearchConstants.FIELD && element != ICSearchConstants.NAMESPACE && element != ICSearchConstants.CLASS_STRUCT && element != ICSearchConstants.UNION && element != ICSearchConstants.UNKNOWN_SEARCH_FOR) continue;
            set.add(ICSearchConstants.DEFINITIONS);
            break;
        }
        int i = 0;
        while (i < this.fLimitTo.length) {
            this.fLimitTo[i].setEnabled(set.contains(this.fLimitToValues[i]));
            ++i;
        }
        if (!this.fLimitTo[1].isEnabled() && this.fLimitTo[1].getSelection()) {
            this.fLimitTo[1].setSelection(false);
            this.fLimitTo[3].setSelection(true);
        }
    }

    private Control createSearchFor(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(CSearchMessages.getString("CSearchPage.searchFor.label"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        result.setLayout((Layout)layout);
        this.fSearchFor = new Button[this.fSearchForText.length];
        int i = 0;
        while (i < this.fSearchForText.length) {
            Button button = new Button((Composite)result, 32);
            button.setText(this.fSearchForText[i]);
            this.fSearchFor[i] = button;
            ++i;
        }
        return result;
    }

    protected List getSearchFor() {
        LinkedList<ICSearchConstants.SearchFor> search = new LinkedList<ICSearchConstants.SearchFor>();
        int i = 0;
        while (i < this.fSearchFor.length) {
            if (this.fSearchFor[i].getSelection()) {
                search.add(this.fSearchForValues[i]);
            }
            ++i;
        }
        return search;
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(PAGE_NAME);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fIsCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
    }

    public void setVisible(boolean visible) {
        if (visible && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                this.initSelections();
            }
            this.fPattern.setFocus();
            this.getContainer().setPerformActionEnabled(this.fPattern.getText().length() > 0 && this.getSearchFor().size() != 0);
        }
        super.setVisible(visible);
    }

    private void updateCaseSensitiveCheckbox() {
        if (this.fInitialData != null && this.getPattern().equals(this.fInitialData.pattern) && this.fCElement != null) {
            this.fCaseSensitive.setEnabled(false);
            this.fCaseSensitive.setSelection(true);
        } else {
            this.fCaseSensitive.setEnabled(true);
            this.fCaseSensitive.setSelection(this.fIsCaseSensitive);
        }
    }

    private void initSelections() {
        this.fStructuredSelection = this.asStructuredSelection();
        this.fInitialData = this.tryStructuredSelection(this.fStructuredSelection);
        this.updateSelections();
    }

    private void updateSelections() {
        if (this.fInitialData == null) {
            this.fInitialData = this.trySimpleTextSelection(this.getContainer().getSelection());
        }
        if (this.fInitialData == null) {
            this.fInitialData = this.getDefaultInitValues();
        }
        this.fCElement = this.fInitialData.cElement;
        this.fIsCaseSensitive = this.fInitialData.isCaseSensitive;
        this.fCaseSensitive.setSelection(this.fInitialData.isCaseSensitive);
        this.fCaseSensitive.setEnabled(this.fInitialData.cElement == null);
        HashSet set = new HashSet(this.fInitialData.searchFor);
        boolean enabled = !set.contains(this.fSearchForValues[this.fSearchFor.length - 1]);
        int i = 0;
        while (i < this.fSearchFor.length) {
            this.fSearchFor[i].setSelection(set.contains(this.fSearchForValues[i]));
            this.fSearchFor[i].setEnabled(enabled);
            ++i;
        }
        if (!enabled) {
            this.fSearchFor[this.fSearchFor.length - 1].setEnabled(true);
        }
        this.setLimitTo(this.fInitialData.searchFor);
        i = 0;
        while (i < this.fLimitTo.length) {
            this.fLimitTo[i].setSelection(this.fLimitToValues[i] == this.fInitialData.limitTo);
            ++i;
        }
        this.fPattern.setText(this.fInitialData.pattern);
    }

    private SearchPatternData tryStructuredSelection(IStructuredSelection selection) {
        if (selection == null || selection.size() > 1) {
            return null;
        }
        Object o = selection.getFirstElement();
        if (o instanceof ICElement) {
            return this.determineInitValuesFrom((ICElement)o);
        }
        if (o instanceof IAdaptable) {
            IWorkbenchAdapter adapter;
            ICElement element;
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((element = (ICElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                return this.determineInitValuesFrom(element);
            }
            IAdaptable iAdaptable2 = (IAdaptable)o;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IWorkbenchAdapter)iAdaptable2.getAdapter((Class)clazz2)) != null) {
                LinkedList<ICSearchConstants.SearchFor> searchFor = new LinkedList<ICSearchConstants.SearchFor>();
                searchFor.add(ICSearchConstants.UNKNOWN_SEARCH_FOR);
                return new SearchPatternData(searchFor, ICSearchConstants.DECLARATIONS_DEFINITIONS, this.fIsCaseSensitive, adapter.getLabel(o), null);
            }
        }
        return null;
    }

    private SearchPatternData trySimpleTextSelection(ISelection selection) {
        SearchPatternData result = null;
        if (selection instanceof ITextSelection) {
            String text;
            BufferedReader reader = new BufferedReader(new StringReader(((ITextSelection)selection).getText()));
            try {
                text = reader.readLine();
                if (text == null) {
                    text = "";
                } else {
                    int indexSemi = text.indexOf(59);
                    if (indexSemi != -1) {
                        text = text.substring(0, indexSemi);
                    }
                }
            }
            catch (IOException iOException) {
                text = "";
            }
            LinkedList<ICSearchConstants.SearchFor> searchFor = new LinkedList<ICSearchConstants.SearchFor>();
            searchFor.add(ICSearchConstants.UNKNOWN_SEARCH_FOR);
            result = new SearchPatternData(searchFor, ICSearchConstants.DECLARATIONS_DEFINITIONS, this.fIsCaseSensitive, text, null);
        }
        return result;
    }

    private SearchPatternData getDefaultInitValues() {
        LinkedList<ICSearchConstants.SearchFor> searchFor = new LinkedList<ICSearchConstants.SearchFor>();
        searchFor.add(ICSearchConstants.CLASS_STRUCT);
        return new SearchPatternData(searchFor, ICSearchConstants.DECLARATIONS_DEFINITIONS, this.fIsCaseSensitive, "", null);
    }

    private String[] getPreviousSearchPatterns() {
        int patternCount = fgPreviousSearchPatterns.size();
        String[] patterns = new String[patternCount];
        int i = 0;
        while (i < patternCount) {
            patterns[i] = ((SearchPatternData)CSearchPage.fgPreviousSearchPatterns.get((int)(patternCount - 1 - i))).pattern;
            ++i;
        }
        return patterns;
    }

    private IStructuredSelection asStructuredSelection() {
        ISelection selection;
        ISelectionProvider provider;
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow wbWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wbWindow != null && (page = wbWindow.getActivePage()) != null && (part = page.getActivePart()) != null && (provider = part.getSite().getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    private SearchPatternData determineInitValuesFrom(ICElement element) {
        if (element == null) {
            return null;
        }
        LinkedList<ICSearchConstants.SearchFor> searchFor = new LinkedList<ICSearchConstants.SearchFor>();
        searchFor.add(CSearchUtil.getSearchForFromElement(element));
        String pattern = element.getElementName();
        ICSearchConstants.LimitTo limitTo = ICSearchConstants.ALL_OCCURRENCES;
        return new SearchPatternData(searchFor, limitTo, true, pattern, element);
    }

    private SearchPatternData getPatternData() {
        String pattern = this.getPattern();
        SearchPatternData match = null;
        int i = 0;
        int size = fgPreviousSearchPatterns.size();
        while (match == null && i < size) {
            match = (SearchPatternData)fgPreviousSearchPatterns.get(i);
            ++i;
            if (pattern.equals(match.pattern)) continue;
            match = null;
        }
        if (match == null) {
            match = new SearchPatternData(this.getSearchFor(), this.getLimitTo(), pattern, this.fCaseSensitive.getSelection(), this.fCElement, this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
            fgPreviousSearchPatterns.add(match);
        } else {
            match.searchFor = this.getSearchFor();
            match.limitTo = this.getLimitTo();
            match.isCaseSensitive = this.fCaseSensitive.getSelection();
            match.cElement = this.fCElement;
            match.scope = this.getContainer().getSelectedScope();
            match.workingSets = this.getContainer().getSelectedWorkingSets();
        }
        return match;
    }

    private static class SearchPatternData {
        List searchFor;
        ICSearchConstants.LimitTo limitTo;
        String pattern;
        boolean isCaseSensitive;
        ICElement cElement;
        int scope;
        IWorkingSet[] workingSets;

        public SearchPatternData(List s, ICSearchConstants.LimitTo l, boolean i, String p, ICElement element) {
            this(s, l, p, i, element, 0, null);
        }

        public SearchPatternData(List s, ICSearchConstants.LimitTo l, String p, boolean i, ICElement element, int scope, IWorkingSet[] workingSets) {
            this.searchFor = s;
            this.limitTo = l;
            this.pattern = p;
            this.isCaseSensitive = i;
            this.cElement = element;
            this.scope = scope;
            this.workingSets = workingSets;
        }
    }
}

