/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;

public abstract class CPPSpecialization
implements ICPPSpecialization,
ICPPInternalBinding {
    private IBinding specialized;
    private ICPPScope scope;
    protected ObjectMap argumentMap;
    private IASTNode definition = null;
    private IASTNode[] declarations = null;
    static /* synthetic */ Class class$0;

    public CPPSpecialization(IBinding specialized, ICPPScope scope, ObjectMap argumentMap) {
        this.specialized = specialized;
        this.scope = scope;
        this.argumentMap = argumentMap;
        if (specialized instanceof ICPPInternalBinding) {
            this.definition = ((ICPPInternalBinding)specialized).getDefinition();
            IASTNode[] decls = ((ICPPInternalBinding)specialized).getDeclarations();
            if (decls != null && decls.length > 0) {
                this.declarations = new IASTNode[]{decls[0]};
            }
        }
    }

    public IBinding getSpecializedBinding() {
        return this.specialized;
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return this.definition;
    }

    public void addDefinition(IASTNode node) {
        this.definition = node;
    }

    public void addDeclaration(IASTNode node) {
        if (this.declarations == null) {
            this.declarations = new IASTNode[]{node};
        } else if (this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)this.declarations[0]).getOffset()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declarations = (IASTNode[])ArrayUtil.prepend(clazz, this.declarations, node);
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declarations = (IASTNode[])ArrayUtil.append(clazz, this.declarations, node);
        }
    }

    public void removeDeclaration(IASTNode node) {
        if (node == this.definition) {
            this.definition = null;
            return;
        }
        if (this.declarations != null) {
            int i = 0;
            while (i < this.declarations.length) {
                if (node == this.declarations[i]) {
                    if (i == this.declarations.length - 1) {
                        this.declarations[i] = null;
                    } else {
                        System.arraycopy(this.declarations, i + 1, this.declarations, i, this.declarations.length - 1 - i);
                    }
                }
                ++i;
            }
        }
    }

    public String getName() {
        return this.specialized.getName();
    }

    public char[] getNameCharArray() {
        return this.specialized.getNameCharArray();
    }

    public IScope getScope() {
        return this.scope;
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        return ((ICPPInternalBinding)this.specialized).isGloballyQualified();
    }
}

