/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.macros.MbsMacroSupplier;
import org.eclipse.cdt.managedbuilder.macros.IFileContextBuildMacroValues;

public class FileContextBuildMacroValues
implements IFileContextBuildMacroValues {
    private IBuilder fBuilder;
    private IFileContextBuildMacroValues fSupperClassValues;
    private HashMap fValues = new HashMap();
    private HashMap fAllValues = new HashMap();
    private boolean fInitialized;

    public FileContextBuildMacroValues(IBuilder builder, IManagedConfigElement element) {
        this.fBuilder = builder;
        this.load(element);
    }

    private void load(IManagedConfigElement element) {
        String[] names = MbsMacroSupplier.getInstance().getMacroNames(1);
        this.fValues.clear();
        int i = 0;
        while (i < names.length) {
            String value = element.getAttribute("macro" + names[i] + "Value");
            if (value != null) {
                this.fValues.put(names[i], value);
            }
            ++i;
        }
    }

    private void load() {
        if (!this.fInitialized) {
            this.fAllValues.clear();
            IFileContextBuildMacroValues supperValues = this.getSupperClassValues();
            if (supperValues != null) {
                String[] names = MbsMacroSupplier.getInstance().getMacroNames(1);
                int i = 0;
                while (i < names.length) {
                    String value = (String)this.fValues.get(names[i]);
                    if (value == null) {
                        value = supperValues.getMacroValue(names[i]);
                    }
                    if (value != null && value.length() > 0) {
                        this.fAllValues.put(names[i], value);
                    }
                    ++i;
                }
            } else {
                Iterator iter = this.fValues.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String value = (String)entry.getValue();
                    if (value == null || value.length() <= 0) continue;
                    this.fAllValues.put(entry.getKey(), value);
                }
            }
            this.fInitialized = true;
        }
    }

    public String[] getSupportedMacros() {
        this.load();
        Set set = this.fAllValues.keySet();
        String[] names = new String[set.size()];
        Iterator iter = set.iterator();
        int i = 0;
        while (i < names.length) {
            names[i] = (String)iter.next();
            ++i;
        }
        return names;
    }

    public String getMacroValue(String macroName) {
        this.load();
        return (String)this.fAllValues.get(macroName);
    }

    public IFileContextBuildMacroValues getSupperClassValues() {
        IBuilder supperClass;
        if (this.fBuilder != null && (supperClass = this.fBuilder.getSuperClass()) != null) {
            this.fSupperClassValues = supperClass.getFileContextBuildMacroValues();
        }
        return this.fSupperClassValues;
    }

    public void setBuilder(IBuilder builder) {
        this.fBuilder = builder;
        this.fInitialized = false;
    }

    public Object clone() {
        FileContextBuildMacroValues cloned = null;
        try {
            cloned = (FileContextBuildMacroValues)super.clone();
            cloned.fValues = (HashMap)this.fValues.clone();
            cloned.fAllValues = (HashMap)this.fAllValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return cloned;
    }
}

