/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionComboFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.managedbuilder.ui.properties.FileListControlFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class BuildOptionSettingsPage
extends BuildSettingsPage {
    private Map fieldsMap = new HashMap();
    private IOptionCategory category;
    private boolean isItResourceConfigPage;
    private Map fieldEditorsToParentMap = new HashMap();

    public BuildOptionSettingsPage(IConfiguration configuration, IOptionCategory category) {
        super(configuration);
        this.category = category;
        this.isItResourceConfigPage = false;
    }

    public BuildOptionSettingsPage(IResourceConfiguration resConfig, IOptionCategory category) {
        super(resConfig);
        this.category = category;
        this.isItResourceConfigPage = true;
    }

    public Point computeSize() {
        return super.computeSize();
    }

    private IBuildObject getConfigurationHandle() {
        if (this.isItResourceConfigPage) {
            return this.resConfig;
        }
        return this.configuration;
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        Object[][] options = this.isItResourceConfigPage ? this.category.getOptions(this.resConfig) : this.category.getOptions(this.configuration);
        int index = 0;
        while (index < options.length) {
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            IOptionApplicability applicabilityCalculator = opt.getApplicabilityCalculator();
            Object config = this.isItResourceConfigPage ? this.resConfig : this.configuration;
            if (applicabilityCalculator == null || applicabilityCalculator.isOptionVisible((IBuildObject)config, holder, opt)) {
                try {
                    block2 : switch (opt.getValueType()) {
                        case 2: {
                            switch (opt.getBrowseType()) {
                                case 2: {
                                    Composite fieldEditorParent2 = this.getFieldEditorParent();
                                    DirectoryFieldEditor dirFieldEditor = new DirectoryFieldEditor(opt.getId(), opt.getName(), fieldEditorParent2);
                                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, (FieldEditor)dirFieldEditor, fieldEditorParent2);
                                    this.addField((FieldEditor)dirFieldEditor);
                                    this.fieldsMap.put(opt.getId(), dirFieldEditor);
                                    this.fieldEditorsToParentMap.put(dirFieldEditor, fieldEditorParent2);
                                    break block2;
                                }
                                case 1: {
                                    Composite fieldEditorParent3 = this.getFieldEditorParent();
                                    FileFieldEditor fileFieldEditor = new FileFieldEditor(opt.getId(), opt.getName(), fieldEditorParent3);
                                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, (FieldEditor)fileFieldEditor, fieldEditorParent3);
                                    this.addField((FieldEditor)fileFieldEditor);
                                    this.fieldsMap.put(opt.getId(), fileFieldEditor);
                                    this.fieldEditorsToParentMap.put(fileFieldEditor, fieldEditorParent3);
                                    break block2;
                                }
                                case 0: {
                                    Composite fieldEditorParent4 = this.getFieldEditorParent();
                                    StringFieldEditor stringField = new StringFieldEditor(opt.getId(), opt.getName(), fieldEditorParent4);
                                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, (FieldEditor)stringField, fieldEditorParent4);
                                    this.addField((FieldEditor)stringField);
                                    this.fieldsMap.put(opt.getId(), stringField);
                                    this.fieldEditorsToParentMap.put(stringField, fieldEditorParent4);
                                    break block2;
                                }
                            }
                            throw new AssertionError();
                        }
                        case 0: {
                            Composite fieldEditorParent5 = this.getFieldEditorParent();
                            BooleanFieldEditor booleanField = new BooleanFieldEditor(opt.getId(), opt.getName(), fieldEditorParent5);
                            this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, (FieldEditor)booleanField, fieldEditorParent5);
                            this.addField((FieldEditor)booleanField);
                            this.fieldsMap.put(opt.getId(), booleanField);
                            this.fieldEditorsToParentMap.put(booleanField, fieldEditorParent5);
                            break;
                        }
                        case 1: {
                            String sel;
                            try {
                                String selId = opt.getSelectedEnum();
                                sel = opt.getEnumName(selId);
                            }
                            catch (BuildException buildException) {
                                break;
                            }
                            String[] enumNames = opt.getApplicableValues();
                            Vector<String> enumValidList = new Vector<String>();
                            int i = 0;
                            while (i < enumNames.length) {
                                if (opt.getValueHandler().isEnumValueAppropriate(this.getConfigurationHandle(), opt.getOptionHolder(), opt, opt.getValueHandlerExtraArgument(), enumNames[i])) {
                                    enumValidList.add(enumNames[i]);
                                }
                                ++i;
                            }
                            Object[] enumValidNames = new String[enumValidList.size()];
                            enumValidList.copyInto(enumValidNames);
                            Composite fieldEditorParent6 = this.getFieldEditorParent();
                            BuildOptionComboFieldEditor comboField = new BuildOptionComboFieldEditor(opt.getId(), opt.getName(), (String[])enumValidNames, sel, fieldEditorParent6);
                            this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, comboField, fieldEditorParent6);
                            this.addField(comboField);
                            this.fieldsMap.put(opt.getId(), comboField);
                            this.fieldEditorsToParentMap.put(comboField, fieldEditorParent6);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            Composite fieldEditorParent7 = this.getFieldEditorParent();
                            FileListControlFieldEditor listField = new FileListControlFieldEditor(opt.getId(), opt.getName(), fieldEditorParent7, opt.getBrowseType());
                            this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, listField, fieldEditorParent7);
                            this.addField(listField);
                            this.fieldsMap.put(opt.getId(), listField);
                            this.fieldEditorsToParentMap.put(listField, fieldEditorParent7);
                            break;
                        }
                    }
                }
                catch (BuildException buildException) {}
            }
            ++index;
        }
    }

    public boolean isForCategory(IOptionCategory category) {
        if (category != null) {
            return category.equals(this.category);
        }
        return false;
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        Object[][] options = this.isItResourceConfigPage ? this.category.getOptions(this.resConfig) : this.category.getOptions(this.configuration);
        int i = 0;
        while (i < options.length) {
            IHoldsOptions holder = (IHoldsOptions)options[i][0];
            if (holder == null) break;
            IOption option = (IOption)options[i][1];
            try {
                IOption setOption = null;
                switch (option.getValueType()) {
                    case 0: {
                        boolean boolVal = this.getToolSettingsPreferenceStore().getBoolean(option.getId());
                        setOption = this.isItResourceConfigPage ? ManagedBuildManager.setOption((IResourceConfiguration)this.resConfig, (IHoldsOptions)holder, (IOption)option, (boolean)boolVal) : ManagedBuildManager.setOption((IConfiguration)this.configuration, (IHoldsOptions)holder, (IOption)option, (boolean)boolVal);
                        if (setOption == option) break;
                        this.getToolSettingsPreferenceStore().setValue(setOption.getId(), boolVal);
                        FieldEditor fe = (FieldEditor)this.fieldsMap.get(option.getId());
                        fe.setPreferenceName(setOption.getId());
                        break;
                    }
                    case 1: {
                        String enumVal = this.getToolSettingsPreferenceStore().getString(option.getId());
                        String enumId = option.getEnumeratedId(enumVal);
                        setOption = this.isItResourceConfigPage ? ManagedBuildManager.setOption((IResourceConfiguration)this.resConfig, (IHoldsOptions)holder, (IOption)option, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal)) : ManagedBuildManager.setOption((IConfiguration)this.configuration, (IHoldsOptions)holder, (IOption)option, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal));
                        if (setOption == option) break;
                        this.getToolSettingsPreferenceStore().setValue(setOption.getId(), enumVal);
                        FieldEditor fe = (FieldEditor)this.fieldsMap.get(option.getId());
                        fe.setPreferenceName(setOption.getId());
                        break;
                    }
                    case 2: {
                        String strVal = this.getToolSettingsPreferenceStore().getString(option.getId());
                        setOption = this.isItResourceConfigPage ? ManagedBuildManager.setOption((IResourceConfiguration)this.resConfig, (IHoldsOptions)holder, (IOption)option, (String)strVal) : ManagedBuildManager.setOption((IConfiguration)this.configuration, (IHoldsOptions)holder, (IOption)option, (String)strVal);
                        if (setOption == option) break;
                        this.getToolSettingsPreferenceStore().setValue(setOption.getId(), strVal);
                        FieldEditor fe = (FieldEditor)this.fieldsMap.get(option.getId());
                        fe.setPreferenceName(setOption.getId());
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        String listStr = this.getToolSettingsPreferenceStore().getString(option.getId());
                        String[] listVal = BuildToolsSettingsStore.parseString(listStr);
                        setOption = this.isItResourceConfigPage ? ManagedBuildManager.setOption((IResourceConfiguration)this.resConfig, (IHoldsOptions)holder, (IOption)option, (String[])listVal) : ManagedBuildManager.setOption((IConfiguration)this.configuration, (IHoldsOptions)holder, (IOption)option, (String[])listVal);
                        if (setOption == option) break;
                        this.getToolSettingsPreferenceStore().setValue(setOption.getId(), listStr);
                        FieldEditor fe = (FieldEditor)this.fieldsMap.get(option.getId());
                        fe.setPreferenceName(setOption.getId());
                        break;
                    }
                }
                if (setOption == null) {
                    setOption = option;
                }
                setOption.getValueHandler().handleValue(this.getConfigurationHandle(), setOption.getOptionHolder(), setOption, setOption.getValueHandlerExtraArgument(), 4);
            }
            catch (BuildException buildException) {}
            ++i;
        }
        return ok;
    }

    public void updateFields() {
        Collection fieldsList = this.fieldsMap.values();
        Iterator iter = fieldsList.iterator();
        while (iter.hasNext()) {
            FieldEditor editor = (FieldEditor)iter.next();
            editor.load();
        }
    }

    public void storeSettings() {
        super.performOk();
    }

    private void setFieldEditorEnablement(IHoldsOptions holder, IOption option, IOptionApplicability optionApplicability, FieldEditor fieldEditor, Composite parent) {
        if (optionApplicability == null) {
            return;
        }
        Object config = this.isItResourceConfigPage ? this.resConfig : this.configuration;
        if (!optionApplicability.isOptionEnabled((IBuildObject)config, holder, option)) {
            fieldEditor.setEnabled(false, parent);
        } else {
            fieldEditor.setEnabled(true, parent);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object[][] options = this.isItResourceConfigPage ? this.category.getOptions(this.resConfig) : this.category.getOptions(this.configuration);
        int index = 0;
        while (index < options.length) {
            IOptionApplicability applicabilityCalculator;
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            if (this.fieldsMap.containsKey(opt.getId()) && (applicabilityCalculator = opt.getApplicabilityCalculator()) != null) {
                FieldEditor fieldEditor = (FieldEditor)this.fieldsMap.get(opt.getId());
                Composite parent = (Composite)this.fieldEditorsToParentMap.get(fieldEditor);
                this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, fieldEditor, parent);
            }
            ++index;
        }
    }
}

