/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.index;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.ICDTIndexer;
import org.eclipse.cdt.internal.core.index.nullindexer.NullIndexer;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IProject;

public class Indexer {
    private static Indexer indexer = null;
    private static IndexManager manager = CCorePlugin.getDefault().getCoreModel().getIndexManager();

    public static boolean indexEnabledOnAllProjects() {
        IProject[] projects = CCorePlugin.getWorkspace().getRoot().getProjects();
        boolean allEnabled = true;
        int i = 0;
        while (i < projects.length) {
            if (!Indexer.indexEnabledOnProject(projects[i])) {
                allEnabled = false;
                break;
            }
            ++i;
        }
        return allEnabled;
    }

    public static boolean indexEnabledOnAnyProjects() {
        IProject[] projects = CCorePlugin.getWorkspace().getRoot().getProjects();
        boolean allEnabled = false;
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen() && Indexer.indexEnabledOnProject(projects[i])) {
                allEnabled = true;
                break;
            }
            ++i;
        }
        return allEnabled;
    }

    public static boolean indexEnabledOnProject(IProject project) {
        ICDTIndexer _indexer = manager.getIndexerForProject(project);
        return !(_indexer instanceof NullIndexer);
    }
}

