/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.io.IOException;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.TypeInfo;
import org.eclipse.cdt.core.browser.TypeReference;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.IndexerJob;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.cindexstorage.Index;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexInput;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class IndexerTypesJob
extends IndexerJob {
    private ITypeCache fTypeCache;

    public IndexerTypesJob(IndexManager indexManager, ITypeCache typeCache, ITypeSearchScope scope) {
        super(indexManager, typeCache.getProject());
        this.fTypeCache = typeCache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processIndex(IIndex index, IProject project, IProgressMonitor progressMonitor) throws InterruptedException {
        BlocksIndexInput input = new BlocksIndexInput(index.getIndexFile());
        try {
            try {
                ((IndexInput)input).open();
                this.updateNamespaces(input, project, progressMonitor);
                this.updateTypes(input, project, progressMonitor);
                Object var5_5 = null;
            }
            catch (IOException iOException) {
                Object var5_6 = null;
                try {
                    ((IndexInput)input).close();
                    return false;
                }
                catch (IOException iOException2) {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {}
            catch (IOException iOException) {
                return false;
            }
            ((IndexInput)input).close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return false;
        }
        ((IndexInput)input).close();
        return true;
    }

    private void updateNamespaces(IndexInput input, IProject project, IProgressMonitor monitor) throws InterruptedException, IOException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        IEntryResult[] namespaceEntries = input.queryEntriesPrefixedBy(Index.encodeEntry(6, 0, 1));
        if (namespaceEntries != null) {
            int i = 0;
            while (i < namespaceEntries.length) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IEntryResult entry = namespaceEntries[i];
                String name = entry.getName();
                if (name.length() != 0) {
                    String[] enclosingNames = entry.getEnclosingNames();
                    this.addType(input, project, entry, 61, name, enclosingNames, monitor);
                }
                ++i;
            }
        }
    }

    private void updateTypes(IndexInput input, IProject project, IProgressMonitor monitor) throws InterruptedException, IOException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        IEntryResult[] typeEntries = input.queryEntriesPrefixedBy(Index.encodeEntry(1, 0, 1));
        if (typeEntries != null) {
            int i = 0;
            while (i < typeEntries.length) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IEntryResult entry = typeEntries[i];
                String name = entry.getName();
                switch (entry.getKind()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (name.length() == 0) break;
                        this.addType(input, project, entry, entry.getKind(), name, entry.getEnclosingNames(), monitor);
                        break;
                    }
                    case 6: {
                        if (name.length() == 0) break;
                        this.addSuperTypeReference(input, project, entry, name, entry.getEnclosingNames(), monitor);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private void addType(IndexInput input, IProject project, IEntryResult entry, int type, String name, String[] enclosingNames, IProgressMonitor monitor) throws InterruptedException, IOException {
        int[] references;
        QualifiedTypeName qualifiedName = new QualifiedTypeName(name, enclosingNames);
        ITypeInfo info = this.fTypeCache.getType(type, qualifiedName);
        if ((info == null || info.isUndefinedType()) && (references = entry.getFileReferences()) != null && references.length > 0) {
            if (info != null) {
                info.setCElementType(type);
            } else {
                info = new TypeInfo(type, qualifiedName);
                this.fTypeCache.insert(info);
            }
            IndexedFileEntry file = input.getIndexedFile(references[0]);
            if (file != null && file.getPath() != null) {
                IPath path = PathUtil.getWorkspaceRelativePath(file.getPath());
                info.addReference(new TypeReference(path, project));
            }
        }
    }

    private void addSuperTypeReference(IndexInput input, IProject project, IEntryResult entry, String name, String[] enclosingNames, IProgressMonitor monitor) throws InterruptedException, IOException {
        int[] references;
        QualifiedTypeName qualifiedName = new QualifiedTypeName(name, enclosingNames);
        ITypeInfo info = this.fTypeCache.getType(65, qualifiedName);
        if (info == null) {
            info = this.fTypeCache.getType(67, qualifiedName);
        }
        if (info == null) {
            info = new TypeInfo(0, qualifiedName);
            this.fTypeCache.insert(info);
        }
        if ((references = entry.getFileReferences()) != null && references.length > 0) {
            int i = 0;
            while (i < references.length) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IndexedFileEntry file = input.getIndexedFile(references[i]);
                if (file != null && file.getPath() != null) {
                    IPath path = PathUtil.getWorkspaceRelativePath(file.getPath());
                    info.addDerivedReference(new TypeReference(path, project));
                }
                ++i;
            }
        }
    }
}

