/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AdditionalInput
implements IAdditionalInput {
    private static final String EMPTY_STRING = new String();
    private IInputType parent;
    private String paths;
    private Integer kind;
    private boolean isExtensionAdditionalInput = false;
    private boolean isDirty = false;
    private boolean resolved = true;

    public AdditionalInput(IInputType parent, IManagedConfigElement element) {
        this.parent = parent;
        this.isExtensionAdditionalInput = true;
        this.resolved = false;
        this.loadFromManifest(element);
    }

    public AdditionalInput(InputType parent, boolean isExtensionElement) {
        this.parent = parent;
        this.isExtensionAdditionalInput = isExtensionElement;
        if (!isExtensionElement) {
            this.setDirty(true);
        }
    }

    public AdditionalInput(IInputType parent, Element element) {
        this.parent = parent;
        this.isExtensionAdditionalInput = false;
        this.loadFromProject(element);
    }

    public AdditionalInput(IInputType parent, AdditionalInput additionalInput) {
        this.parent = parent;
        this.isExtensionAdditionalInput = false;
        if (additionalInput.paths != null) {
            this.paths = new String(additionalInput.paths);
        }
        if (additionalInput.kind != null) {
            this.kind = new Integer(additionalInput.kind);
        }
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        this.paths = element.getAttribute("paths");
        String kindStr = element.getAttribute("kind");
        if (kindStr == null || kindStr.equals("additionalinputdependency")) {
            this.kind = new Integer(3);
        } else if (kindStr.equals("additionalinput")) {
            this.kind = new Integer(2);
        } else if (kindStr.equals("additionaldependency")) {
            this.kind = new Integer(1);
        }
    }

    protected void loadFromProject(Element element) {
        if (element.hasAttribute("paths")) {
            this.paths = element.getAttribute("paths");
        }
        if (element.hasAttribute("kind")) {
            String kindStr = element.getAttribute("kind");
            if (kindStr == null || kindStr.equals("additionalinputdependency")) {
                this.kind = new Integer(3);
            } else if (kindStr.equals("additionalinput")) {
                this.kind = new Integer(2);
            } else if (kindStr.equals("additionaldependency")) {
                this.kind = new Integer(1);
            }
        }
    }

    public void serialize(Document doc, Element element) {
        if (this.paths != null) {
            element.setAttribute("paths", this.paths);
        }
        if (this.kind != null) {
            String str;
            switch (this.getKind()) {
                case 2: {
                    str = "additionalinput";
                    break;
                }
                case 1: {
                    str = "additionaldependency";
                    break;
                }
                case 3: {
                    str = "additionalinputdependency";
                    break;
                }
                default: {
                    str = EMPTY_STRING;
                }
            }
            element.setAttribute("kind", str);
        }
        this.isDirty = false;
    }

    public IInputType getParent() {
        return this.parent;
    }

    public String[] getPaths() {
        if (this.paths == null) {
            return null;
        }
        String[] nameTokens = this.paths.split(";");
        return nameTokens;
    }

    public void setPaths(String newPaths) {
        if (this.paths == null && newPaths == null) {
            return;
        }
        if (this.paths == null || newPaths == null || !this.paths.equals(newPaths)) {
            this.paths = newPaths;
            this.isDirty = true;
        }
    }

    public int getKind() {
        if (this.kind == null) {
            return 3;
        }
        return this.kind;
    }

    public void setKind(int newKind) {
        if (this.kind == null || this.kind != newKind) {
            this.kind = new Integer(newKind);
            this.isDirty = true;
        }
    }

    public boolean isExtensionElement() {
        return this.isExtensionAdditionalInput;
    }

    public boolean isDirty() {
        if (this.isExtensionAdditionalInput) {
            return false;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
        }
    }
}

