/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceManipulation;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.ILineLocatable;
import org.eclipse.cdt.core.search.IMatchLocatable;
import org.eclipse.cdt.core.search.IOffsetLocatable;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.corext.refactoring.Checks;
import org.eclipse.cdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.cdt.internal.corext.refactoring.IReferenceUpdating;
import org.eclipse.cdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.cdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.cdt.internal.corext.refactoring.RenameProcessor;
import org.eclipse.cdt.internal.corext.refactoring.ResourceUtil;
import org.eclipse.cdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.cdt.internal.corext.refactoring.TextChangeManager;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameElementProcessor
extends RenameProcessor
implements IReferenceUpdating {
    private ICElement fCElement = null;
    private SearchResultGroup[] fReferences;
    private TextChangeManager fChangeManager;
    private final String QUALIFIER = "::";
    private final String TELTA = "~";
    private boolean fUpdateReferences;

    public ICElement getCElement() {
        return this.fCElement;
    }

    public void initialize(Object[] elements) throws CoreException {
        Assert.isTrue(elements != null && elements.length == 1);
        Object element = elements[0];
        if (element == null) {
            return;
        }
        if (!(element instanceof ISourceReference)) {
            return;
        }
        this.fCElement = (ICElement)element;
        this.setNewElementName(this.fCElement.getElementName());
        this.fUpdateReferences = true;
    }

    public boolean isAvailable() throws CoreException {
        if (this.fCElement == null) {
            return false;
        }
        if (!(this.fCElement instanceof ISourceReference)) {
            return false;
        }
        return Checks.isAvailable(this.fCElement);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.name", new String[]{this.fCElement.getElementName(), this.fNewElementName});
    }

    public Object[] getElements() {
        return new Object[]{this.fCElement};
    }

    public String getCurrentElementName() {
        if (this.fCElement == null) {
            return "";
        }
        String name = this.fCElement.getElementName();
        if (name.indexOf("::") != -1) {
            return name.substring(name.lastIndexOf("::") + 2, name.length());
        }
        return name;
    }

    private int getCurrentElementNameLength() {
        if (this.fCElement == null) {
            return 0;
        }
        String name = this.fCElement.getElementName();
        if (name.indexOf("::") != -1) {
            String unQualifiedName = name.substring(name.lastIndexOf("::") + 2, name.length());
            return unQualifiedName.length();
        }
        return name.length();
    }

    private int getCurrentElementNameStartPos() {
        if (this.fCElement == null) {
            return 0;
        }
        try {
            String name = this.fCElement.getElementName();
            ISourceReference sourceRef = (ISourceReference)this.fCElement;
            ISourceRange range = sourceRef.getSourceRange();
            if (name.indexOf("::") != -1) {
                return range.getIdStartPos() + name.lastIndexOf("::") + 2;
            }
            return range.getIdStartPos();
        }
        catch (CModelException cModelException) {
            return 0;
        }
    }

    private String getElementQualifiedName(ICElement element) throws CModelException {
        if (!this.eligibleForRefactoring(element)) {
            return "";
        }
        StringBuffer name = new StringBuffer();
        if (element instanceof IFunctionDeclaration) {
            IFunctionDeclaration function = (IFunctionDeclaration)element;
            if (element instanceof IMethodDeclaration && ((IMethodDeclaration)element).isFriend()) {
                ICElement parent = element.getParent();
                while (!(parent instanceof INamespace) && !(parent instanceof ITranslationUnit)) {
                    parent = parent.getParent();
                }
                name.append(this.getElementQualifiedName(parent));
            } else {
                name.append(this.getElementQualifiedName(element.getParent()));
            }
            name.append("::");
            name.append(function.getSignature());
        } else {
            if (element instanceof IEnumerator) {
                IEnumeration enum1 = (IEnumeration)element.getParent();
                name.append(this.getElementQualifiedName(enum1.getParent()));
            } else {
                name.append(this.getElementQualifiedName(element.getParent()));
            }
            name.append("::");
            name.append(element.getElementName());
        }
        return name.toString();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CModelException {
        IMethodDeclaration method;
        if (!this.eligibleForRefactoring(this.fCElement)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameTypeRefactoring.wrong_element"));
        }
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = null;
        result = this.fCElement instanceof IStructure ? Checks.checkClassName(newName) : (this.fCElement instanceof IMethodDeclaration || this.fCElement instanceof IFunctionDeclaration ? Checks.checkMethodName(newName) : (this.fCElement instanceof IField ? Checks.checkFieldName(newName) : Checks.checkIdentifier(newName)));
        if (!(this.fCElement instanceof IFunctionDeclaration) && this.checkSiblingsCollision(true).hasError()) {
            String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.member_type_exists", new String[]{this.fNewElementName, this.fCElement.getParent().getElementName()});
            result.addFatalError(msg);
        }
        if (this.fCElement instanceof IMethodDeclaration && (method = (IMethodDeclaration)this.fCElement).isVirtual()) {
            String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.virtual_method", new String[]{this.fNewElementName, this.fCElement.getParent().getElementName()});
            result.addWarning(msg);
        }
        if (Checks.isAlreadyNamed(this.fCElement, newName)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameTypeRefactoring.choose_another_name"));
        }
        return result;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean canEnableTextUpdating() {
        return false;
    }

    public RefactoringStatus checkActivation() throws CoreException {
        if (!this.eligibleForRefactoring(this.fCElement)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameTypeRefactoring.wrong_element"));
        }
        return Checks.checkIfTuBroken(this.fCElement);
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result;
        block10: {
            block9: {
                block8: {
                    block7: {
                        RefactoringStatus refactoringStatus;
                        Assert.isNotNull(this.fCElement, "type");
                        Assert.isNotNull(this.fNewElementName, "newName");
                        result = new RefactoringStatus();
                        try {
                            pm.beginTask("", 20);
                            pm.setTaskName(RefactoringCoreMessages.getString("RenameTypeRefactoring.checking"));
                            result.merge(this.checkNewElementName(this.fNewElementName));
                            if (!result.hasFatalError()) break block7;
                            refactoringStatus = result;
                            Object var3_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_13 = null;
                            pm.done();
                            throw throwable;
                        }
                        pm.done();
                        return refactoringStatus;
                    }
                    pm.worked(5);
                    result.merge(Checks.checkIfTuBroken(this.fCElement));
                    if (!result.hasFatalError()) break block8;
                    RefactoringStatus refactoringStatus = result;
                    Object var3_9 = null;
                    pm.done();
                    return refactoringStatus;
                }
                pm.worked(1);
                result.merge(this.checkEnclosingElements());
                pm.worked(1);
                result.merge(this.checkEnclosedElements());
                pm.worked(1);
                result.merge(this.checkSiblingsCollision(false));
                pm.worked(1);
                if (!result.hasFatalError()) break block9;
                RefactoringStatus refactoringStatus = result;
                Object var3_10 = null;
                pm.done();
                return refactoringStatus;
            }
            this.fReferences = null;
            pm.setTaskName(RefactoringCoreMessages.getString("RenameTypeRefactoring.searching"));
            this.fReferences = this.getReferences(this.getElementQualifiedName(this.fCElement), (IProgressMonitor)new SubProgressMonitor(pm, 35), this.fUpdateReferences);
            pm.worked(6);
            result.merge(this.analyzeAffectedTranslationUnits());
            pm.setTaskName(RefactoringCoreMessages.getString("RenameTypeRefactoring.checking"));
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!result.hasFatalError()) break block10;
            RefactoringStatus refactoringStatus = result;
            Object var3_11 = null;
            pm.done();
            return refactoringStatus;
        }
        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 35));
        pm.worked(5);
        RefactoringStatus refactoringStatus = result;
        Object var3_12 = null;
        pm.done();
        return refactoringStatus;
    }

    public IChange createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.getString("RenameTypeRefactoring.creating_change"), 4);
        CompositeChange builder = new CompositeChange(RefactoringCoreMessages.getString("Change.javaChanges"));
        builder.addAll(this.fChangeManager.getAllChanges());
        pm.worked(1);
        return builder;
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        result.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllTranslationUnits())));
        return result.toArray(new IFile[result.size()]);
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        TextChangeManager textChangeManager;
        try {
            pm.beginTask("", 7);
            TextChangeManager manager = new TextChangeManager();
            this.addReferenceUpdates(manager, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            pm.worked(1);
            pm.worked(1);
            textChangeManager = manager;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return textChangeManager;
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.fReferences.length);
        int i = 0;
        while (i < this.fReferences.length) {
            ITranslationUnit cu;
            IResource res = this.fReferences[i].getResultGroupResource();
            if (res != null && (cu = (ITranslationUnit)CoreModel.getDefault().create(res)) != null) {
                ITranslationUnit tu = CModelUtil.toWorkingCopy(cu);
                if (tu == null) {
                    return;
                }
                ITranslationUnit wc = tu;
                String name = RefactoringCoreMessages.getString("RenameTypeRefactoring.update_reference");
                BasicSearchMatch[] results = this.fReferences[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    BasicSearchMatch searchResult = results[j];
                    int oldNameLength = this.getCurrentElementNameLength();
                    IMatchLocatable locatable = searchResult.getLocatable();
                    int endOffset = 0;
                    if (locatable instanceof IOffsetLocatable) {
                        endOffset = ((IOffsetLocatable)locatable).getNameEndOffset();
                    } else if (locatable instanceof ILineLocatable) {
                        endOffset = ((ILineLocatable)locatable).getEndLine();
                    }
                    int offset = endOffset - oldNameLength;
                    manager.get(wc).addTextEdit(name, (TextEdit)new ReplaceEdit(offset, oldNameLength, this.fNewElementName));
                    ++j;
                }
                pm.worked(1);
            }
            ++i;
        }
    }

    private void addTypeDeclarationUpdate(TextChangeManager manager) throws CoreException {
        String name = RefactoringCoreMessages.getString("RenameTypeRefactoring.update");
        if (this.fCElement instanceof ISourceReference) {
            ITranslationUnit cu = ((ISourceReference)this.fCElement).getTranslationUnit();
            manager.get(cu).addTextEdit(name, (TextEdit)new ReplaceEdit(this.getCurrentElementNameStartPos(), this.getCurrentElementNameLength(), this.fNewElementName));
        }
    }

    private SearchResultGroup[] getReferences(String searchPrefix, IProgressMonitor pm, boolean updateReferences) throws CoreException {
        return RefactoringSearchEngine.search(pm, this.createRefactoringScope(), (ICSearchPattern)this.createSearchPattern(searchPrefix, updateReferences));
    }

    private ICSearchScope createRefactoringScope() throws CoreException {
        ICElement[] projectScopeElement = new ICElement[]{this.fCElement.getCProject()};
        ICSearchScope scope = SearchEngine.createCSearchScope((ICElement[])projectScopeElement, (boolean)true);
        return scope;
    }

    private OrPattern createSearchPattern(String searchPrefix, boolean updateReferences) throws CoreException {
        OrPattern orPattern = new OrPattern();
        if (this.fCElement instanceof IStructure) {
            if (updateReferences) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false));
            }
            IStructure structure = (IStructure)this.fCElement;
            orPattern.addPattern(SearchEngine.createSearchPattern((String)(String.valueOf(searchPrefix) + "::" + structure.getElementName()), (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            orPattern.addPattern(SearchEngine.createSearchPattern((String)(String.valueOf(searchPrefix) + "::" + "~" + structure.getElementName()), (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
        } else if (this.fCElement instanceof IMethod) {
            if (updateReferences) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof IMethodDeclaration) {
            if (updateReferences) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof IFunction) {
            if (updateReferences) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS_DEFINITIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof IFunctionDeclaration) {
            if (updateReferences) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof IEnumeration) {
            if (updateReferences) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS_DEFINITIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof IEnumerator) {
            if (updateReferences) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.ENUMTOR, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.ENUMTOR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS_DEFINITIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof IField) {
            if (updateReferences) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS_DEFINITIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof IVariable) {
            if (updateReferences) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS_DEFINITIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof INamespace) {
            if (updateReferences) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS_DEFINITIONS, (boolean)false));
            }
        } else if (updateReferences) {
            orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.UNKNOWN_SEARCH_FOR, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
        } else {
            orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.UNKNOWN_SEARCH_FOR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
        }
        return orPattern;
    }

    private RefactoringStatus checkEnclosedElements() throws CoreException {
        ICElement enclosedElement = RenameElementProcessor.findEnclosedElements(this.fCElement, this.fNewElementName);
        if (enclosedElement == null) {
            return null;
        }
        String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.encloses", new String[]{this.fCElement.getElementName(), this.fNewElementName});
        return RefactoringStatus.createErrorStatus(msg);
    }

    private RefactoringStatus checkEnclosingElements() throws CoreException {
        ICElement enclosingElement = RenameElementProcessor.findEnclosingElements(this.fCElement, this.fNewElementName);
        if (enclosingElement == null) {
            return null;
        }
        String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.enclosed", new String[]{this.fCElement.getElementName(), this.fNewElementName});
        return RefactoringStatus.createErrorStatus(msg);
    }

    private static ICElement findEnclosedElements(ICElement element, String newName) throws CoreException {
        if (element instanceof IParent) {
            ICElement[] enclosedTypes = ((IParent)element).getChildren();
            int i = 0;
            while (i < enclosedTypes.length) {
                if (newName.equals(enclosedTypes[i].getElementName()) || RenameElementProcessor.findEnclosedElements(enclosedTypes[i], newName) != null) {
                    return enclosedTypes[i];
                }
                ++i;
            }
        }
        return null;
    }

    private static ICElement findEnclosingElements(ICElement element, String newName) {
        ICElement enclosing = element.getParent();
        while (enclosing != null && !(enclosing instanceof ITranslationUnit)) {
            if (newName.equals(enclosing.getElementName())) {
                return enclosing;
            }
            enclosing = enclosing.getParent();
        }
        return null;
    }

    private boolean isTopLevelStructure(ICElement element) {
        if (element instanceof IStructure) {
            ICElement parent = element.getParent();
            while (!(parent instanceof ITranslationUnit)) {
                if (parent instanceof IStructure) {
                    return false;
                }
                parent = parent.getParent();
            }
            return true;
        }
        return false;
    }

    private ICElement[] getSiblings(ICElement element, boolean localSiblings) throws CModelException {
        if (localSiblings || !this.isTopLevelStructure(element)) {
            ICElement[] siblings = ((IParent)this.fCElement.getParent()).getChildren();
            return siblings;
        }
        new HashSet();
        ICElement parent = element.getParent();
        int level = 1;
        boolean folderIsFound = false;
        while (!folderIsFound) {
            if (parent instanceof ICContainer) {
                folderIsFound = true;
                break;
            }
            parent = parent.getParent();
            ++level;
        }
        HashSet<Object> parentsSet = new HashSet<Object>();
        HashSet<ICElement> childrenSet = new HashSet<ICElement>();
        ICElement[] pr = ((IParent)parent).getChildren();
        int i = 0;
        while (i < pr.length) {
            if (!(pr[i] instanceof ICContainer)) {
                parentsSet.add(pr[i]);
            }
            ++i;
        }
        int currentLevel = 1;
        while (currentLevel < level) {
            Iterator itr = parentsSet.iterator();
            while (itr.hasNext()) {
                ICElement p;
                Object o = itr.next();
                if (!(o instanceof ISourceManipulation) || !((p = (ICElement)o) instanceof IParent)) continue;
                ICElement[] ch = ((IParent)p).getChildren();
                int i2 = 0;
                while (i2 < ch.length) {
                    childrenSet.add(ch[i2]);
                    ++i2;
                }
            }
            if (++currentLevel >= level) continue;
            parentsSet.clear();
            parentsSet.addAll(childrenSet);
            childrenSet.clear();
        }
        return childrenSet.toArray(new ICElement[childrenSet.size()]);
    }

    private RefactoringStatus checkSiblingsCollision(boolean localSiblings) {
        RefactoringStatus result = new RefactoringStatus();
        try {
            ICElement[] siblings = this.getSiblings(this.fCElement, localSiblings);
            int i = 0;
            while (i < siblings.length) {
                ICElement sibling = siblings[i];
                if (sibling.getElementName().equals(this.fNewElementName) && sibling.getElementType() == this.fCElement.getElementType()) {
                    String msg;
                    if (localSiblings) {
                        msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.member_type_exists", new String[]{this.fNewElementName, this.fCElement.getParent().getElementName()});
                        result.addFatalError(msg);
                    } else {
                        msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.global_member_type_exists", new String[]{this.fNewElementName, this.fCElement.getParent().getElementName()});
                        result.addFatalError(msg);
                    }
                }
                ++i;
            }
        }
        catch (CModelException e) {
            result.addFatalError(e.getMessage());
        }
        return result;
    }

    private RefactoringStatus analyzeAffectedTranslationUnits() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.fReferences = Checks.excludeTranslationUnits(this.fReferences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fReferences));
        return result;
    }

    private boolean isConstructorOrDestructor(IFunctionDeclaration function) throws CModelException {
        IMethodDeclaration method;
        if (function instanceof IMethodDeclaration && ((method = (IMethodDeclaration)function).isConstructor() || method.isDestructor())) {
            return true;
        }
        String returnType = function.getReturnType();
        if (returnType == null || returnType.length() == 0) {
            return true;
        }
        return this.getCurrentElementName().startsWith("~");
    }

    private boolean eligibleForRefactoring(ICElement element) throws CModelException {
        if (element == null || !(element instanceof ISourceReference) || element instanceof ITranslationUnit || element instanceof IMacro || element instanceof IInclude) {
            return false;
        }
        if (element instanceof IFunctionDeclaration) {
            IFunctionDeclaration function = (IFunctionDeclaration)element;
            return !this.isConstructorOrDestructor(function);
        }
        return true;
    }
}

