/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import java.io.IOException;
import java.util.Set;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.ILineLocatable;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.IMatchLocatable;
import org.eclipse.cdt.core.search.IOffsetLocatable;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.ui.codemanipulation.StubUtility;
import org.eclipse.cdt.internal.ui.text.CCodeReader;
import org.eclipse.cdt.internal.ui.text.c.hover.AbstractCEditorTextHover;
import org.eclipse.cdt.internal.ui.text.c.hover.SourceViewerInformationControl;
import org.eclipse.cdt.internal.ui.util.Strings;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class CSourceHover
extends AbstractCEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IEditorPart editor = this.getEditor();
        if (editor != null) {
            IEditorInput input = editor.getEditorInput();
            IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
            IWorkingCopy copy = manager.getWorkingCopy(input);
            if (copy == null) {
                return null;
            }
            try {
                String expression = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
                expression = expression.trim();
                if (expression.length() == 0) {
                    return null;
                }
                String source = null;
                ICElement curr = copy.getElement(expression);
                source = curr == null ? this.findMatches(expression, textViewer) : ((ISourceReference)curr).getSource();
                if (source == null || source.trim().length() == 0) {
                    return null;
                }
                source = this.removeLeadingComments(source);
                String delim = null;
                try {
                    delim = StubUtility.getLineDelimiterUsed(curr);
                }
                catch (CModelException cModelException) {
                    delim = System.getProperty("line.separator", "\n");
                }
                String[] sourceLines = Strings.convertIntoLines(source);
                String firstLine = sourceLines[0];
                if (!Character.isWhitespace(firstLine.charAt(0))) {
                    sourceLines[0] = "";
                }
                Strings.trimIndentation(sourceLines, CSourceHover.getTabWidth());
                if (!Character.isWhitespace(firstLine.charAt(0))) {
                    sourceLines[0] = firstLine;
                }
                source = Strings.concatenate(sourceLines, delim);
                return source;
            }
            catch (BadLocationException badLocationException) {
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    private static int getTabWidth() {
        return 4;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String removeLeadingComments(String source) {
        block11: {
            reader = new CCodeReader();
            document = new Document(source);
            try {
                try {
                    reader.configureForwardReader((IDocument)document, 0, document.getLength(), true, false);
                    c = reader.read();
                    while (true) {
                        if (c == -1 || c != 13 && c != 10) {
                            i = reader.getOffset();
                            reader.close();
                        }
                        c = reader.read();
                    }
                }
                catch (IOException v0) {
                    i = 0;
                }
            }
            catch (Throwable var7_6) {
                var6_7 = null;
                try {
                    if (reader == null) throw var7_6;
                    reader.close();
                    throw var7_6;
                }
                catch (IOException ex) {
                    CUIPlugin.getDefault().log(ex);
                }
                throw var7_6;
            }
            {
                var6_8 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 96->107)] { 
lbl29:
            // 1 sources

            if (reader != null) {
                reader.close();
            }
            break block11;
lbl32:
            // 1 sources

            catch (IOException ex) {
                CUIPlugin.getDefault().log(ex);
            }
        }
        if (i >= 0) return source.substring(i);
        return source;
    }

    private String findMatches(String name, ITextViewer textViewer) {
        block16: {
            IEditorPart editor = this.getEditor();
            if (editor != null) {
                IEditorInput input = editor.getEditorInput();
                IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
                IWorkingCopy copy = manager.getWorkingCopy(input);
                if (this.selectionIsKeyword(name)) {
                    return null;
                }
                if (copy != null) {
                    try {
                        ICElement celement;
                        BasicSearchResultCollector searchResultCollector = new BasicSearchResultCollector();
                        ICProject cproject = copy.getCProject();
                        ICSearchScope scope = SearchEngine.createCSearchScope((ICElement[])new ICElement[]{cproject}, (boolean)true);
                        OrPattern orPattern = new OrPattern();
                        orPattern.addPattern(SearchEngine.createSearchPattern((String)name, (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
                        orPattern.addPattern(SearchEngine.createSearchPattern((String)name, (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false));
                        orPattern.addPattern(SearchEngine.createSearchPattern((String)name, (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
                        orPattern.addPattern(SearchEngine.createSearchPattern((String)name, (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
                        orPattern.addPattern(SearchEngine.createSearchPattern((String)name, (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
                        orPattern.addPattern(SearchEngine.createSearchPattern((String)name, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
                        SearchEngine searchEngine = new SearchEngine();
                        searchEngine.setWaitingPolicy(1);
                        searchEngine.search(CUIPlugin.getWorkspace(), (ICSearchPattern)orPattern, scope, (ICSearchResultCollector)searchResultCollector, true);
                        Set set = searchResultCollector.getSearchResults();
                        if (set == null || set.size() <= 0) break block16;
                        IMatch[] matches = new IMatch[set.size()];
                        set.toArray(matches);
                        IResource resource = matches[0].getResource();
                        if (resource == null || !((celement = CoreModel.getDefault().create(resource)) instanceof ITranslationUnit)) break block16;
                        ITranslationUnit unit = (ITranslationUnit)celement;
                        IMatchLocatable searchLocatable = matches[0].getLocatable();
                        int startOffset = 0;
                        int length = 0;
                        if (searchLocatable instanceof IOffsetLocatable) {
                            startOffset = ((IOffsetLocatable)searchLocatable).getNameStartOffset();
                            length = ((IOffsetLocatable)searchLocatable).getNameEndOffset() - startOffset;
                        } else if (searchLocatable instanceof ILineLocatable) {
                            int tempstartOffset = ((ILineLocatable)searchLocatable).getStartLine();
                            IDocument doc = textViewer.getDocument();
                            try {
                                startOffset = doc.getLineOffset(tempstartOffset - 1);
                                length = doc.getLineLength(tempstartOffset - 1);
                            }
                            catch (BadLocationException badLocationException) {
                            }
                            catch (NullPointerException nullPointerException) {
                                return null;
                            }
                            int tempendOffset = ((ILineLocatable)searchLocatable).getEndLine();
                            if (tempendOffset > 0 && tempendOffset > tempstartOffset) {
                                try {
                                    int endOffset = doc.getLineOffset(tempendOffset - 1);
                                    length = endOffset - startOffset;
                                }
                                catch (BadLocationException badLocationException) {
                                }
                                catch (NullPointerException nullPointerException) {
                                    return null;
                                }
                            }
                        }
                        return unit.getBuffer().getText(startOffset, length);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (CModelException cModelException) {}
                }
            }
        }
        return null;
    }

    private boolean selectionIsKeyword(String name) {
        Set keywords = ParserFactory.getKeywordSet((KeywordSetKey)KeywordSetKey.KEYWORDS, (ParserLanguage)ParserLanguage.CPP);
        return keywords.contains(name);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new SourceViewerInformationControl(parent, CSourceHover.this.getTooltipAffordanceString());
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int style = 768;
                return new SourceViewerInformationControl(parent, shellStyle, style);
            }
        };
    }
}

