/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CProposalContextInformation;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ICompletionContributor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;

public class SearchCompletionContributor
implements ICompletionContributor {
    private static ICSearchConstants.SearchFor[] completionSearchFor = new ICSearchConstants.SearchFor[]{ICSearchConstants.CLASS_STRUCT, ICSearchConstants.FUNCTION, ICSearchConstants.VAR, ICSearchConstants.UNION, ICSearchConstants.ENUM, ICSearchConstants.ENUMTOR, ICSearchConstants.NAMESPACE, ICSearchConstants.TYPEDEF, ICSearchConstants.MACRO};

    public void contributeCompletionProposals(ITextViewer viewer, int offset, IWorkingCopy workingCopy, ASTCompletionNode completionNode, String prefix, List proposals) {
        ICSearchScope scope;
        if (!this.validContext(completionNode)) {
            return;
        }
        if (prefix == null || prefix.length() == 0) {
            return;
        }
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.setWaitingPolicy(1);
        if (workingCopy != null) {
            ICElement[] projects = new ICElement[]{workingCopy.getCProject()};
            scope = SearchEngine.createCSearchScope((ICElement[])projects, (boolean)true);
        } else {
            scope = SearchEngine.createWorkspaceScope();
        }
        String patternString = String.valueOf(prefix) + "*";
        OrPattern pattern = new OrPattern();
        int i = 0;
        while (i < completionSearchFor.length) {
            pattern.addPattern(SearchEngine.createSearchPattern((String)patternString, (ICSearchConstants.SearchFor)completionSearchFor[i], (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)true));
            ++i;
        }
        BasicSearchResultCollector collector = new BasicSearchResultCollector();
        try {
            searchEngine.search(CUIPlugin.getWorkspace(), (ICSearchPattern)pattern, scope, (ICSearchResultCollector)collector, false);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        Set results = collector.getSearchResults();
        Iterator iResults = results.iterator();
        while (iResults.hasNext()) {
            IMatch match = (IMatch)iResults.next();
            switch (match.getElementType()) {
                case 70: 
                case 71: 
                case 73: 
                case 74: {
                    this.handleFunction(match, viewer, prefix, offset, proposals);
                    break;
                }
                default: {
                    this.handleMatch(match, viewer, prefix, offset, proposals);
                }
            }
        }
    }

    private boolean validContext(ASTCompletionNode completionNode) {
        if (completionNode == null) {
            return true;
        }
        boolean valid = true;
        IASTName[] names = completionNode.getNames();
        int i = 0;
        while (i < names.length) {
            IASTName name = names[i];
            if (name.getTranslationUnit() != null) {
                if (name.getParent() instanceof IASTFieldReference) {
                    valid = false;
                } else {
                    return true;
                }
            }
            ++i;
        }
        return valid;
    }

    private void handleMatch(IMatch match, ITextViewer viewer, String prefix, int offset, List proposals) {
        int repLength = prefix.length();
        int repOffset = offset - repLength;
        Image image = CUIPlugin.getImageDescriptorRegistry().get(CElementImageProvider.getImageDescriptor(match.getElementType()));
        String repString = match.getName();
        CCompletionProposal proposal = new CCompletionProposal(repString, repOffset, repLength, image, repString, 1, viewer);
        proposals.add(proposal);
    }

    private void handleFunction(IMatch match, ITextViewer viewer, String prefix, int offset, List proposals) {
        Image image = CUIPlugin.getImageDescriptorRegistry().get(CElementImageProvider.getImageDescriptor(match.getElementType()));
        StringBuffer repStringBuff = new StringBuffer();
        repStringBuff.append(match.getName());
        repStringBuff.append('(');
        StringBuffer args = new StringBuffer();
        String[] params = match.getParameters();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                if (i > 0) {
                    args.append(',');
                }
                args.append(params[i]);
                ++i;
            }
        }
        String returnType = match.getReturnType();
        String argString = args.toString();
        StringBuffer dispStringBuff = new StringBuffer(repStringBuff.toString());
        dispStringBuff.append(argString);
        dispStringBuff.append(')');
        repStringBuff.append(')');
        String repString = repStringBuff.toString();
        String idString = null;
        if (returnType != null) {
            idString = dispStringBuff.toString();
            dispStringBuff.append(' ');
            dispStringBuff.append(returnType);
        }
        String dispString = dispStringBuff.toString();
        int repLength = prefix.length();
        int repOffset = offset - repLength;
        CCompletionProposal proposal = new CCompletionProposal(repString, repOffset, repLength, image, dispString, idString, 1, viewer);
        proposal.setCursorPosition(repString.length() - 1);
        if (argString.length() > 0) {
            CProposalContextInformation info = new CProposalContextInformation(repString, argString);
            info.setContextInformationPosition(offset);
            proposal.setContextInformation(info);
        }
        proposals.add(proposal);
    }
}

