/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.cindexstorage.io;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.Util;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.Block;

public class FileListBlock
extends Block {
    protected int offset = 0;
    protected String prevPath = null;
    protected String[] paths = null;

    public FileListBlock(int blockSize) {
        super(blockSize);
    }

    public boolean addFile(IndexedFileEntry indexedFile) {
        int offset = this.offset;
        if (this.isEmpty()) {
            this.field.putInt4(offset, indexedFile.getFileID());
            offset += 4;
        }
        String path = indexedFile.getPath();
        int prefixLen = this.prevPath == null ? 0 : Util.prefixLength(this.prevPath, path);
        int sizeEstimate = 4 + (path.length() - prefixLen) * 3;
        if (offset + sizeEstimate > this.blockSize - 2) {
            return false;
        }
        this.field.putInt2(offset, prefixLen);
        offset += 2;
        char[] chars = new char[path.length() - prefixLen];
        path.getChars(prefixLen, path.length(), chars, 0);
        offset += this.field.putUTF(offset, chars);
        this.offset = offset;
        this.prevPath = path;
        return true;
    }

    public void clear() {
        this.reset();
        super.clear();
    }

    public void flush() {
        if (this.offset > 0) {
            this.field.putInt2(this.offset, 0);
            this.field.putInt2(this.offset + 2, 0);
            this.offset = 0;
        }
    }

    public IndexedFileEntry getFile(int fileNum) throws IOException {
        IndexedFileEntry resp = null;
        try {
            String[] paths = this.getPaths();
            int i = fileNum - this.field.getInt4(0);
            if (i >= paths.length) {
                return null;
            }
            resp = new IndexedFileEntry(paths[i], fileNum);
        }
        catch (Exception exception) {}
        return resp;
    }

    protected String[] getPaths() throws IOException {
        if (this.paths == null) {
            ArrayList<String> v = new ArrayList<String>();
            int offset = 4;
            char[] prevPath = null;
            while (true) {
                int prefixLen = this.field.getUInt2(offset);
                int utfLen = this.field.getUInt2(offset += 2);
                char[] path = this.field.getUTF(offset);
                offset += 2 + utfLen;
                if (prefixLen != 0) {
                    char[] temp = new char[prefixLen + path.length];
                    System.arraycopy(prevPath, 0, temp, 0, prefixLen);
                    System.arraycopy(path, 0, temp, prefixLen, path.length);
                    path = temp;
                }
                if (path.length == 0) break;
                v.add(new String(path));
                prevPath = path;
            }
            this.paths = new String[v.size()];
            v.toArray(this.paths);
        }
        return this.paths;
    }

    public boolean isEmpty() {
        return this.offset == 0;
    }

    public void reset() {
        this.offset = 0;
        this.prevPath = null;
    }
}

