/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.browser.typehierarchy.ITypeHierarchy;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.cdt.internal.ui.actions.SelectAllAction;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.EnableMemberFilterAction;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.FocusOnSelectionAction;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.FocusOnTypeAction;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.HistoryDropDownAction;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.ITypeHierarchyLifeCycleListener;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.ITypeHierarchyViewPart;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.MethodsViewer;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.SelectionProviderMediator;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.ShowQualifiedTypeNamesAction;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.SubTypeHierarchyViewer;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.SuperTypeHierarchyViewer;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.ToggleLinkingAction;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.ToggleOrientationAction;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.ToggleViewAction;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyMessages;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyViewer;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabels;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.cdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.cdt.ui.actions.OpenViewActionGroup;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class TypeHierarchyViewPart
extends ViewPart
implements ITypeHierarchyViewPart,
IViewPartInputProvider {
    public static final int VIEW_ID_SUPER = 0;
    public static final int VIEW_ID_SUB = 1;
    public static final int VIEW_ORIENTATION_VERTICAL = 0;
    public static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    public static final int VIEW_ORIENTATION_SINGLE = 2;
    public static final int VIEW_ORIENTATION_AUTOMATIC = 3;
    private static final String DIALOGSTORE_HIERARCHYVIEW = "TypeHierarchyViewPart.hierarchyview";
    private static final String DIALOGSTORE_VIEWORIENTATION = "TypeHierarchyViewPart.orientation";
    private static final String TAG_VIEW = "view";
    private static final String TAG_ORIENTATION = "orientation";
    private static final String TAG_RATIO = "ratio";
    private static final String TAG_VERTICAL_SCROLL = "vertical_scroll";
    private static final String GROUP_FOCUS = "group.focus";
    private ICElement fSelectedType = null;
    private ICElement fInputElement = null;
    private ArrayList fInputHistory;
    private IMemento fMemento;
    private IDialogSettings fDialogSettings;
    protected TypeHierarchyLifeCycle fHierarchyLifeCycle = new TypeHierarchyLifeCycle();
    private ITypeHierarchyLifeCycleListener fTypeHierarchyLifeCycleListener = new ITypeHierarchyLifeCycleListener(){

        public void typeHierarchyChanged(TypeHierarchyLifeCycle typeHierarchy, ICElement[] changedTypes) {
            TypeHierarchyViewPart.this.doTypeHierarchyChanged(typeHierarchy, changedTypes);
        }
    };
    private IPropertyChangeListener fPropertyChangeListener;
    private SelectionProviderMediator fSelectionProviderMediator;
    private ISelectionChangedListener fSelectionChangedListener;
    private IPartListener2 fPartListener;
    private int fCurrentOrientation;
    int fOrientation = 3;
    boolean fInComputeOrientation = false;
    private boolean fLinkingEnabled;
    private boolean fSelectInEditor = true;
    private boolean fIsVisible = false;
    private boolean fNeedRefresh;
    private boolean fIsEnableMemberFilter;
    protected boolean fIsRefreshRunnablePosted = false;
    private int fCurrentViewerIndex;
    private TypeHierarchyViewer[] fAllViewers;
    protected MethodsViewer fMethodsViewer;
    private SashForm fTypeMethodsSplitter;
    private PageBook fViewerbook;
    protected PageBook fPagebook;
    private Label fNoHierarchyShownLabel;
    private Label fEmptyTypesViewer;
    private ViewForm fTypeViewerViewForm;
    private ViewForm fMethodViewerViewForm;
    private CLabel fMethodViewerPaneLabel;
    private CUILabelProvider fPaneLabelProvider;
    private Composite fParent;
    private ToggleViewAction[] fViewActions;
    private ToggleLinkingAction fToggleLinkingAction;
    private HistoryDropDownAction fHistoryDropDownAction;
    private ToggleOrientationAction[] fToggleOrientationActions;
    private EnableMemberFilterAction fEnableMemberFilterAction;
    private ShowQualifiedTypeNamesAction fShowQualifiedTypeNamesAction;
    private FocusOnTypeAction fFocusOnTypeAction;
    private FocusOnSelectionAction fFocusOnSelectionAction;
    private CompositeActionGroup fActionGroups;
    protected SelectAllAction fSelectAllAction;
    private WorkingSetFilterActionGroup fWorkingSetActionGroup;
    private Job fRestoreStateJob = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public TypeHierarchyViewPart() {
        this.fHierarchyLifeCycle.addChangedListener(this.fTypeHierarchyLifeCycleListener);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TypeHierarchyViewPart.this.doPropertyChange(event);
            }
        };
        PreferenceConstants.getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
        this.fIsEnableMemberFilter = false;
        this.fInputHistory = new ArrayList();
        this.fAllViewers = null;
        this.fViewActions = new ToggleViewAction[]{new ToggleViewAction(this, 0), new ToggleViewAction(this, 1)};
        this.fDialogSettings = CUIPlugin.getDefault().getDialogSettings();
        this.fHistoryDropDownAction = new HistoryDropDownAction(this);
        this.fHistoryDropDownAction.setEnabled(false);
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, 0), new ToggleOrientationAction(this, 1), new ToggleOrientationAction(this, 3), new ToggleOrientationAction(this, 2)};
        this.fEnableMemberFilterAction = new EnableMemberFilterAction(this, false);
        this.fShowQualifiedTypeNamesAction = new ShowQualifiedTypeNamesAction(this, false);
        this.fFocusOnTypeAction = new FocusOnTypeAction(this);
        this.fPaneLabelProvider = new CUILabelProvider();
        this.fFocusOnSelectionAction = new FocusOnSelectionAction(this);
        this.fPartListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference ref) {
                IWorkbenchPart part = ref.getPart(false);
                if (part == TypeHierarchyViewPart.this) {
                    TypeHierarchyViewPart.this.visibilityChanged(true);
                }
            }

            public void partHidden(IWorkbenchPartReference ref) {
                IWorkbenchPart part = ref.getPart(false);
                if (part == TypeHierarchyViewPart.this) {
                    TypeHierarchyViewPart.this.visibilityChanged(false);
                }
            }

            public void partActivated(IWorkbenchPartReference ref) {
                IWorkbenchPart part = ref.getPart(false);
                if (part instanceof IEditorPart) {
                    TypeHierarchyViewPart.this.editorActivated((IEditorPart)part);
                }
            }

            public void partInputChanged(IWorkbenchPartReference ref) {
                IWorkbenchPart part = ref.getPart(false);
                if (part instanceof IEditorPart) {
                    TypeHierarchyViewPart.this.editorActivated((IEditorPart)part);
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference ref) {
            }

            public void partClosed(IWorkbenchPartReference ref) {
            }

            public void partDeactivated(IWorkbenchPartReference ref) {
            }

            public void partOpened(IWorkbenchPartReference ref) {
            }
        };
        this.fSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TypeHierarchyViewPart.this.doSelectionChanged(event);
            }
        };
        this.fLinkingEnabled = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.packages.linktypehierarchytoeditor");
    }

    protected void doPropertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("workingSetContentChange".equals(property)) {
            this.updateHierarchyViewer(true);
        }
    }

    private void addHistoryEntry(ICElement entry) {
        if (this.fInputHistory.contains(entry)) {
            this.fInputHistory.remove(entry);
        }
        this.fInputHistory.add(0, entry);
        this.fHistoryDropDownAction.setEnabled(true);
    }

    private void updateHistoryEntries() {
        int i = this.fInputHistory.size() - 1;
        while (i >= 0) {
            ICElement type = (ICElement)this.fInputHistory.get(i);
            if (!type.exists()) {
                this.fInputHistory.remove(i);
            }
            --i;
        }
        this.fHistoryDropDownAction.setEnabled(!this.fInputHistory.isEmpty());
    }

    public void gotoHistoryEntry(ICElement entry) {
        if (this.fInputHistory.contains(entry)) {
            this.updateInput(entry);
        }
    }

    public ICElement[] getHistoryEntries() {
        if (this.fInputHistory.size() > 0) {
            this.updateHistoryEntries();
        }
        return this.fInputHistory.toArray(new ICElement[this.fInputHistory.size()]);
    }

    public void setHistoryEntries(ICElement[] elems) {
        this.fInputHistory.clear();
        int i = 0;
        while (i < elems.length) {
            this.fInputHistory.add(elems[i]);
            ++i;
        }
        this.updateHistoryEntries();
    }

    public void selectMember(ICElement member) {
        this.fSelectInEditor = false;
        if (!TypeUtil.isClassOrStruct((ICElement)member)) {
            Control methodControl = this.fMethodsViewer.getControl();
            if (methodControl != null && !methodControl.isDisposed()) {
                methodControl.setFocus();
            }
            this.fMethodsViewer.setSelection((ISelection)new StructuredSelection((Object)member), true);
        } else {
            Control viewerControl = this.getCurrentViewer().getControl();
            if (viewerControl != null && !viewerControl.isDisposed()) {
                viewerControl.setFocus();
            }
            if (!member.equals(this.fSelectedType)) {
                this.getCurrentViewer().setSelection((ISelection)new StructuredSelection((Object)member), true);
            }
        }
        this.fSelectInEditor = true;
    }

    public ICElement getInput() {
        return this.fInputElement;
    }

    public void setInput(ICElement type) {
        this.setInputElement(type);
    }

    public ICElement getInputElement() {
        return this.fInputElement;
    }

    public void setInputElement(ICElement element) {
        if (element != null) {
            if (!(element instanceof IStructure)) {
                element = TypeUtil.getDeclaringClass((ICElement)element);
            }
            if (element == null || !element.exists()) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)TypeHierarchyMessages.getString("TypeHierarchyViewPart.error.title"), (String)TypeHierarchyMessages.getString("TypeHierarchyViewPart.error.message"));
                return;
            }
        } else {
            CUIPlugin.getDefault().logErrorMessage("Invalid type hierarchy input type.");
        }
        if (element != null && !element.equals(this.fInputElement)) {
            this.addHistoryEntry(element);
        }
        this.updateInput(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateInput(ICElement inputElement) {
        ICElement prevInput = this.fInputElement;
        TypeHierarchyViewPart typeHierarchyViewPart = this;
        synchronized (typeHierarchyViewPart) {
            if (this.fRestoreStateJob != null) {
                this.fRestoreStateJob.cancel();
                try {
                    try {
                        this.fRestoreStateJob.join();
                    }
                    catch (InterruptedException interruptedException) {}
                    Object var4_7 = null;
                    this.fRestoreStateJob = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.fRestoreStateJob = null;
                    throw throwable;
                }
            }
        }
        this.processOutstandingEvents();
        if (inputElement == null) {
            this.clearInput();
            return;
        }
        this.fInputElement = inputElement;
        try {
            this.fHierarchyLifeCycle.ensureRefreshedTypeHierarchy(inputElement, (IRunnableContext)CUIPlugin.getActiveWorkbenchWindow());
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getSite().getShell(), TypeHierarchyMessages.getString("TypeHierarchyViewPart.exception.title"), TypeHierarchyMessages.getString("TypeHierarchyViewPart.exception.message"));
            this.clearInput();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (!TypeUtil.isClassOrStruct((ICElement)inputElement)) {
            this.setView(0);
        }
        this.fSelectInEditor = false;
        this.setMemberFilter(null);
        this.internalSelectType(null, false);
        this.fIsEnableMemberFilter = false;
        if (!inputElement.equals(prevInput)) {
            this.updateHierarchyViewer(true);
        }
        ICElement root = this.getSelectableType(inputElement);
        this.internalSelectType(root, true);
        this.updateMethodViewer(root);
        this.updateToolbarButtons();
        this.updateTitle();
        this.enableMemberFilter(false);
        this.fPagebook.showPage((Control)this.fTypeMethodsSplitter);
        this.fSelectInEditor = true;
    }

    private void processOutstandingEvents() {
        Display display = this.getDisplay();
        if (display != null && !display.isDisposed()) {
            display.update();
        }
    }

    private void clearInput() {
        this.fInputElement = null;
        this.fHierarchyLifeCycle.freeHierarchy();
        this.updateHierarchyViewer(false);
        this.updateToolbarButtons();
    }

    public void setFocus() {
        this.fPagebook.setFocus();
    }

    public void dispose() {
        this.fHierarchyLifeCycle.freeHierarchy();
        this.fHierarchyLifeCycle.removeChangedListener(this.fTypeHierarchyLifeCycleListener);
        this.fPaneLabelProvider.dispose();
        if (this.fMethodsViewer != null) {
            this.fMethodsViewer.dispose();
        }
        if (this.fPropertyChangeListener != null) {
            CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        this.getSite().getPage().removePartListener(this.fPartListener);
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        if (this.fWorkingSetActionGroup != null) {
            this.fWorkingSetActionGroup.dispose();
        }
        super.dispose();
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return this.getShowInSource();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz2) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.cdt.ui.CView", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(key);
    }

    private Control createTypeViewerControl(Composite parent) {
        int currViewerIndex;
        this.fViewerbook = new PageBook(parent, 0);
        KeyListener keyListener = this.createKeyListener();
        SuperTypeHierarchyViewer superTypesViewer = new SuperTypeHierarchyViewer((Composite)this.fViewerbook, this.fHierarchyLifeCycle, (IWorkbenchPart)this);
        this.initializeTypesViewer(superTypesViewer, keyListener, "org.eclipse.cdt.ui.TypeHierarchyView.supertypes");
        SubTypeHierarchyViewer subTypesViewer = new SubTypeHierarchyViewer((Composite)this.fViewerbook, this.fHierarchyLifeCycle, (IWorkbenchPart)this);
        this.initializeTypesViewer(subTypesViewer, keyListener, "org.eclipse.cdt.ui.TypeHierarchyView.subtypes");
        this.fAllViewers = new TypeHierarchyViewer[2];
        this.fAllViewers[0] = superTypesViewer;
        this.fAllViewers[1] = subTypesViewer;
        try {
            currViewerIndex = this.fDialogSettings.getInt(DIALOGSTORE_HIERARCHYVIEW);
            if (currViewerIndex < 0 || currViewerIndex > 2) {
                currViewerIndex = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            currViewerIndex = 0;
        }
        this.fEmptyTypesViewer = new Label((Composite)this.fViewerbook, 16384);
        int i = 0;
        while (i < this.fAllViewers.length) {
            this.fAllViewers[i].setInput((Object)this.fAllViewers[i]);
            ++i;
        }
        this.fCurrentViewerIndex = -1;
        this.setView(currViewerIndex);
        return this.fViewerbook;
    }

    private KeyListener createKeyListener() {
        return new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.stateMask == 0 && event.keyCode == 0x100000E) {
                    ITypeHierarchy hierarchy = TypeHierarchyViewPart.this.fHierarchyLifeCycle.getHierarchy();
                    if (hierarchy != null) {
                        TypeHierarchyViewPart.this.fHierarchyLifeCycle.typeHierarchyChanged(hierarchy);
                        TypeHierarchyViewPart.this.doTypeHierarchyChangedOnViewers(null);
                    }
                    TypeHierarchyViewPart.this.updateHierarchyViewer(false);
                    return;
                }
            }
        };
    }

    private void initializeTypesViewer(final TypeHierarchyViewer typesViewer, KeyListener keyListener, String cotextHelpId) {
        typesViewer.getControl().setVisible(false);
        typesViewer.getControl().addKeyListener(keyListener);
        typesViewer.initContextMenu(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                TypeHierarchyViewPart.this.fillTypesViewerContextMenu(typesViewer, menu);
            }
        }, cotextHelpId, this.getSite());
        typesViewer.addPostSelectionChangedListener(this.fSelectionChangedListener);
        typesViewer.setQualifiedTypeName(this.isShowQualifiedTypeNames());
        typesViewer.setWorkingSetFilter(this.fWorkingSetActionGroup.getWorkingSetFilter());
    }

    private Control createMethodViewerControl(Composite parent) {
        this.fMethodsViewer = new MethodsViewer(parent, this.fHierarchyLifeCycle, (IWorkbenchPart)this);
        this.fMethodsViewer.initContextMenu(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                TypeHierarchyViewPart.this.fillMethodsViewerContextMenu(menu);
            }
        }, "org.eclipse.cdt.ui.TypeHierarchyView.members", this.getSite());
        this.fMethodsViewer.addPostSelectionChangedListener(this.fSelectionChangedListener);
        Table control = this.fMethodsViewer.getTable();
        control.addKeyListener(this.createKeyListener());
        control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TypeHierarchyViewPart.this.fSelectAllAction.setEnabled(true);
            }

            public void focusLost(FocusEvent e) {
                TypeHierarchyViewPart.this.fSelectAllAction.setEnabled(false);
            }
        });
        return control;
    }

    private void initDragAndDrop() {
    }

    public void createPartControl(Composite container) {
        this.fParent = container;
        this.addResizeListener(container);
        this.fPagebook = new PageBook(container, 0);
        this.fWorkingSetActionGroup = new WorkingSetFilterActionGroup("org.eclipse.cdt.ui.TypeHierarchyView", container.getShell(), this.fPropertyChangeListener);
        this.fNoHierarchyShownLabel = new Label((Composite)this.fPagebook, 16576);
        this.fNoHierarchyShownLabel.setText(TypeHierarchyMessages.getString("TypeHierarchyViewPart.empty"));
        this.fTypeMethodsSplitter = new SashForm((Composite)this.fPagebook, 512);
        this.fTypeMethodsSplitter.setVisible(false);
        this.fTypeViewerViewForm = new ViewForm((Composite)this.fTypeMethodsSplitter, 0);
        Control typeViewerControl = this.createTypeViewerControl((Composite)this.fTypeViewerViewForm);
        this.fTypeViewerViewForm.setContent(typeViewerControl);
        this.fMethodViewerViewForm = new ViewForm((Composite)this.fTypeMethodsSplitter, 0);
        this.fTypeMethodsSplitter.setWeights(new int[]{35, 65});
        Control methodViewerPart = this.createMethodViewerControl((Composite)this.fMethodViewerViewForm);
        this.fMethodViewerViewForm.setContent(methodViewerPart);
        this.fMethodViewerPaneLabel = new CLabel((Composite)this.fMethodViewerViewForm, 0);
        this.fMethodViewerViewForm.setTopLeft((Control)this.fMethodViewerPaneLabel);
        ToolBar methodViewerToolBar = new ToolBar((Composite)this.fMethodViewerViewForm, 0x800040);
        this.fMethodViewerViewForm.setTopCenter((Control)methodViewerToolBar);
        this.initDragAndDrop();
        MenuManager menu = new MenuManager();
        menu.add((IAction)this.fFocusOnTypeAction);
        this.fNoHierarchyShownLabel.setMenu(menu.createContextMenu((Control)this.fNoHierarchyShownLabel));
        this.fPagebook.showPage((Control)this.fNoHierarchyShownLabel);
        try {
            this.fOrientation = this.fDialogSettings.getInt(DIALOGSTORE_VIEWORIENTATION);
            if (this.fOrientation < 0 || this.fOrientation > 3) {
                this.fOrientation = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fOrientation = 3;
        }
        this.fCurrentOrientation = -1;
        this.setOrientation(this.fOrientation);
        if (this.fMemento != null) {
            this.restoreLinkingEnabled(this.fMemento);
        }
        this.fToggleLinkingAction = new ToggleLinkingAction(this);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        int i = 0;
        while (i < this.fViewActions.length) {
            ToggleViewAction action = this.fViewActions[i];
            viewMenu.add((IAction)action);
            action.setEnabled(false);
            ++i;
        }
        viewMenu.add((IContributionItem)new Separator());
        this.fWorkingSetActionGroup.contributeToMenu(viewMenu);
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(TypeHierarchyMessages.getString("TypeHierarchyViewPart.layout.submenu"));
        viewMenu.add((IContributionItem)layoutSubMenu);
        int i2 = 0;
        while (i2 < this.fToggleOrientationActions.length) {
            layoutSubMenu.add((IAction)this.fToggleOrientationActions[i2]);
            ++i2;
        }
        viewMenu.add((IContributionItem)new Separator("additions"));
        viewMenu.add((IAction)this.fShowQualifiedTypeNamesAction);
        viewMenu.add((IAction)this.fToggleLinkingAction);
        ToolBarManager lowertbmanager = new ToolBarManager(methodViewerToolBar);
        lowertbmanager.add((IAction)this.fEnableMemberFilterAction);
        lowertbmanager.add((IContributionItem)new Separator());
        this.fMethodsViewer.contributeToToolBar(lowertbmanager);
        lowertbmanager.update(true);
        int nHierarchyViewers = this.fAllViewers.length;
        StructuredViewer[] trackedViewers = new StructuredViewer[nHierarchyViewers + 1];
        int i3 = 0;
        while (i3 < nHierarchyViewers) {
            trackedViewers[i3] = this.fAllViewers[i3];
            ++i3;
        }
        trackedViewers[nHierarchyViewers] = this.fMethodsViewer;
        this.fSelectionProviderMediator = new SelectionProviderMediator(trackedViewers);
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fSelectionProviderMediator.addSelectionChangedListener(new StatusBarUpdater(slManager));
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProviderMediator);
        this.getSite().getPage().addPartListener(this.fPartListener);
        ICElement input = null;
        if (this.fMemento != null) {
            this.restoreState(this.fMemento, input);
        } else if (input != null) {
            this.setInputElement(input);
        } else {
            this.setViewerVisibility(false);
        }
        WorkbenchHelp.setHelp((Control)this.fPagebook, (String)"org.eclipse.cdt.ui.type_hierarchy_view_context");
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{new OpenViewActionGroup(this)});
        this.fActionGroups.fillActionBars(actionBars);
        this.fSelectAllAction = new SelectAllAction(this.fMethodsViewer);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TypeHierarchyViewPart.this.computeOrientation();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void computeOrientation() {
        if (this.fInComputeOrientation) {
            return;
        }
        this.fInComputeOrientation = true;
        try {
            if (this.fOrientation != 3) {
                this.setOrientation(this.fOrientation);
            } else {
                if (this.fOrientation == 2) {
                    Object var2_1 = null;
                    this.fInComputeOrientation = false;
                    return;
                }
                Point size = this.fParent.getSize();
                if (size.x != 0 && size.y != 0) {
                    if (size.x > size.y) {
                        this.setOrientation(1);
                    } else {
                        this.setOrientation(0);
                    }
                }
            }
            Object var2_3 = null;
            this.fInComputeOrientation = false;
            return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.fInComputeOrientation = false;
            throw throwable;
        }
    }

    public void setOrientation(int orientation) {
        if (this.fCurrentOrientation != orientation) {
            boolean methodViewerNeedsUpdate = false;
            if (this.fMethodViewerViewForm != null && !this.fMethodViewerViewForm.isDisposed() && this.fTypeMethodsSplitter != null && !this.fTypeMethodsSplitter.isDisposed()) {
                if (orientation == 2) {
                    this.fMethodViewerViewForm.setVisible(false);
                    this.enableMemberFilter(false);
                    this.updateMethodViewer(null);
                } else {
                    if (this.fCurrentOrientation == 2) {
                        this.fMethodViewerViewForm.setVisible(true);
                        methodViewerNeedsUpdate = true;
                    }
                    boolean horizontal = orientation == 1;
                    this.fTypeMethodsSplitter.setOrientation(horizontal ? 256 : 512);
                }
                this.updateMainToolbar(orientation);
                this.fTypeMethodsSplitter.layout();
            }
            this.updateCheckedState();
            if (methodViewerNeedsUpdate) {
                this.updateMethodViewer(this.fSelectedType);
            }
            this.fDialogSettings.put(DIALOGSTORE_VIEWORIENTATION, orientation);
            this.fCurrentOrientation = orientation;
        }
    }

    private void updateCheckedState() {
        int i = 0;
        while (i < this.fToggleOrientationActions.length) {
            this.fToggleOrientationActions[i].setChecked(this.fOrientation == this.fToggleOrientationActions[i].getOrientation());
            ++i;
        }
    }

    private void updateMainToolbar(int orientation) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbmanager = actionBars.getToolBarManager();
        if (orientation == 1) {
            this.clearMainToolBar(tbmanager);
            ToolBar typeViewerToolBar = new ToolBar((Composite)this.fTypeViewerViewForm, 0x800040);
            this.fillMainToolBar((IToolBarManager)new ToolBarManager(typeViewerToolBar));
            this.fTypeViewerViewForm.setTopLeft((Control)typeViewerToolBar);
        } else {
            this.fTypeViewerViewForm.setTopLeft(null);
            this.fillMainToolBar(tbmanager);
        }
    }

    private void fillMainToolBar(IToolBarManager tbmanager) {
        tbmanager.removeAll();
        int i = 0;
        while (i < this.fViewActions.length) {
            tbmanager.add((IAction)this.fViewActions[i]);
            ++i;
        }
        tbmanager.add((IAction)this.fHistoryDropDownAction);
        tbmanager.update(false);
    }

    private void clearMainToolBar(IToolBarManager tbmanager) {
        tbmanager.removeAll();
        tbmanager.update(false);
    }

    protected void fillTypesViewerContextMenu(TypeHierarchyViewer viewer, IMenuManager menu) {
        CUIPlugin.createStandardGroups(menu);
        menu.appendToGroup("group.show", (IContributionItem)new Separator(GROUP_FOCUS));
        viewer.contributeToContextMenu(menu);
        if (this.fFocusOnSelectionAction.canActionBeAdded()) {
            menu.appendToGroup(GROUP_FOCUS, (IAction)this.fFocusOnSelectionAction);
        }
        menu.appendToGroup(GROUP_FOCUS, (IAction)this.fFocusOnTypeAction);
        this.fActionGroups.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroups.fillContextMenu(menu);
        this.fActionGroups.setContext(null);
    }

    protected void fillMethodsViewerContextMenu(IMenuManager menu) {
        CUIPlugin.createStandardGroups(menu);
        this.fMethodsViewer.contributeToContextMenu(menu);
        this.fActionGroups.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroups.fillContextMenu(menu);
        this.fActionGroups.setContext(null);
    }

    private void setViewerVisibility(boolean showHierarchy) {
        if (showHierarchy) {
            this.fViewerbook.showPage(this.getCurrentViewer().getControl());
        } else {
            this.fViewerbook.showPage((Control)this.fEmptyTypesViewer);
        }
    }

    private void setMemberFilter(IMember[] memberFilter) {
        Assert.isNotNull((Object)this.fAllViewers);
        int i = 0;
        while (i < this.fAllViewers.length) {
            this.fAllViewers[i].setMemberFilter(memberFilter);
            ++i;
        }
    }

    private ICElement getSelectableType(ICElement elem) {
        if (!TypeUtil.isClassOrStruct((ICElement)elem)) {
            return this.getCurrentViewer().getTreeRootType();
        }
        return elem;
    }

    private void internalSelectType(ICElement elem, boolean reveal) {
        TypeHierarchyViewer viewer = this.getCurrentViewer();
        if (viewer != null) {
            viewer.removePostSelectionChangedListener(this.fSelectionChangedListener);
            viewer.setSelection((ISelection)(elem != null ? new StructuredSelection((Object)elem) : StructuredSelection.EMPTY), reveal);
            viewer.addPostSelectionChangedListener(this.fSelectionChangedListener);
        }
    }

    protected void updateHierarchyViewer(final boolean doExpand) {
        if (this.fInputElement == null) {
            this.fNoHierarchyShownLabel.setText(TypeHierarchyMessages.getString("TypeHierarchyViewPart.empty"));
            this.fPagebook.showPage((Control)this.fNoHierarchyShownLabel);
        } else {
            final TypeHierarchyViewer viewer = this.getCurrentViewer();
            if (viewer != null && viewer.containsElements() != null) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        viewer.updateContent(doExpand);
                    }
                };
                BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)runnable);
                if (!this.isChildVisible((Composite)this.fViewerbook, viewer.getControl())) {
                    this.setViewerVisibility(true);
                }
            } else {
                this.fEmptyTypesViewer.setText(TypeHierarchyMessages.getFormattedString("TypeHierarchyViewPart.nodecl", this.fInputElement.getElementName()));
                this.setViewerVisibility(false);
            }
        }
    }

    private void updateMethodViewer(final ICElement input) {
        if (!this.fIsEnableMemberFilter && this.fCurrentOrientation != 2) {
            if (input == this.fMethodsViewer.getInput()) {
                if (input != null) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            TypeHierarchyViewPart.this.fMethodsViewer.refresh();
                        }
                    };
                    BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)runnable);
                }
            } else {
                if (input != null) {
                    this.fMethodViewerPaneLabel.setText(this.fPaneLabelProvider.getText(input));
                    this.fMethodViewerPaneLabel.setImage(this.fPaneLabelProvider.getImage(input));
                } else {
                    this.fMethodViewerPaneLabel.setText("");
                    this.fMethodViewerPaneLabel.setImage(null);
                }
                Runnable runnable = new Runnable(){

                    public void run() {
                        TypeHierarchyViewPart.this.fMethodsViewer.setInput(input);
                    }
                };
                BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)runnable);
            }
        }
    }

    protected void doSelectionChanged(SelectionChangedEvent e) {
        if (e.getSelectionProvider() == this.fMethodsViewer) {
            this.methodSelectionChanged(e.getSelection());
        } else {
            this.typeSelectionChanged(e.getSelection());
        }
    }

    private void methodSelectionChanged(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            List selected = ((IStructuredSelection)sel).toList();
            int nSelected = selected.size();
            if (this.fIsEnableMemberFilter) {
                IMember[] memberFilter = null;
                if (nSelected > 0) {
                    memberFilter = new IMember[nSelected];
                    selected.toArray(memberFilter);
                }
                this.setMemberFilter(memberFilter);
                this.updateHierarchyViewer(true);
                this.updateTitle();
                this.internalSelectType(this.fSelectedType, true);
            }
            if (nSelected == 1 && this.fSelectInEditor) {
                this.revealElementInEditor(selected.get(0), (StructuredViewer)this.fMethodsViewer);
            }
        }
    }

    private void typeSelectionChanged(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            List selected = ((IStructuredSelection)sel).toList();
            int nSelected = selected.size();
            if (nSelected != 0) {
                ArrayList types = new ArrayList(nSelected);
                int i = nSelected - 1;
                while (i >= 0) {
                    Object elem = selected.get(i);
                    if (elem instanceof ICElement && !types.contains(elem)) {
                        types.add(elem);
                    }
                    --i;
                }
                if (types.size() == 1) {
                    this.fSelectedType = (ICElement)types.get(0);
                    this.updateMethodViewer(this.fSelectedType);
                } else {
                    types.size();
                }
                if (nSelected == 1 && this.fSelectInEditor) {
                    this.revealElementInEditor(selected.get(0), (StructuredViewer)this.getCurrentViewer());
                }
            } else {
                this.fSelectedType = null;
                this.updateMethodViewer(null);
            }
        }
    }

    private void revealElementInEditor(Object elem, StructuredViewer originViewer) {
        if (this.getSite().getPage().getActivePart() != this) {
            return;
        }
        if (this.fSelectionProviderMediator.getViewerInFocus() != originViewer) {
            return;
        }
        IEditorPart editorPart = EditorUtility.isOpenInEditor(elem);
        if (editorPart != null && elem instanceof ICElement) {
            this.getSite().getPage().removePartListener(this.fPartListener);
            this.getSite().getPage().bringToTop((IWorkbenchPart)editorPart);
            EditorUtility.revealInEditor(editorPart, (ICElement)elem);
            this.getSite().getPage().addPartListener(this.fPartListener);
        }
    }

    private Display getDisplay() {
        if (this.fPagebook != null && !this.fPagebook.isDisposed()) {
            return this.fPagebook.getDisplay();
        }
        return null;
    }

    private boolean isChildVisible(Composite pb, Control child) {
        Control[] children = pb.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] == child && children[i].isVisible()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateTitle() {
        String tooltip;
        String title;
        TypeHierarchyViewer viewer = this.getCurrentViewer();
        String viewerTitle = viewer != null ? viewer.getTitle() : TypeHierarchyMessages.getString("TraditionalHierarchyViewer.title");
        if (this.fInputElement != null) {
            Object[] args = new String[]{viewerTitle, CElementLabels.getElementLabel(this.fInputElement, 1)};
            title = TypeHierarchyMessages.getFormattedString("TypeHierarchyViewPart.title", args);
            tooltip = TypeHierarchyMessages.getFormattedString("TypeHierarchyViewPart.tooltip", args);
        } else {
            title = viewerTitle;
            tooltip = viewerTitle;
        }
        this.setPartName(title);
        this.setContentDescription("");
        this.setTitleToolTip(tooltip);
    }

    private void updateToolbarButtons() {
        int i = 0;
        while (i < this.fViewActions.length) {
            ToggleViewAction action = this.fViewActions[i];
            action.setEnabled(true);
            ++i;
        }
    }

    public void setView(int viewerIndex) {
        Assert.isNotNull((Object)this.fAllViewers);
        if (viewerIndex < this.fAllViewers.length && this.fCurrentViewerIndex != viewerIndex) {
            this.fCurrentViewerIndex = viewerIndex;
            this.updateHierarchyViewer(true);
            if (this.fInputElement != null) {
                ISelection currSelection = this.getCurrentViewer().getSelection();
                if (currSelection == null || currSelection.isEmpty()) {
                    this.internalSelectType(this.getSelectableType(this.fInputElement), false);
                    currSelection = this.getCurrentViewer().getSelection();
                }
                if (!this.fIsEnableMemberFilter) {
                    this.typeSelectionChanged(currSelection);
                }
            }
            this.updateTitle();
            this.fDialogSettings.put(DIALOGSTORE_HIERARCHYVIEW, viewerIndex);
            this.getCurrentViewer().getTree().setFocus();
        }
        int i = 0;
        while (i < this.fViewActions.length) {
            ToggleViewAction action;
            action.setChecked(this.fCurrentViewerIndex == (action = this.fViewActions[i]).getViewerIndex());
            ++i;
        }
    }

    public int getViewIndex() {
        return this.fCurrentViewerIndex;
    }

    private TypeHierarchyViewer getCurrentViewer() {
        if (this.fCurrentViewerIndex != -1) {
            return this.fAllViewers[this.fCurrentViewerIndex];
        }
        return null;
    }

    public void enableMemberFilter(boolean on) {
        if (on != this.fIsEnableMemberFilter) {
            this.fIsEnableMemberFilter = on;
            if (!on) {
                ICElement methodViewerInput = (ICElement)this.fMethodsViewer.getInput();
                this.setMemberFilter(null);
                this.updateHierarchyViewer(true);
                this.updateTitle();
                if (methodViewerInput != null && this.getCurrentViewer().isElementShown(methodViewerInput)) {
                    this.internalSelectType(methodViewerInput, true);
                } else if (this.fSelectedType != null) {
                    this.internalSelectType(this.fSelectedType, true);
                    this.updateMethodViewer(this.fSelectedType);
                }
            } else {
                this.methodSelectionChanged(this.fMethodsViewer.getSelection());
            }
        }
        this.fEnableMemberFilterAction.setChecked(on);
    }

    public void showQualifiedTypeNames(boolean on) {
        if (this.fAllViewers == null) {
            return;
        }
        int i = 0;
        while (i < this.fAllViewers.length) {
            this.fAllViewers[i].setQualifiedTypeName(on);
            ++i;
        }
    }

    private boolean isShowQualifiedTypeNames() {
        return this.fShowQualifiedTypeNamesAction.isChecked();
    }

    protected void doTypeHierarchyChanged(TypeHierarchyLifeCycle typeHierarchy, final ICElement[] changedTypes) {
        if (!this.fIsVisible) {
            this.fNeedRefresh = true;
            return;
        }
        if (this.fIsRefreshRunnablePosted) {
            return;
        }
        Display display = this.getDisplay();
        if (display != null) {
            this.fIsRefreshRunnablePosted = true;
            display.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        if (TypeHierarchyViewPart.this.fPagebook != null && !TypeHierarchyViewPart.this.fPagebook.isDisposed()) {
                            TypeHierarchyViewPart.this.doTypeHierarchyChangedOnViewers(changedTypes);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var1_2 = null;
                        TypeHierarchyViewPart.this.fIsRefreshRunnablePosted = false;
                        throw throwable;
                    }
                    {
                        Object var1_3 = null;
                        TypeHierarchyViewPart.this.fIsRefreshRunnablePosted = false;
                        return;
                    }
                }
            });
        }
    }

    protected void doTypeHierarchyChangedOnViewers(ICElement[] changedTypes) {
        if (this.fHierarchyLifeCycle.getHierarchy() == null || !this.fHierarchyLifeCycle.getHierarchy().exists()) {
            this.clearInput();
        } else if (changedTypes == null) {
            try {
                this.fHierarchyLifeCycle.ensureRefreshedTypeHierarchy(this.fInputElement, (IRunnableContext)this.getSite().getWorkbenchWindow());
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getSite().getShell(), TypeHierarchyMessages.getString("TypeHierarchyViewPart.exception.title"), TypeHierarchyMessages.getString("TypeHierarchyViewPart.exception.message"));
                this.clearInput();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.fMethodsViewer.refresh();
            this.updateHierarchyViewer(false);
        } else {
            Object methodViewerInput = this.fMethodsViewer.getInput();
            this.fMethodsViewer.refresh();
            this.fMethodViewerPaneLabel.setText(this.fPaneLabelProvider.getText(methodViewerInput));
            this.fMethodViewerPaneLabel.setImage(this.fPaneLabelProvider.getImage(methodViewerInput));
            if (this.getCurrentViewer().isMethodFiltering()) {
                if (changedTypes.length == 1) {
                    this.getCurrentViewer().refresh(changedTypes[0]);
                } else {
                    this.updateHierarchyViewer(false);
                }
            } else {
                this.getCurrentViewer().update(changedTypes, new String[]{"org.eclipse.jface.text", "org.eclipse.jface.image"});
            }
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.fPagebook == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        memento.putInteger(TAG_VIEW, this.getViewIndex());
        memento.putInteger(TAG_ORIENTATION, this.fOrientation);
        int[] weigths = this.fTypeMethodsSplitter.getWeights();
        int ratio = weigths[0] * 1000 / (weigths[0] + weigths[1]);
        memento.putInteger(TAG_RATIO, ratio);
        ScrollBar bar = this.getCurrentViewer().getTree().getVerticalBar();
        int position = bar != null ? bar.getSelection() : 0;
        memento.putInteger(TAG_VERTICAL_SCROLL, position);
        this.fWorkingSetActionGroup.saveState(memento);
        this.fMethodsViewer.saveState(memento);
        this.saveLinkingEnabled(memento);
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger("org.eclipse.cdt.ui.packages.linktypehierarchytoeditor", this.fLinkingEnabled ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreState(final IMemento memento, ICElement defaultInput) {
        ICElement input = defaultInput;
        if (input == null) {
            this.doRestoreState(memento, input);
        } else {
            final ICElement hierarchyInput = input;
            TypeHierarchyViewPart typeHierarchyViewPart = this;
            synchronized (typeHierarchyViewPart) {
                String label = TypeHierarchyMessages.getFormattedString("TypeHierarchyViewPart.restoreinput", hierarchyInput.getElementName());
                this.fNoHierarchyShownLabel.setText(label);
                this.fRestoreStateJob = new Job(label){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            TypeHierarchyViewPart.this.doRestoreInBackground(memento, hierarchyInput, monitor);
                        }
                        catch (CModelException e) {
                            return e.getStatus();
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                this.fRestoreStateJob.schedule();
            }
        }
    }

    protected void doRestoreInBackground(final IMemento memento, final ICElement hierarchyInput, IProgressMonitor monitor) throws CModelException {
        this.fHierarchyLifeCycle.doHierarchyRefresh(hierarchyInput, monitor);
        if (!monitor.isCanceled()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (TypeHierarchyViewPart.this.fPagebook != null && !TypeHierarchyViewPart.this.fPagebook.isDisposed()) {
                        TypeHierarchyViewPart.this.doRestoreState(memento, hierarchyInput);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doRestoreState(IMemento memento, ICElement input) {
        Integer vScroll;
        ScrollBar bar;
        Integer orientation;
        TypeHierarchyViewPart typeHierarchyViewPart = this;
        synchronized (typeHierarchyViewPart) {
            if (this.fRestoreStateJob == null) {
                return;
            }
            this.fRestoreStateJob = null;
        }
        this.fWorkingSetActionGroup.restoreState(memento);
        this.setInputElement(input);
        Integer viewerIndex = memento.getInteger(TAG_VIEW);
        if (viewerIndex != null) {
            this.setView(viewerIndex);
        }
        if ((orientation = memento.getInteger(TAG_ORIENTATION)) != null) {
            this.fOrientation = orientation;
        }
        this.computeOrientation();
        this.updateCheckedState();
        Integer ratio = memento.getInteger(TAG_RATIO);
        if (ratio != null) {
            this.fTypeMethodsSplitter.setWeights(new int[]{ratio, 1000 - ratio});
        }
        if ((bar = this.getCurrentViewer().getTree().getVerticalBar()) != null && (vScroll = memento.getInteger(TAG_VERTICAL_SCROLL)) != null) {
            bar.setSelection(vScroll.intValue());
        }
        this.fMethodsViewer.restoreState(memento);
    }

    private void restoreLinkingEnabled(IMemento memento) {
        Integer val = memento.getInteger("org.eclipse.cdt.ui.packages.linktypehierarchytoeditor");
        if (val != null) {
            this.fLinkingEnabled = val != 0;
        }
    }

    protected void visibilityChanged(boolean isVisible) {
        this.fIsVisible = isVisible;
        if (isVisible && this.fNeedRefresh) {
            this.doTypeHierarchyChangedOnViewers(null);
        }
        this.fNeedRefresh = false;
    }

    protected void editorActivated(IEditorPart editor) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        if (this.fInputElement == null) {
            return;
        }
        IEditorInput iEditorInput = editor.getEditorInput();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICElement elem = (ICElement)iEditorInput.getAdapter((Class)clazz);
        TypeHierarchyViewer currentViewer = this.getCurrentViewer();
        if (elem instanceof ITranslationUnit) {
            try {
                ICElement[] allTypes = TypeUtil.getAllTypes((ITranslationUnit)((ITranslationUnit)elem));
                int i = 0;
                while (i < allTypes.length) {
                    if (currentViewer.isElementShown(allTypes[i])) {
                        this.internalSelectType(allTypes[i], true);
                        this.updateMethodViewer(allTypes[i]);
                        return;
                    }
                    ++i;
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    public Object getViewPartInput() {
        return this.fInputElement;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, TypeHierarchyViewPart.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    public void setLinkingEnabled(boolean enabled) {
        IEditorPart editor;
        this.fLinkingEnabled = enabled;
        PreferenceConstants.getPreferenceStore().setValue("org.eclipse.cdt.ui.packages.linktypehierarchytoeditor", enabled);
        if (enabled && (editor = this.getSite().getPage().getActiveEditor()) != null) {
            this.editorActivated(editor);
        }
    }

    public void clearNeededRefresh() {
        this.fNeedRefresh = false;
    }
}

