/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.internal.ui.editor.ExternalSearchAnnotationModel;
import org.eclipse.cdt.internal.ui.editor.ExternalSearchFile;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class ExternalSearchDocumentProvider
extends FileDocumentProvider {
    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (element instanceof ExternalEditorInput) {
            ExternalEditorInput externalInput = (ExternalEditorInput)element;
            IDocument d = this.createDocument(externalInput);
            IAnnotationModel m = this.createExternalSearchAnnotationModel(externalInput);
            FileDocumentProvider.FileInfo info = new FileDocumentProvider.FileInfo((FileDocumentProvider)this, d, m, null);
            return info;
        }
        return null;
    }

    private IAnnotationModel createExternalSearchAnnotationModel(ExternalEditorInput externalInput) {
        IStorage storage = externalInput.getStorage();
        ExternalSearchFile externalSearchFile = null;
        if (storage instanceof ExternalSearchFile) {
            externalSearchFile = (ExternalSearchFile)storage;
        }
        if (externalSearchFile == null) {
            return null;
        }
        IProject projectToUseForMarker = null;
        IFile resourceFile = CUIPlugin.getWorkspace().getRoot().getFileForLocation(externalSearchFile.searchMatch.getReferringElement());
        if (resourceFile == null) {
            IProject[] proj = CUIPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < proj.length) {
                if (proj[i].isOpen()) {
                    projectToUseForMarker = proj[i];
                    break;
                }
                ++i;
            }
        } else {
            projectToUseForMarker = resourceFile.getProject();
        }
        if (projectToUseForMarker != null) {
            ExternalSearchAnnotationModel model = new ExternalSearchAnnotationModel((IResource)projectToUseForMarker);
            return model;
        }
        return null;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            CTextTools textTools = CUIPlugin.getDefault().getTextTools();
            textTools.setupCDocument(document);
        }
        return document;
    }
}

