/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import org.eclipse.cdt.managedbuilder.core.IInputOrder;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InputOrder
implements IInputOrder {
    private static final String EMPTY_STRING = new String();
    private IInputType parent;
    private String path;
    private String order;
    private Boolean excluded;
    private boolean isExtensionInputOrder = false;
    private boolean isDirty = false;
    private boolean resolved = true;

    public InputOrder(IInputType parent, IManagedConfigElement element) {
        this.parent = parent;
        this.isExtensionInputOrder = true;
        this.resolved = false;
        this.loadFromManifest(element);
    }

    public InputOrder(InputType parent, boolean isExtensionElement) {
        this.parent = parent;
        this.isExtensionInputOrder = isExtensionElement;
        if (!isExtensionElement) {
            this.setDirty(true);
        }
    }

    public InputOrder(IInputType parent, Element element) {
        this.parent = parent;
        this.isExtensionInputOrder = false;
        this.loadFromProject(element);
    }

    public InputOrder(IInputType parent, InputOrder inputOrder) {
        this.parent = parent;
        this.isExtensionInputOrder = false;
        if (inputOrder.path != null) {
            this.path = new String(inputOrder.path);
        }
        if (inputOrder.order != null) {
            this.order = new String(inputOrder.order);
        }
        if (inputOrder.excluded != null) {
            this.excluded = new Boolean(inputOrder.excluded);
        }
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        this.path = element.getAttribute("path");
        this.order = element.getAttribute("order");
        String isEx = element.getAttribute("excluded");
        if (isEx != null) {
            this.excluded = new Boolean("true".equals(isEx));
        }
    }

    protected void loadFromProject(Element element) {
        String isEx;
        if (element.hasAttribute("path")) {
            this.path = element.getAttribute("path");
        }
        if (element.hasAttribute("order")) {
            this.order = element.getAttribute("order");
        }
        if (element.hasAttribute("excluded") && (isEx = element.getAttribute("excluded")) != null) {
            this.excluded = new Boolean("true".equals(isEx));
        }
    }

    public void serialize(Document doc, Element element) {
        if (this.path != null) {
            element.setAttribute("path", this.path);
        }
        if (this.order != null) {
            element.setAttribute("order", this.order);
        }
        if (this.excluded != null) {
            element.setAttribute("excluded", this.excluded.toString());
        }
        this.isDirty = false;
    }

    public IInputType getParent() {
        return this.parent;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String newPath) {
        if (this.path == null && newPath == null) {
            return;
        }
        if (this.path == null || newPath == null || !this.path.equals(newPath)) {
            this.path = newPath;
            this.isDirty = true;
        }
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String newOrder) {
        if (this.order == null && newOrder == null) {
            return;
        }
        if (this.order == null || newOrder == null || !this.order.equals(newOrder)) {
            this.order = newOrder;
            this.isDirty = true;
        }
    }

    public boolean getExcluded() {
        return this.excluded;
    }

    public void setExcluded(boolean b) {
        if (this.excluded == null || b != this.excluded) {
            this.excluded = new Boolean(b);
            this.setDirty(true);
        }
    }

    public boolean isExtensionElement() {
        return this.isExtensionInputOrder;
    }

    public boolean isDirty() {
        if (this.isExtensionInputOrder) {
            return false;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
        }
    }
}

