/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.cindexstorage;

import org.eclipse.cdt.internal.core.index.IFunctionEntry;
import org.eclipse.cdt.internal.core.index.IIndexEntry;
import org.eclipse.cdt.internal.core.index.IIndexerOutput;
import org.eclipse.cdt.internal.core.index.INamedEntry;
import org.eclipse.cdt.internal.core.index.ITypeEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.ICIndexStorageConstants;
import org.eclipse.cdt.internal.core.index.cindexstorage.InMemoryIndex;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexEntryNotSupportedException;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.domsourceindexer.AbstractIndexerRunner;

public class IndexerOutput
implements ICIndexStorageConstants,
IIndexerOutput {
    public static int entryCount = 0;
    protected InMemoryIndex index;

    public IndexerOutput(InMemoryIndex index) {
        this.index = index;
    }

    protected void addRef(int indexedFileNumber, char[][] name, char suffix, int type, int offset, int offsetLength, int offsetType, int modifiers) {
        if (indexedFileNumber == 0) {
            throw new IllegalStateException();
        }
        if (offsetLength <= 0) {
            offsetLength = 1;
        }
        if (modifiers <= 0) {
            modifiers = 1;
        }
        ++entryCount;
        this.index.addRef(IndexerOutput.encodeTypeEntry(name, suffix, type), indexedFileNumber, offset, offsetLength, offsetType, modifiers);
    }

    protected void addRef(int indexedFileNumber, char[][] name, int meta_kind, int ref, int offset, int offsetLength, int offsetType, int modifiers) {
        if (indexedFileNumber == 0) {
            throw new IllegalStateException();
        }
        if (offsetLength <= 0) {
            offsetLength = 1;
        }
        if (modifiers <= 0) {
            modifiers = 1;
        }
        ++entryCount;
        this.index.addRef(IndexerOutput.encodeEntry(name, meta_kind, ref), indexedFileNumber, offset, offsetLength, offsetType, modifiers);
    }

    public void addRelatives(int indexedFileNumber, String inclusion, String parent) {
        if (indexedFileNumber == 0) {
            throw new IllegalStateException();
        }
        this.index.addRelatives(indexedFileNumber, inclusion, parent);
    }

    public void addIncludeRef(int indexedFileNumber, char[] word) {
        if (indexedFileNumber == 0) {
            throw new IllegalStateException();
        }
        this.index.addIncludeRef(word, indexedFileNumber);
    }

    public void addIncludeRef(int indexedFileNumber, String word) {
        this.addIncludeRef(indexedFileNumber, word.toCharArray());
    }

    public IndexedFileEntry getIndexedFile(String path) {
        return this.index.getIndexedFile(path);
    }

    public IndexedFileEntry addIndexedFile(String path) {
        return this.index.addFile(path);
    }

    public void addIncludeRef(int indexedFileNumber, char[][] name, int offset, int offsetLength, int offsetType) {
        this.addRef(indexedFileNumber, name, 8, 2, offset, offsetLength, offsetType, 1);
    }

    protected static final char[] encodeTypeEntry(char[][] fullTypeName, char suffix, int type) {
        int pos = 0;
        int nameLength = 0;
        int i = 0;
        while (i < fullTypeName.length) {
            char[] namePart = fullTypeName[i];
            nameLength += namePart.length;
            ++i;
        }
        char[] result = null;
        char[] declchar = ICIndexStorageConstants.encodingTypes[type];
        char[] typechar = ICIndexStorageConstants.encodings[1];
        result = new char[typechar.length + declchar.length + nameLength + fullTypeName.length + 1];
        System.arraycopy(typechar, 0, result, 0, typechar.length);
        System.arraycopy(declchar, 0, result, typechar.length, declchar.length);
        pos = typechar.length + declchar.length;
        result[pos++] = suffix;
        result[pos++] = 47;
        if (fullTypeName.length > 0) {
            char[] tempName = fullTypeName[fullTypeName.length - 1];
            System.arraycopy(tempName, 0, result, pos, tempName.length);
            pos += tempName.length;
        }
        int i2 = fullTypeName.length - 2;
        while (i2 >= 0) {
            result[pos++] = 47;
            char[] tempName = fullTypeName[i2];
            System.arraycopy(tempName, 0, result, pos, tempName.length);
            pos += tempName.length;
            --i2;
        }
        if (AbstractIndexerRunner.VERBOSE) {
            AbstractIndexerRunner.verbose(new String(result));
        }
        return result;
    }

    protected static final char[] encodeEntry(char[][] elementName, int meta_kind, int ref) {
        int nameLength = 0;
        int i = 0;
        while (i < elementName.length) {
            char[] namePart = elementName[i];
            nameLength += namePart.length;
            ++i;
        }
        int pos = ICIndexStorageConstants.encodings[meta_kind].length + ICIndexStorageConstants.encodingTypes[ref].length;
        char[] result = new char[pos + nameLength + elementName.length - 1];
        System.arraycopy(ICIndexStorageConstants.encodings[meta_kind], 0, result, 0, ICIndexStorageConstants.encodings[meta_kind].length);
        System.arraycopy(ICIndexStorageConstants.encodingTypes[ref], 0, result, ICIndexStorageConstants.encodings[meta_kind].length, ICIndexStorageConstants.encodingTypes[ref].length);
        if (elementName.length > 0) {
            char[] tempName = elementName[elementName.length - 1];
            System.arraycopy(tempName, 0, result, pos, tempName.length);
            pos += tempName.length;
        }
        int i2 = elementName.length - 2;
        while (i2 >= 0) {
            result[pos++] = 47;
            char[] tempName = elementName[i2];
            System.arraycopy(tempName, 0, result, pos, tempName.length);
            pos += tempName.length;
            --i2;
        }
        if (AbstractIndexerRunner.VERBOSE) {
            AbstractIndexerRunner.verbose(new String(result));
        }
        return result;
    }

    public void addIndexEntry(IIndexEntry indexEntry) throws IndexEntryNotSupportedException {
        if (indexEntry == null) {
            return;
        }
        throw new IndexEntryNotSupportedException("Index Entry type not supported - need to add handler");
    }

    public void addIndexEntry(ITypeEntry typeEntry) {
        int indexedFileNumber = typeEntry.getFileNumber();
        typeEntry.getMetaKind();
        int type_kind = typeEntry.getTypeKind();
        int entryType = typeEntry.getEntryType();
        int modifiers = typeEntry.getModifiers();
        char[][] name = typeEntry.getFullName();
        int nameOffset = typeEntry.getNameOffset();
        int nameOffsetLength = typeEntry.getNameLength();
        int nameOffsetType = typeEntry.getNameOffsetType();
        typeEntry.getElementOffset();
        typeEntry.getElementLength();
        typeEntry.getElementOffsetType();
        if (modifiers <= 0) {
            modifiers = 1;
        }
        this.addRef(indexedFileNumber, name, ICIndexStorageConstants.typeConstants[type_kind], entryType, nameOffset, nameOffsetLength, nameOffsetType, modifiers);
        IIndexEntry[] baseClasses = typeEntry.getBaseTypes();
        if (baseClasses != null && baseClasses.length > 0) {
            int i = 0;
            while (i < baseClasses.length) {
                char[][] baseName = ((INamedEntry)baseClasses[i]).getFullName();
                this.addRef(indexedFileNumber, baseName, ICIndexStorageConstants.typeConstants[6], 1, nameOffset, nameOffsetLength, nameOffsetType, 1);
                ++i;
            }
        }
    }

    public void addIndexEntry(INamedEntry nameEntry) {
        int indexedFileNumber = nameEntry.getFileNumber();
        int meta_type = nameEntry.getMetaKind();
        int entryType = nameEntry.getEntryType();
        int modifiers = nameEntry.getModifiers();
        char[][] name = nameEntry.getFullName();
        int nameOffset = nameEntry.getNameOffset();
        int nameOffsetLength = nameEntry.getNameLength();
        int nameOffsetType = nameEntry.getNameOffsetType();
        nameEntry.getElementOffset();
        nameEntry.getElementLength();
        nameEntry.getElementOffsetType();
        if (modifiers <= 0) {
            modifiers = 1;
        }
        this.addRef(indexedFileNumber, name, meta_type, entryType, nameOffset, nameOffsetLength, nameOffsetType, modifiers);
    }

    public void addIndexEntry(IFunctionEntry functionEntry) {
        Object tempParm2;
        char[][] endParm;
        Object tempParm;
        char[][] startParm;
        int indexedFileNumber = functionEntry.getFileNumber();
        int meta_type = functionEntry.getMetaKind();
        int entryType = functionEntry.getEntryType();
        int modifiers = functionEntry.getModifiers();
        char[][] sig = functionEntry.getSignature();
        char[][] name = functionEntry.getFullName();
        char[] returnName = functionEntry.getReturnType();
        int sigL = 0;
        int nameL = 0;
        int returnNameL = 0;
        int totalSize = 0;
        if (sig != null) {
            sigL = sig.length;
            totalSize += sigL + 2;
        }
        if (name != null) {
            nameL = name.length;
            totalSize += nameL;
        }
        if (returnName != null) {
            returnNameL = 1;
            totalSize += returnNameL + 2;
        }
        char[][] finalName = new char[totalSize][];
        int positionCounter = 0;
        if (sig != null) {
            startParm = new char[1][];
            tempParm = new char[]{'('};
            startParm[0] = (char[])tempParm;
            endParm = new char[1][];
            tempParm2 = new char[]{')'};
            endParm[0] = (char[])tempParm2;
            System.arraycopy(startParm, 0, finalName, positionCounter, 1);
            System.arraycopy(sig, 0, finalName, ++positionCounter, sigL);
            System.arraycopy(endParm, 0, finalName, positionCounter += sigL, 1);
            ++positionCounter;
        }
        if (returnName != null) {
            startParm = new char[1][];
            tempParm = "R(";
            startParm[0] = ((String)tempParm).toCharArray();
            endParm = new char[1][];
            tempParm2 = ")R";
            endParm[0] = ((String)tempParm2).toCharArray();
            char[][] tempReturn = new char[][]{returnName};
            System.arraycopy(startParm, 0, finalName, positionCounter, 1);
            System.arraycopy(tempReturn, 0, finalName, ++positionCounter, returnNameL);
            System.arraycopy(endParm, 0, finalName, positionCounter += returnNameL, 1);
            ++positionCounter;
        }
        if (name != null) {
            System.arraycopy(name, 0, finalName, positionCounter, nameL);
        }
        int nameOffset = functionEntry.getNameOffset();
        int nameOffsetLength = functionEntry.getNameLength();
        int nameOffsetType = functionEntry.getNameOffsetType();
        if (modifiers <= 0) {
            modifiers = 1;
        }
        this.addRef(indexedFileNumber, finalName, meta_type, entryType, nameOffset, nameOffsetLength, nameOffsetType, modifiers);
    }
}

