/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.domsourceindexer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.index.ICDTIndexer;
import org.eclipse.cdt.core.index.IIndexChangeListener;
import org.eclipse.cdt.core.index.IIndexStorage;
import org.eclipse.cdt.core.index.IndexChangeEvent;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.cindexstorage.CIndexStorage;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMAddCompilationUnitToIndex;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMAddFolderToIndex;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMIndexAllProject;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMRemoveFolderFromIndex;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMRemoveFromIndex;
import org.eclipse.cdt.internal.core.index.impl.IndexDelta;
import org.eclipse.cdt.internal.core.search.SimpleLookupTable;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.IIndexJob;
import org.eclipse.cdt.internal.core.sourcedependency.UpdateDependency;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DOMSourceIndexer
extends AbstractCExtension
implements ICDTIndexer {
    public static boolean VERBOSE = false;
    protected List indexChangeListeners = Collections.synchronizedList(new ArrayList());
    public static final String INDEX_NOTIFICATION_NAME = Util.bind("indexNotificationJob");
    public static final String INDEX_MODEL_ID = "org.eclipse.cdt.core.newindexmodel";
    public static final String ACTIVATION = "enable";
    public static final String PROBLEM_ACTIVATION = "problemEnable";
    public static final QualifiedName activationKey = new QualifiedName("org.eclipse.cdt.core.newindexmodel", "enable");
    public static final QualifiedName problemsActivationKey = new QualifiedName("org.eclipse.cdt.core.newindexmodel", "problemEnable");
    public static final int PREPROCESSOR_PROBLEMS_BIT = 1;
    public static final int SEMANTIC_PROBLEMS_BIT = 2;
    public static final int SYNTACTIC_PROBLEMS_BIT = 4;
    public static final int INCLUSION_PROBLEMS_BIT = 8;
    public static final String SOURCE_INDEXER_ID = "originalsourceindexer";
    public static final String SOURCE_INDEXER_UNIQUE_ID = "org.eclipse.cdt.core.originalsourceindexer";
    private CIndexStorage indexStorage = null;
    protected ReadWriteMonitor storageMonitor = null;
    protected IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
    protected HashSet jobSet = null;
    protected long totalIndexTime = 0L;
    public static String ID = "org.eclipse.cdt.core.domsourceindexer";
    public static int trimed = 0;
    public static int added = 0;

    public DOMSourceIndexer() {
        this.indexStorage = (CIndexStorage)this.indexManager.getIndexStorageForIndexer(this);
        this.jobSet = new HashSet();
        this.storageMonitor = new ReadWriteMonitor();
    }

    public IIndexStorage getIndexStorage() {
        return this.indexStorage;
    }

    public void addSource(IFile resource, IPath indexedContainers) {
        this.addSource(resource, indexedContainers, false);
    }

    public void addSource(IFile resource, IPath indexedContainers, boolean checkEncounteredHeaders) {
        IProject project = resource.getProject();
        boolean indexEnabled = false;
        if (project != null) {
            indexEnabled = this.isIndexEnabled(project);
        } else {
            org.eclipse.cdt.internal.core.model.Util.log(null, "IndexManager addSource: File has no project associated : " + resource.getName(), ICLogConstants.CDT);
        }
        if (CCorePlugin.getDefault() == null) {
            return;
        }
        if (indexEnabled) {
            DOMAddCompilationUnitToIndex job = new DOMAddCompilationUnitToIndex(resource, indexedContainers, this, checkEncounteredHeaders);
            if (!this.jobSet.add(resource.getLocation()) && this.indexManager.enabledState() == 1) {
                return;
            }
            if (this.indexManager.awaitingJobsCount() < CIndexStorage.MAX_FILES_IN_MEMORY && !job.initializeContents()) {
                return;
            }
            this.indexManager.request(job);
        }
    }

    public void updateDependencies(IResource resource) {
        if (CCorePlugin.getDefault() == null || !this.isIndexEnabled(resource.getProject())) {
            return;
        }
        UpdateDependency job = new UpdateDependency(resource, this);
        this.indexManager.request(job);
    }

    public synchronized boolean haveEncounteredHeader(IPath projectPath, IPath filePath, boolean add) {
        SimpleLookupTable headerTable = this.indexStorage.getEncounteredHeaders();
        ObjectSet headers = (ObjectSet)headerTable.get(projectPath);
        if (headers == null) {
            headers = new ObjectSet(4);
            headerTable.put(projectPath, headers);
        }
        if (headers.containsKey((Object)filePath.toOSString())) {
            ++trimed;
            return true;
        }
        if (add) {
            headers.put((Object)filePath.toOSString());
            ++added;
        }
        return false;
    }

    public void indexAll(IProject project) {
        if (CCorePlugin.getDefault() == null) {
            return;
        }
        boolean indexEnabled = this.isIndexEnabled(project);
        if (indexEnabled) {
            if (this.indexManager.enabledState() == 2) {
                this.indexManager.enable();
            }
            DOMIndexAllProject request = new DOMIndexAllProject(project, this);
            int i = this.indexManager.getJobEnd();
            while (i > this.indexManager.getJobStart()) {
                if (((Object)request).equals(this.indexManager.getAwaitingJobAt(i))) {
                    return;
                }
                --i;
            }
            this.indexManager.request(request);
        }
    }

    public boolean isIndexEnabled(IProject project) {
        return project != null && project.exists() && project.isOpen();
    }

    public int indexProblemsEnabled(IProject project) {
        if (project == null || !project.exists() || !project.isOpen()) {
            return 0;
        }
        int indexProblemsEnabled = 0;
        try {
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(project, false);
            if (cdesc == null) {
                return 0;
            }
            ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.CIndexer");
            if (cext.length > 0) {
                int i = 0;
                while (i < cext.length) {
                    String orig = cext[i].getExtensionData("indexmarkers");
                    if (orig != null) {
                        Integer tempInt = new Integer(orig);
                        indexProblemsEnabled = tempInt;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return indexProblemsEnabled;
    }

    public void indexSourceFolder(IProject project, IPath sourceFolder, char[][] exclusionPattern) {
        if (!this.isIndexEnabled(project)) {
            return;
        }
        if (this.indexManager.getJobEnd() > this.indexManager.getJobStart()) {
            DOMIndexAllProject request = new DOMIndexAllProject(project, this);
            int i = this.indexManager.getJobEnd();
            while (i > this.indexManager.getJobStart()) {
                if (((Object)request).equals(this.indexManager.getAwaitingJobAt(i))) {
                    return;
                }
                --i;
            }
        }
        this.request(new DOMAddFolderToIndex(sourceFolder, project, exclusionPattern, this));
    }

    public void remove(String resourceName, IPath indexedContainer) {
        IProject project = CCorePlugin.getWorkspace().getRoot().getProject(indexedContainer.toString());
        if (this.isIndexEnabled(project)) {
            this.request(new DOMRemoveFromIndex(resourceName, indexedContainer, this));
        }
    }

    public void removeSourceFolderFromIndex(IProject project, IPath sourceFolder, char[][] exclusionPatterns) {
        if (!this.isIndexEnabled(project)) {
            return;
        }
        if (this.indexManager.getJobEnd() > this.indexManager.getJobStart()) {
            DOMIndexAllProject request = new DOMIndexAllProject(project, this);
            int i = this.indexManager.getJobEnd();
            while (i > this.indexManager.getJobStart()) {
                if (((Object)request).equals(this.indexManager.getAwaitingJobAt(i))) {
                    return;
                }
                --i;
            }
        }
        this.request(new DOMRemoveFolderFromIndex(sourceFolder, exclusionPatterns, project, this));
    }

    public void jobFinishedNotification(IIndexJob job) {
        this.indexJobFinishedNotification(job);
    }

    public void removeIndexerProblems(IResource resource) {
        this.indexManager.removeIndexerProblems(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexChangeListener(IIndexChangeListener listener) {
        List list = this.indexChangeListeners;
        synchronized (list) {
            if (!this.indexChangeListeners.contains(listener)) {
                this.indexChangeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndexChangeListener(IIndexChangeListener listener) {
        List list = this.indexChangeListeners;
        synchronized (list) {
            int i = this.indexChangeListeners.indexOf(listener);
            if (i != -1) {
                this.indexChangeListeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(IndexDelta indexDelta) {
        final IndexChangeEvent indexEvent = new IndexChangeEvent(indexDelta);
        int i = 0;
        while (i < this.indexChangeListeners.size()) {
            IIndexChangeListener tempListener = null;
            List list = this.indexChangeListeners;
            synchronized (list) {
                tempListener = (IIndexChangeListener)this.indexChangeListeners.get(i);
            }
            final IIndexChangeListener listener = tempListener;
            long start = -1L;
            if (VERBOSE) {
                System.out.print("Listener #" + (i + 1) + "=" + listener.toString());
                start = System.currentTimeMillis();
            }
            Job job = new Job(INDEX_NOTIFICATION_NAME){

                protected IStatus run(IProgressMonitor monitor) {
                    Platform.run((ISafeRunnable)new ISafeRunnable(this, listener, indexEvent){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IIndexChangeListener val$listener;
                        private final /* synthetic */ IndexChangeEvent val$indexEvent;
                        {
                            this.this$1 = var1_1;
                            this.val$listener = iIndexChangeListener;
                            this.val$indexEvent = indexChangeEvent;
                        }

                        public void handleException(Throwable exception) {
                            CCorePlugin.log(exception);
                        }

                        public void run() throws Exception {
                            this.val$listener.indexChanged(this.val$indexEvent);
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            if (VERBOSE) {
                System.out.println(" -> " + (System.currentTimeMillis() - start) + "ms");
            }
            ++i;
        }
    }

    public void notifyIdle(long idlingTime) {
        if (idlingTime > 1000L && this.indexStorage.getNeedToSave()) {
            this.indexStorage.saveIndexes();
        }
    }

    public int getIndexerFeatures() {
        return 119;
    }

    public void addRequest(IProject project, IResourceDelta delta, int kind) {
        switch (kind) {
            case 1: {
                this.indexAll(project);
                break;
            }
            case 2: {
                this.indexSourceFolder(project, delta.getFullPath(), null);
                break;
            }
            case 4: {
                boolean shouldAddFile = false;
                IFile file = (IFile)delta.getResource();
                if (delta.getKind() == 4) {
                    if (CoreModel.isValidSourceUnitName(project, file.getName())) {
                        shouldAddFile = true;
                    }
                } else {
                    shouldAddFile = true;
                }
                if (!shouldAddFile) break;
                this.addSource(file, project.getFullPath());
            }
        }
    }

    public void removeRequest(IProject project, IResourceDelta delta, int kind) {
        switch (kind) {
            case 1: {
                IPath fullPath = project.getFullPath();
                if (delta.getKind() == 4) {
                    this.indexManager.discardJobs(fullPath.segment(0));
                }
                this.indexStorage.removeIndexFamily(fullPath);
                break;
            }
            case 2: {
                this.removeSourceFolderFromIndex(project, delta.getFullPath(), null);
                break;
            }
            case 4: {
                IFile file = (IFile)delta.getResource();
                this.remove(file.getFullPath().toString(), file.getProject().getFullPath());
            }
        }
    }

    public void indexJobFinishedNotification(IIndexJob job) {
        this.indexStorage.setNeedToSave(true);
        if (job instanceof DOMAddCompilationUnitToIndex) {
            DOMAddCompilationUnitToIndex tempJob = (DOMAddCompilationUnitToIndex)job;
            this.jobSet.remove(tempJob.getResource().getLocation());
        }
    }

    public void shutdown() {
        this.indexStorage.shutdown();
    }

    public void request(IIndexJob indexJob) {
        this.indexManager.request(indexJob);
    }

    public ReadWriteMonitor getStorageMonitor() {
        return this.storageMonitor;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetEncounteredHeaders() {
        try {
            this.storageMonitor.enterWrite();
            this.indexStorage.resetEncounteredHeaders();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.storageMonitor.exitWrite();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.storageMonitor.exitWrite();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized IIndex getIndex(IPath path, boolean reuseExistingFile, boolean createIfMissing) {
        IIndex index = null;
        try {
            this.storageMonitor.enterRead();
            index = this.indexStorage.getIndex(path, reuseExistingFile, createIfMissing);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.storageMonitor.exitRead();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.storageMonitor.exitRead();
            return index;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReadWriteMonitor getMonitorFor(IIndex index) {
        ReadWriteMonitor monitor = null;
        try {
            this.storageMonitor.enterRead();
            monitor = this.indexStorage.getMonitorForIndex();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.storageMonitor.exitRead();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.storageMonitor.exitRead();
            return monitor;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeIndex(IPath path) {
        try {
            this.storageMonitor.enterWrite();
            this.indexStorage.removeIndex(path);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.storageMonitor.exitWrite();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.storageMonitor.exitWrite();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void jobWasCancelled(IPath path) {
        try {
            this.storageMonitor.enterWrite();
            this.indexStorage.jobWasCancelled(path);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.storageMonitor.exitWrite();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.storageMonitor.exitWrite();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveIndex(IIndex index) throws IOException {
        try {
            this.storageMonitor.enterWrite();
            this.indexStorage.saveIndex(index);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.storageMonitor.exitWrite();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.storageMonitor.exitWrite();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void aboutToUpdateIndex(IPath indexPath, Integer indexState) {
        this.storageMonitor.enterRead();
        try {
            this.indexStorage.aboutToUpdateIndex(indexPath, indexState);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.storageMonitor.exitRead();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.storageMonitor.exitRead();
            return;
        }
    }

    public long getTotalIndexTime() {
        return this.totalIndexTime;
    }

    public void setTotalIndexTime(long totalIndexTime) {
        this.totalIndexTime = totalIndexTime;
    }

    public void notifyIndexerChange(IProject project) {
        this.indexAll(project);
    }

    public void indexerRemoved(IProject project) {
        this.removeIndexerProblems((IResource)project);
    }

    public void addResource(IProject project, IResource resource) {
        if (resource instanceof IProject) {
            this.indexAll(project);
        } else if (resource instanceof IFolder) {
            this.indexSourceFolder(project, resource.getFullPath(), null);
        } else if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            this.addSource(file, project.getFullPath());
        }
    }

    public void removeResource(IProject project, IResource resource) {
    }

    public void addResourceByPath(IProject project, IPath path, int resourceType) {
    }

    public void setIndexerProject(IProject project) {
        this.setProject(project);
    }
}

