/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.DialogSettingsHelper;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.MultipleInputDialog;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.spawner.EnvironmentReader;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class MakeEnvironmentBlock
extends AbstractCOptionPage {
    Preferences fPrefs;
    String fBuilderID;
    IMakeCommonBuildInfo fBuildInfo;
    protected TableViewer environmentTable;
    protected String[] envTableColumnHeaders = new String[]{MakeUIPlugin.getResourceString("MakeEnvironmentBlock.0"), MakeUIPlugin.getResourceString("MakeEnvironmentBlock.1")};
    protected ColumnLayoutData[] envTableColumnLayouts = new ColumnLayoutData[]{new ColumnPixelData(150), new ColumnPixelData(250)};
    private static final String NAME_LABEL = MakeUIPlugin.getResourceString("MakeEnvironmentBlock.2");
    private static final String VALUE_LABEL = MakeUIPlugin.getResourceString("MakeEnvironmentBlock.3");
    protected static final String P_VARIABLE = "variable";
    protected static final String P_VALUE = "value";
    protected static String[] envTableColumnProperties = new String[]{"variable", "value"};
    protected Button envAddButton;
    protected Button envEditButton;
    protected Button envRemoveButton;
    protected Button appendEnvironment;
    protected Button replaceEnvironment;
    protected Button envSelectButton;

    public MakeEnvironmentBlock(Preferences prefs, String builderID) {
        super(MakeUIPlugin.getResourceString("MakeEnvironmentBlock.4"));
        this.setDescription(MakeUIPlugin.getResourceString("MakeEnvironmentBlock.5"));
        this.fPrefs = prefs;
        this.fBuilderID = builderID;
    }

    public void setContainer(ICOptionContainer container) {
        super.setContainer(container);
        if (this.getContainer().getProject() != null) {
            try {
                this.fBuildInfo = MakeCorePlugin.createBuildInfo((IProject)this.getContainer().getProject(), (String)this.fBuilderID);
            }
            catch (CoreException coreException) {}
        } else {
            this.fBuildInfo = MakeCorePlugin.createBuildInfo((Preferences)this.fPrefs, (String)this.fBuilderID, (boolean)false);
        }
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (this.fBuildInfo == null) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IWorkspace workspace = MakeUIPlugin.getWorkspace();
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(MakeUIPlugin.getResourceString("SettingsBlock.monitor.applyingSettings"), 1);
                IMakeBuilderInfo info = null;
                if (MakeEnvironmentBlock.this.getContainer().getProject() != null) {
                    try {
                        info = MakeCorePlugin.createBuildInfo((IProject)MakeEnvironmentBlock.this.getContainer().getProject(), (String)MakeEnvironmentBlock.this.fBuilderID);
                    }
                    catch (CoreException e) {
                        MakeCorePlugin.log((Throwable)e);
                        return;
                    }
                } else {
                    info = MakeCorePlugin.createBuildInfo((Preferences)MakeEnvironmentBlock.this.fPrefs, (String)MakeEnvironmentBlock.this.fBuilderID, (boolean)false);
                }
                TableItem[] items = MakeEnvironmentBlock.this.environmentTable.getTable().getItems();
                HashMap<String, String> map = new HashMap<String, String>(items.length);
                int i = 0;
                while (i < items.length) {
                    EnvironmentVariable var = (EnvironmentVariable)items[i].getData();
                    map.put(var.getName(), var.getValue());
                    ++i;
                }
                info.setEnvironment(map);
                info.setAppendEnvironment(MakeEnvironmentBlock.this.appendEnvironment.getSelection());
            }
        };
        if (this.getContainer().getProject() != null) {
            workspace.run(operation, monitor);
        } else {
            operation.run(monitor);
        }
    }

    protected void updateEnvironment(IMakeCommonBuildInfo info) {
        this.environmentTable.setInput((Object)info);
    }

    public void performDefaults() {
        if (this.fBuildInfo == null) {
            return;
        }
        IMakeBuilderInfo info = this.getContainer().getProject() != null ? MakeCorePlugin.createBuildInfo((Preferences)this.fPrefs, (String)this.fBuilderID, (boolean)false) : MakeCorePlugin.createBuildInfo((Preferences)this.fPrefs, (String)this.fBuilderID, (boolean)true);
        boolean append = info.appendEnvironment();
        if (append) {
            this.appendEnvironment.setSelection(true);
            this.replaceEnvironment.setSelection(false);
        } else {
            this.replaceEnvironment.setSelection(true);
            this.appendEnvironment.setSelection(false);
        }
        this.updateEnvironment((IMakeCommonBuildInfo)info);
        this.updateAppendReplace();
    }

    public void createControl(Composite parent) {
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)1);
        this.setControl((Control)composite);
        MakeUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), IMakeHelpContextIds.MAKE_BUILDER_SETTINGS);
        if (this.fBuildInfo == null) {
            ControlFactory.createEmptySpace((Composite)composite);
            ControlFactory.createLabel((Composite)composite, (String)MakeUIPlugin.getResourceString("SettingsBlock.label.missingBuilderInformation"));
            return;
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gridData);
        composite.setFont(parent.getFont());
        this.createBuildEnvironmentControls(composite);
        this.createTableButtons(composite);
        this.createAppendReplace(composite);
        boolean append = this.fBuildInfo.appendEnvironment();
        if (append) {
            this.appendEnvironment.setSelection(true);
            this.replaceEnvironment.setSelection(false);
        } else {
            this.replaceEnvironment.setSelection(true);
            this.appendEnvironment.setSelection(false);
        }
        this.updateEnvironment(this.fBuildInfo);
        this.updateAppendReplace();
    }

    private void createBuildEnvironmentControls(Composite parent) {
        Font font = parent.getFont();
        Composite tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)gridData);
        tableComposite.setFont(font);
        Label label = new Label(tableComposite, 0);
        label.setFont(font);
        label.setText(MakeUIPlugin.getResourceString("MakeEnvironmentBlock.6"));
        this.environmentTable = new TableViewer(tableComposite, 68354);
        Table table = this.environmentTable.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setFont(font);
        gridData = new GridData(1808);
        this.environmentTable.getControl().setLayoutData((Object)gridData);
        this.environmentTable.setContentProvider((IContentProvider)new EnvironmentVariableContentProvider());
        this.environmentTable.setLabelProvider((IBaseLabelProvider)new EnvironmentVariableLabelProvider());
        this.environmentTable.setColumnProperties(envTableColumnProperties);
        this.environmentTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MakeEnvironmentBlock.this.handleTableSelectionChanged(event);
            }
        });
        this.environmentTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!MakeEnvironmentBlock.this.environmentTable.getSelection().isEmpty()) {
                    MakeEnvironmentBlock.this.handleEnvEditButtonSelected();
                }
            }
        });
        int i = 0;
        while (i < this.envTableColumnHeaders.length) {
            tableLayout.addColumnData(this.envTableColumnLayouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(this.envTableColumnLayouts[i].resizable);
            tc.setText(this.envTableColumnHeaders[i]);
            ++i;
        }
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        int size = ((IStructuredSelection)event.getSelection()).size();
        this.envEditButton.setEnabled(size == 1);
        this.envRemoveButton.setEnabled(size > 0);
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
        label.setFont(comp.getFont());
    }

    protected void createTableButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = 1;
        GridData gdata = new GridData(130);
        buttonComposite.setLayout((Layout)glayout);
        buttonComposite.setLayoutData((Object)gdata);
        buttonComposite.setFont(parent.getFont());
        this.createVerticalSpacer(buttonComposite, 1);
        this.envAddButton = this.createPushButton(buttonComposite, MakeUIPlugin.getResourceString("MakeEnvironmentBlock.7"), null);
        this.envAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MakeEnvironmentBlock.this.handleEnvAddButtonSelected();
            }
        });
        this.envSelectButton = this.createPushButton(buttonComposite, MakeUIPlugin.getResourceString("MakeEnvironmentBlock.8"), null);
        this.envSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MakeEnvironmentBlock.this.handleEnvSelectButtonSelected();
            }
        });
        this.envEditButton = this.createPushButton(buttonComposite, MakeUIPlugin.getResourceString("MakeEnvironmentBlock.9"), null);
        this.envEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MakeEnvironmentBlock.this.handleEnvEditButtonSelected();
            }
        });
        this.envEditButton.setEnabled(false);
        this.envRemoveButton = this.createPushButton(buttonComposite, MakeUIPlugin.getResourceString("MakeEnvironmentBlock.10"), null);
        this.envRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MakeEnvironmentBlock.this.handleEnvRemoveButtonSelected();
            }
        });
        this.envRemoveButton.setEnabled(false);
    }

    protected void handleEnvAddButtonSelected() {
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), MakeUIPlugin.getResourceString("MakeEnvironmentBlock.11"));
        dialog.addTextField(NAME_LABEL, null, false);
        dialog.addVariablesField(VALUE_LABEL, null, true);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        String value = dialog.getStringValue(VALUE_LABEL);
        if (name != null && value != null && name.length() > 0 && value.length() > 0) {
            this.addVariable(new EnvironmentVariable(name.trim(), value.trim()));
            this.updateAppendReplace();
        }
    }

    protected void updateAppendReplace() {
        boolean enable = this.environmentTable.getTable().getItemCount() > 0;
        this.appendEnvironment.setEnabled(enable);
        this.replaceEnvironment.setEnabled(enable);
    }

    protected boolean addVariable(EnvironmentVariable variable) {
        String name = variable.getName();
        TableItem[] items = this.environmentTable.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            EnvironmentVariable existingVariable = (EnvironmentVariable)items[i].getData();
            if (existingVariable.getName().equals(name)) {
                boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)MakeUIPlugin.getResourceString("MakeEnvironmentBlock.12"), (String)MessageFormat.format(MakeUIPlugin.getResourceString("MakeEnvironmentBlock.13"), name));
                if (!overWrite) {
                    return false;
                }
                this.environmentTable.remove((Object)existingVariable);
                break;
            }
            ++i;
        }
        this.environmentTable.add((Object)variable);
        this.getContainer().updateContainer();
        return true;
    }

    private Map getNativeEnvironment() {
        Properties stringVars = EnvironmentReader.getEnvVars();
        HashMap<String, EnvironmentVariable> vars = new HashMap<String, EnvironmentVariable>();
        Iterator i = stringVars.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)stringVars.get(key);
            vars.put(key, new EnvironmentVariable(key, value));
        }
        return vars;
    }

    protected void handleEnvSelectButtonSelected() {
        Map envVariables = this.getNativeEnvironment();
        TableItem[] items = this.environmentTable.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            EnvironmentVariable var = (EnvironmentVariable)items[i].getData();
            envVariables.remove(var.getName());
            ++i;
        }
        NativeEnvironmentDialog dialog = new NativeEnvironmentDialog(this.getShell(), envVariables, this.createSelectionDialogContentProvider(), this.createSelectionDialogLabelProvider(), MakeUIPlugin.getResourceString("MakeEnvironmentBlock.14"));
        dialog.setTitle(MakeUIPlugin.getResourceString("MakeEnvironmentBlock.15"));
        int button = dialog.open();
        if (button == 0) {
            Object[] selected = dialog.getResult();
            int i2 = 0;
            while (i2 < selected.length) {
                this.environmentTable.add(selected[i2]);
                ++i2;
            }
        }
        this.updateAppendReplace();
        this.getContainer().updateContainer();
    }

    private ILabelProvider createSelectionDialogLabelProvider() {
        return new ILabelProvider(){

            public Image getImage(Object element) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_ENVIRONMNET);
            }

            public String getText(Object element) {
                EnvironmentVariable var = (EnvironmentVariable)element;
                return String.valueOf(var.getName()) + " [" + var.getValue() + "]";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    private IStructuredContentProvider createSelectionDialogContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] elements = null;
                if (inputElement instanceof Map) {
                    Comparator comparator = new Comparator(this){
                        final /* synthetic */ 10 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public int compare(Object o1, Object o2) {
                            String s1 = (String)o1;
                            String s2 = (String)o2;
                            return s1.compareTo(s2);
                        }
                    };
                    TreeMap envVars = new TreeMap(comparator);
                    envVars.putAll((Map)inputElement);
                    elements = new EnvironmentVariable[envVars.size()];
                    int index = 0;
                    Iterator iterator = envVars.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object key = iterator.next();
                        elements[index] = (EnvironmentVariable)envVars.get(key);
                        ++index;
                    }
                }
                return elements;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected void handleEnvEditButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.environmentTable.getSelection();
        EnvironmentVariable var = (EnvironmentVariable)sel.getFirstElement();
        if (var == null) {
            return;
        }
        String originalName = var.getName();
        String value = var.getValue();
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), MakeUIPlugin.getResourceString("MakeEnvironmentBlock.16"));
        dialog.addTextField(NAME_LABEL, originalName, false);
        dialog.addVariablesField(VALUE_LABEL, value, true);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        value = dialog.getStringValue(VALUE_LABEL);
        if (!originalName.equals(name)) {
            if (this.addVariable(new EnvironmentVariable(name, value))) {
                this.environmentTable.remove((Object)var);
            }
        } else {
            var.setValue(value);
            this.environmentTable.update((Object)var, null);
            this.getContainer().updateContainer();
        }
    }

    protected void handleEnvRemoveButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.environmentTable.getSelection();
        this.environmentTable.getControl().setRedraw(false);
        Iterator i = sel.iterator();
        while (i.hasNext()) {
            EnvironmentVariable var = (EnvironmentVariable)i.next();
            this.environmentTable.remove((Object)var);
        }
        this.environmentTable.getControl().setRedraw(true);
        this.updateAppendReplace();
        this.getContainer().updateContainer();
    }

    protected void createAppendReplace(Composite parent) {
        Composite appendReplaceComposite = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        GridLayout layout = new GridLayout();
        appendReplaceComposite.setLayoutData((Object)gridData);
        appendReplaceComposite.setLayout((Layout)layout);
        appendReplaceComposite.setFont(parent.getFont());
        this.appendEnvironment = this.createRadioButton(appendReplaceComposite, MakeUIPlugin.getResourceString("MakeEnvironmentBlock.17"));
        this.appendEnvironment.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MakeEnvironmentBlock.this.getContainer().updateContainer();
            }
        });
        this.replaceEnvironment = this.createRadioButton(appendReplaceComposite, MakeUIPlugin.getResourceString("MakeEnvironmentBlock.18"));
    }

    class EnvironmentVariable {
        private String name;
        private String value;

        EnvironmentVariable(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object obj) {
            boolean equal = false;
            if (obj instanceof EnvironmentVariable) {
                EnvironmentVariable var = (EnvironmentVariable)obj;
                equal = var.getName().equals(this.name);
            }
            return equal;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    protected class EnvironmentVariableContentProvider
    implements IStructuredContentProvider {
        protected EnvironmentVariableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = new EnvironmentVariable[]{};
            IMakeCommonBuildInfo info = (IMakeCommonBuildInfo)inputElement;
            Map m = info.getEnvironment();
            if (m != null && !m.isEmpty()) {
                elements = new EnvironmentVariable[m.size()];
                String[] varNames = new String[m.size()];
                m.keySet().toArray(varNames);
                int i = 0;
                while (i < m.size()) {
                    elements[i] = new EnvironmentVariable(varNames[i], (String)m.get(varNames[i]));
                    ++i;
                }
            }
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                return;
            }
            if (viewer instanceof TableViewer) {
                TableViewer tableViewer = (TableViewer)viewer;
                if (tableViewer.getTable().isDisposed()) {
                    return;
                }
                tableViewer.setSorter(new ViewerSorter(this){
                    final /* synthetic */ EnvironmentVariableContentProvider this$1;
                    {
                        this.this$1 = environmentVariableContentProvider;
                    }

                    public int compare(Viewer iviewer, Object e1, Object e2) {
                        if (e1 == null) {
                            return -1;
                        }
                        if (e2 == null) {
                            return 1;
                        }
                        return ((EnvironmentVariable)e1).getName().compareToIgnoreCase(((EnvironmentVariable)e2).getName());
                    }
                });
            }
        }
    }

    public class EnvironmentVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element != null) {
                EnvironmentVariable var = (EnvironmentVariable)element;
                switch (columnIndex) {
                    case 0: {
                        result = var.getName();
                        break;
                    }
                    case 1: {
                        result = var.getValue();
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return MakeUIImages.getImage(MakeUIImages.IMG_OBJS_ENV_VAR);
            }
            return null;
        }
    }

    private class NativeEnvironmentDialog
    extends ListSelectionDialog {
        public NativeEnvironmentDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
            super(parentShell, input, contentProvider, labelProvider, message);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected IDialogSettings getDialogSettings() {
            IDialogSettings settings = MakeUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
            if (section == null) {
                section = settings.addNewSection(this.getDialogSettingsSectionName());
            }
            return section;
        }

        protected String getDialogSettingsSectionName() {
            return String.valueOf(MakeUIPlugin.getPluginId()) + ".ENVIRONMENT_TAB.NATIVE_ENVIROMENT_DIALOG";
        }

        protected Point getInitialLocation(Point initialSize) {
            Point initialLocation = DialogSettingsHelper.getInitialLocation(this.getDialogSettingsSectionName());
            if (initialLocation != null) {
                return initialLocation;
            }
            return super.getInitialLocation(initialSize);
        }

        protected Point getInitialSize() {
            Point size = super.getInitialSize();
            return DialogSettingsHelper.getInitialSize(this.getDialogSettingsSectionName(), size);
        }

        public boolean close() {
            DialogSettingsHelper.persistShellGeometry(this.getShell(), this.getDialogSettingsSectionName());
            return super.close();
        }
    }
}

