/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.lang.reflect.Array;

public class ArrayUtil {
    public static final int DEFAULT_LENGTH = 2;
    static /* synthetic */ Class class$0;

    public static Object[] append(Class c, Object[] array, Object obj) {
        if (obj == null) {
            return array;
        }
        if (array == null || array.length == 0) {
            array = (Object[])Array.newInstance(c, 2);
            array[0] = obj;
            return array;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == null) {
                array[i] = obj;
                return array;
            }
            ++i;
        }
        Object[] temp = (Object[])Array.newInstance(c, array.length * 2);
        System.arraycopy(array, 0, temp, 0, array.length);
        temp[array.length] = obj;
        array = temp;
        return array;
    }

    public static int[] setInt(int[] array, int idx, int val) {
        if (array == null) {
            array = new int[2 > idx + 1 ? 2 : idx + 1];
            array[idx] = val;
            return array;
        }
        if (array.length <= idx) {
            int newLen = array.length * 2;
            while (newLen <= idx) {
                newLen *= 2;
            }
            int[] temp = new int[newLen];
            System.arraycopy(array, 0, temp, 0, array.length);
            array = temp;
        }
        array[idx] = val;
        return array;
    }

    public static Object[] append(Object[] array, Object obj) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ArrayUtil.append(clazz, array, obj);
    }

    public static Object[] trim(Class c, Object[] array, boolean forceNew) {
        if (array == null) {
            return (Object[])Array.newInstance(c, 0);
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == null) break;
            ++i;
        }
        if (forceNew || i < array.length) {
            Object[] temp = (Object[])Array.newInstance(c, i);
            System.arraycopy(array, 0, temp, 0, i);
            array = temp;
        }
        return array;
    }

    public static Object[] trim(Class c, Object[] array) {
        return ArrayUtil.trim(c, array, false);
    }

    public static Object[] addAll(Class c, Object[] dest, Object[] source) {
        if (source == null || source.length == 0) {
            return dest;
        }
        int numToAdd = 0;
        while (numToAdd < source.length && source[numToAdd] != null) {
            ++numToAdd;
        }
        if (numToAdd == 0) {
            return dest;
        }
        if (dest == null || dest.length == 0) {
            dest = (Object[])Array.newInstance(c, numToAdd);
            System.arraycopy(source, 0, dest, 0, numToAdd);
            return dest;
        }
        int firstFree = 0;
        while (firstFree < dest.length && dest[firstFree] != null) {
            ++firstFree;
        }
        if (firstFree + numToAdd <= dest.length) {
            System.arraycopy(source, 0, dest, firstFree, numToAdd);
            return dest;
        }
        Object[] temp = (Object[])Array.newInstance(c, firstFree + numToAdd);
        System.arraycopy(dest, 0, temp, 0, firstFree);
        System.arraycopy(source, 0, temp, firstFree, numToAdd);
        return temp;
    }

    public static Object[] replace(Class c, Object[] array, int idx, Object obj) {
        if (array == null || idx >= array.length) {
            return array;
        }
        if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            Object[] temp = (Object[])Array.newInstance(c, array.length + objs.length - 1);
            System.arraycopy(array, 0, temp, 0, idx);
            System.arraycopy(objs, 0, temp, idx, objs.length);
            System.arraycopy(array, idx + 1, temp, idx + objs.length, array.length - idx - 1);
            array = temp;
        } else {
            array[idx] = obj;
        }
        return array;
    }

    public static boolean contains(Object[] array, Object obj) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == obj) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Object[] removeNulls(Class c, Object[] array) {
        if (array == null) {
            return (Object[])Array.newInstance(c, 0);
        }
        int validEntries = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                ++validEntries;
            }
            ++i;
        }
        if (array.length == validEntries) {
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(c, validEntries);
        int j = 0;
        i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                newArray[j++] = array[i];
            }
            ++i;
        }
        return newArray;
    }

    public static Object[] removeNullsAfter(Class c, Object[] array, int index) {
        if (array == null || index < 0) {
            return (Object[])Array.newInstance(c, 0);
        }
        if (array.length == index + 1) {
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(c, index + 1);
        int i = 0;
        while (i <= index) {
            newArray[i] = array[i];
            ++i;
        }
        return newArray;
    }

    public static Object[] prepend(Class c, Object[] array, Object obj) {
        if (obj == null) {
            return array;
        }
        if (array == null || array.length == 0) {
            array = (Object[])Array.newInstance(c, 2);
            array[0] = obj;
            return array;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == null) {
                array[i] = obj;
                return array;
            }
            ++i;
        }
        if (i < array.length) {
            System.arraycopy(array, 0, array, 1, array.length - i);
            array[0] = obj;
        } else {
            Object[] temp = (Object[])Array.newInstance(c, array.length * 2);
            System.arraycopy(array, 0, temp, 1, array.length);
            temp[0] = obj;
            array = temp;
        }
        return array;
    }

    public static final class ArrayWrapper {
        public Object[] array = null;
    }
}

