/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;

public class CPPDelegate
implements ICPPDelegate,
ICPPInternalBinding {
    private IBinding binding = null;
    private int type = 0;
    private IASTName name = null;

    public CPPDelegate(IASTName name, IBinding binding) {
        this.binding = binding;
        this.name = name;
    }

    public int getDelegateType() {
        return this.type;
    }

    public IBinding getBinding() {
        return this.binding;
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public String getName() {
        return this.name.toString();
    }

    public char[] getNameCharArray() {
        return this.name.toCharArray();
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.name.getParent());
    }

    public IASTNode[] getDeclarations() {
        return null;
    }

    public IASTNode getDefinition() {
        if (this.binding instanceof ICPPInternalBinding) {
            return ((ICPPInternalBinding)this.binding).getDefinition();
        }
        return this.name;
    }

    public void setName(IASTName name) {
        this.name = name;
    }

    public ICPPDelegate createDelegate(IASTName n) {
        CPPDelegate delegate = null;
        try {
            delegate = (CPPDelegate)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        delegate.setName(n);
        return delegate;
    }

    public void addDefinition(IASTNode node) {
    }

    public void addDeclaration(IASTNode node) {
    }

    public void removeDeclaration(IASTNode node) {
    }
}

