/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;

public class ScannerUtility {
    public static String reconcilePath(String originalPath) {
        if (originalPath == null) {
            return null;
        }
        String[] segments = (originalPath = ScannerUtility.removeQuotes(originalPath)).split("[/\\\\]");
        if (segments.length == 1) {
            return originalPath;
        }
        Vector<String> results = new Vector<String>(segments.length);
        int i = 0;
        while (i < segments.length) {
            String segment = segments[i];
            if (!segment.equals(".")) {
                if (segment.equals("..")) {
                    if (results.size() > 0) {
                        results.removeElementAt(results.size() - 1);
                    }
                } else {
                    results.add(segment);
                }
            }
            ++i;
        }
        StringBuffer strbuff = new StringBuffer(128);
        int i2 = 0;
        while (i2 < results.size()) {
            strbuff.append((String)results.elementAt(i2));
            if (i2 != results.size() - 1) {
                strbuff.append(File.separatorChar);
            }
            ++i2;
        }
        return strbuff.toString();
    }

    private static String removeQuotes(String originalPath) {
        String[] segments = originalPath.split("\"");
        if (segments.length == 1) {
            return originalPath;
        }
        StringBuffer strbuff = new StringBuffer();
        int i = 0;
        while (i < segments.length) {
            if (segments[i] != null) {
                strbuff.append(segments[i]);
            }
            ++i;
        }
        return strbuff.toString();
    }

    public static CodeReader createReaderDuple(String path, ISourceElementRequestor requestor, Iterator workingCopies) {
        return requestor.createReader(path, workingCopies);
    }

    public static String createReconciledPath(String path, String fileName) {
        StringBuffer newPathBuffer = new StringBuffer();
        if (!path.equals("")) {
            newPathBuffer.append(new File(path).getPath());
            if (fileName.length() > 0 && fileName.toCharArray()[0] != File.separatorChar) {
                newPathBuffer.append(File.separatorChar);
            }
        }
        newPathBuffer.append(fileName);
        return ScannerUtility.reconcilePath(newPathBuffer.toString());
    }

    public static class InclusionDirective {
        private final boolean useIncludePaths;
        private final String fileName;
        private final int startOffset;
        private final int endOffset;

        public InclusionDirective(String fileName, boolean useIncludePaths, int startOffset, int endOffset) {
            this.fileName = fileName;
            this.useIncludePaths = useIncludePaths;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        boolean useIncludePaths() {
            return this.useIncludePaths;
        }

        public String getFilename() {
            return this.fileName;
        }

        int getStartOffset() {
            return this.startOffset;
        }

        int getEndOffset() {
            return this.endOffset;
        }
    }

    public static class InclusionParseException
    extends Exception {
    }
}

