/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.model.IEnableDisableTarget;
import org.eclipse.cdt.debug.core.model.IPersistableRegisterGroup;
import org.eclipse.cdt.debug.core.model.IRegisterDescriptor;
import org.eclipse.cdt.debug.internal.core.CRegisterManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CRegister;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegister;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CRegisterGroup
extends CDebugElement
implements IPersistableRegisterGroup,
IEnableDisableTarget {
    private static final String ELEMENT_REGISTER_GROUP = "registerGroup";
    private static final String ATTR_REGISTER_GROUP_NAME = "name";
    private static final String ATTR_REGISTER_GROUP_ENABLED = "enabled";
    private static final String ELEMENT_REGISTER = "register";
    private static final String ATTR_REGISTER_NAME = "name";
    private static final String ATTR_REGISTER_ORIGINAL_GROUP_NAME = "originalGroupName";
    private String fName;
    private IRegisterDescriptor[] fRegisterDescriptors;
    private IRegister[] fRegisters;
    private boolean fIsEnabled = true;
    private boolean fDisposed = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CRegisterGroup(CDebugTarget target) {
        super(target);
    }

    public CRegisterGroup(CDebugTarget target, String name, IRegisterDescriptor[] descriptors) {
        super(target);
        this.fName = name;
        this.fRegisterDescriptors = descriptors;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRegister[] getRegisters() throws DebugException {
        if (this.fDisposed) {
            return new IRegister[0];
        }
        if (this.fRegisters == null) {
            CRegisterGroup cRegisterGroup = this;
            synchronized (cRegisterGroup) {
                if (this.fRegisters == null) {
                    this.fRegisters = new IRegister[this.fRegisterDescriptors.length];
                    int i = 0;
                    while (i < this.fRegisters.length) {
                        this.fRegisters[i] = new CRegister(this, this.fRegisterDescriptors[i]);
                        ++i;
                    }
                }
            }
        }
        return this.fRegisters;
    }

    public boolean hasRegisters() throws DebugException {
        return this.fRegisterDescriptors.length > 0;
    }

    public void dispose() {
        this.fDisposed = true;
        this.invalidate();
    }

    public void targetSuspended() {
        if (this.fRegisters == null) {
            return;
        }
        int i = 0;
        while (i < this.fRegisters.length) {
            if (this.fRegisters[i] != null && ((CRegister)this.fRegisters[i]).hasErrors()) {
                ((CRegister)this.fRegisters[i]).resetStatus();
            }
            ++i;
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IEnableDisableTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public boolean canEnableDisable() {
        return true;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setEnabled(boolean enabled) throws DebugException {
        if (this.fRegisters != null) {
            IRegister[] iRegisterArray = this.fRegisters;
            // MONITORENTER : this.fRegisters
            if (this.fRegisters != null) {
                int i = 0;
                while (i < this.fRegisters.length) {
                    if (this.fRegisters[i] instanceof CRegister) {
                        ((CRegister)this.fRegisters[i]).setEnabled(enabled);
                    }
                    ++i;
                }
            }
            // MONITOREXIT : iRegisterArray
        }
        this.fIsEnabled = enabled;
        this.fireChangeEvent(512);
    }

    public String getMemento() throws CoreException {
        Document document = DebugPlugin.newDocument();
        Element element = document.createElement(ELEMENT_REGISTER_GROUP);
        element.setAttribute("name", this.getName());
        element.setAttribute(ATTR_REGISTER_GROUP_ENABLED, this.isEnabled() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        int i = 0;
        while (i < this.fRegisterDescriptors.length) {
            Element child = document.createElement(ELEMENT_REGISTER);
            child.setAttribute("name", this.fRegisterDescriptors[i].getName());
            child.setAttribute(ATTR_REGISTER_ORIGINAL_GROUP_NAME, this.fRegisterDescriptors[i].getGroupName());
            element.appendChild(child);
            ++i;
        }
        document.appendChild(element);
        return DebugPlugin.serializeDocument((Document)document);
    }

    public void initializeFromMemento(String memento) throws CoreException {
        String groupName;
        Element element;
        Element node = DebugPlugin.parseDocument((String)memento);
        if (node.getNodeType() != 1) {
            this.abort(CoreModelMessages.getString("CRegisterGroup.0"), null);
        }
        if (!ELEMENT_REGISTER_GROUP.equals((element = node).getNodeName())) {
            this.abort(CoreModelMessages.getString("CRegisterGroup.1"), null);
        }
        if ((groupName = element.getAttribute("name")) == null || groupName.length() == 0) {
            this.abort(CoreModelMessages.getString("CRegisterGroup.2"), null);
        }
        String e = element.getAttribute(ATTR_REGISTER_GROUP_ENABLED);
        boolean enabled = Boolean.valueOf(e);
        CRegisterManager rm = this.getRegisterManager();
        ArrayList<IRegisterDescriptor> list = new ArrayList<IRegisterDescriptor>();
        Node childNode = element.getFirstChild();
        while (childNode != null) {
            Element child;
            if (childNode.getNodeType() == 1 && ELEMENT_REGISTER.equals((child = (Element)childNode).getNodeName())) {
                String name = child.getAttribute("name");
                String originalGroupName = child.getAttribute(ATTR_REGISTER_ORIGINAL_GROUP_NAME);
                if (name == null || name.length() == 0 || originalGroupName == null || originalGroupName.length() == 0) {
                    this.abort(CoreModelMessages.getString("CRegisterGroup.3"), null);
                } else {
                    IRegisterDescriptor d = rm.findDescriptor(originalGroupName, name);
                    if (d != null) {
                        list.add(d);
                    } else {
                        CDebugCorePlugin.log(CoreModelMessages.getString("CRegisterGroup.4"));
                    }
                }
            }
            childNode = childNode.getNextSibling();
        }
        this.setName(groupName);
        this.fRegisterDescriptors = list.toArray(new IRegisterDescriptor[list.size()]);
        this.setEnabled(enabled);
    }

    private void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, message, exception);
        throw new CoreException((IStatus)status);
    }

    private void setName(String name) {
        this.fName = name;
    }

    public void setRegisterDescriptors(IRegisterDescriptor[] registerDescriptors) {
        this.invalidate();
        this.fRegisterDescriptors = registerDescriptors;
    }

    public IRegisterDescriptor[] getRegisterDescriptors() {
        return this.fRegisterDescriptors;
    }

    private CRegisterManager getRegisterManager() {
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.CRegisterManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (CRegisterManager)iDebugTarget.getAdapter((Class)clazz);
    }

    private void invalidate() {
        if (this.fRegisters == null) {
            return;
        }
        int i = 0;
        while (i < this.fRegisters.length) {
            if (this.fRegisters[i] != null) {
                ((CRegister)this.fRegisters[i]).dispose();
            }
            ++i;
        }
        this.fRegisters = null;
    }

    public void resetRegisterValues() {
        if (this.fRegisters == null) {
            return;
        }
        int i = 0;
        while (i < this.fRegisters.length) {
            if (this.fRegisters[i] != null) {
                ((CRegister)this.fRegisters[i]).invalidateValue();
            }
            ++i;
        }
    }
}

