/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.sourcelookup;

import java.io.File;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.internal.ui.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.Separator;
import org.eclipse.cdt.debug.internal.ui.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CDirectorySourceContainerDialog
extends TitleAreaDialog {
    private StringButtonDialogField fDirectoryField;
    private SelectionButtonDialogField fSubfoldersField;
    private File fDirectory;
    private boolean fSearchSubfolders;

    public CDirectorySourceContainerDialog(Shell parentShell) {
        this(parentShell, new File(""), false);
    }

    public CDirectorySourceContainerDialog(Shell parentShell, File directory, boolean searchSubfolders) {
        super(parentShell);
        this.fDirectory = directory;
        this.fSearchSubfolders = searchSubfolders;
        this.fDirectoryField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                CDirectorySourceContainerDialog.this.browse();
            }
        });
        this.fDirectoryField.setLabelText(SourceLookupUIMessages.getString("CDirectorySourceContainerDialog.0"));
        this.fDirectoryField.setButtonLabel(SourceLookupUIMessages.getString("CDirectorySourceContainerDialog.1"));
        this.fDirectoryField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                CDirectorySourceContainerDialog.this.update();
            }
        });
        this.fSubfoldersField = new SelectionButtonDialogField(32);
        this.fSubfoldersField.setLabelText(SourceLookupUIMessages.getString("CDirectorySourceContainerDialog.2"));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(SourceLookupUIMessages.getString("CDirectorySourceContainerDialog.3"));
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = Math.max(this.fDirectoryField.getNumberOfControls(), this.fSubfoldersField.getNumberOfControls());
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), ICDebugHelpContextIds.ADD_DIRECTORY_CONTAINER_DIALOG);
        PixelConverter converter = new PixelConverter((Control)composite);
        this.fDirectoryField.doFillIntoGrid(composite, layout.numColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.fDirectoryField.getTextControl(null));
        new Separator().doFillIntoGrid(composite, layout.numColumns, converter.convertHeightInCharsToPixels(1));
        this.fSubfoldersField.doFillIntoGrid(composite, layout.numColumns);
        this.initialize();
        this.setMessage(null);
        return super.createDialogArea(parent);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(SourceLookupUIMessages.getString("CDirectorySourceContainerDialog.4"));
        super.configureShell(newShell);
    }

    protected void browse() {
        String last = this.fDirectoryField.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4);
        dialog.setFilterPath(last);
        String result = dialog.open();
        if (result == null) {
            return;
        }
        this.fDirectoryField.setText(result);
    }

    protected void okPressed() {
        this.fDirectory = new File(this.fDirectoryField.getText());
        this.fSearchSubfolders = this.fSubfoldersField.isSelected();
        super.okPressed();
    }

    public File getDirectory() {
        return this.fDirectory;
    }

    public boolean isSearchSubfolders() {
        return this.fSearchSubfolders;
    }

    private void initialize() {
        this.fDirectoryField.setText(this.getDirectory().getPath());
        this.fSubfoldersField.setSelection(this.isSearchSubfolders());
    }

    protected void update() {
        boolean isOk = this.updateErrorMessage();
        Button ok = this.getButton(0);
        if (ok != null) {
            ok.setEnabled(isOk);
        }
    }

    private boolean updateErrorMessage() {
        this.setErrorMessage(null);
        String text = this.fDirectoryField.getText().trim();
        if (text.length() == 0) {
            this.setErrorMessage(SourceLookupUIMessages.getString("CDirectorySourceContainerDialog.5"));
            return false;
        }
        File file = new File(text);
        if (!file.exists()) {
            this.setErrorMessage(SourceLookupUIMessages.getString("CDirectorySourceContainerDialog.6"));
            return false;
        }
        if (!file.isDirectory()) {
            this.setErrorMessage(SourceLookupUIMessages.getString("CDirectorySourceContainerDialog.7"));
            return false;
        }
        if (!file.isAbsolute()) {
            this.setErrorMessage(SourceLookupUIMessages.getString("CDirectorySourceContainerDialog.8"));
            return false;
        }
        return true;
    }
}

