/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.util.Arrays;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.IOption;

public class ManagedOptionValueHandler
implements IManagedOptionValueHandler {
    private static ManagedOptionValueHandler mbsValueHandler;

    protected ManagedOptionValueHandler() {
        mbsValueHandler = null;
    }

    public static ManagedOptionValueHandler getManagedOptionValueHandler() {
        if (mbsValueHandler == null) {
            mbsValueHandler = new ManagedOptionValueHandler();
        }
        return mbsValueHandler;
    }

    public boolean handleValue(IBuildObject configuration, IHoldsOptions holder, IOption option, String extraArgument, int event) {
        return false;
    }

    public boolean isDefaultValue(IBuildObject configuration, IHoldsOptions holder, IOption option, String extraArgument) {
        Object defaultValue = option.getDefaultValue();
        try {
            switch (option.getValueType()) {
                case 2: {
                    if (option.getStringValue().equals((String)defaultValue)) {
                        return true;
                    }
                    break;
                }
                case 0: {
                    if (option.getBooleanValue() == ((Boolean)defaultValue).booleanValue()) {
                        return true;
                    }
                    break;
                }
                case 1: {
                    if (option.getValue().toString().equals(defaultValue.toString())) {
                        return true;
                    }
                    break;
                }
                case 4: {
                    if (Arrays.equals(option.getIncludePaths(), (String[])defaultValue)) {
                        return true;
                    }
                    break;
                }
                case 3: {
                    if (Arrays.equals(option.getStringListValue(), (String[])defaultValue)) {
                        return true;
                    }
                    break;
                }
                case 5: {
                    if (Arrays.equals(option.getDefinedSymbols(), (String[])defaultValue)) {
                        return true;
                    }
                    break;
                }
                case 6: {
                    if (Arrays.equals(option.getLibraries(), (String[])defaultValue)) {
                        return true;
                    }
                    break;
                }
                case 7: {
                    if (Arrays.equals(option.getUserObjects(), (String[])defaultValue)) {
                        return true;
                    }
                    break;
                }
            }
        }
        catch (BuildException buildException) {}
        return false;
    }

    public boolean isEnumValueAppropriate(IBuildObject configuration, IHoldsOptions holder, IOption option, String extraArgument, String enumValue) {
        return true;
    }
}

