/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.cbrowsing;

import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.CBrowsingElementFilter;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.CBrowsingLabelProvider;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.CBrowsingPart;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.CBrowsingViewerSorter;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.ElementTreeViewer;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.LexicalSortingAction;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.MembersViewContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTargetList;

public class MembersView
extends CBrowsingPart
implements IPropertyChangeListener {
    static /* synthetic */ Class class$0;

    public MembersView() {
        this.setHasWorkingSetFilter(false);
        this.setHasCustomSetFilter(true);
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.cdt.ui.CView"};
                }
            };
        }
        return super.getAdapter(key);
    }

    protected LabelProvider createLabelProvider() {
        return new CBrowsingLabelProvider();
    }

    protected String getHelpContextId() {
        return "org.eclipse.cdt.ui.members_view_context";
    }

    protected String getLinkToEditorKey() {
        return "org.eclipse.cdt.ui.browsing.memberstoeditor";
    }

    protected StructuredViewer createViewer(Composite parent) {
        ElementTreeViewer viewer = new ElementTreeViewer(parent, 2);
        return viewer;
    }

    protected ViewerSorter createViewerSorter() {
        return new CBrowsingViewerSorter();
    }

    protected void addFilters() {
        super.addFilters();
        this.getViewer().addFilter((ViewerFilter)new CBrowsingElementFilter());
    }

    protected void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)new LexicalSortingAction(this.getViewer(), CUIPlugin.ID_MEMBERS_VIEW));
        super.fillToolBar(tbm);
    }

    protected boolean isValidInput(Object element) {
        ITypeInfo type;
        return element instanceof ITypeInfo && (type = (ITypeInfo)element).getCElementType() != 61 && type.exists();
    }

    protected boolean isValidElement(Object element) {
        if (element instanceof ICElement) {
            return !(element instanceof ICModel) && !(element instanceof ICProject) && !(element instanceof ISourceRoot) && !(element instanceof ITranslationUnit);
        }
        return false;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    protected void restoreState(IMemento memento) {
        super.restoreState(memento);
        this.getViewer().getControl().setRedraw(false);
        this.getViewer().refresh();
        this.getViewer().getControl().setRedraw(true);
    }

    protected void hookViewerListeners() {
        super.hookViewerListeners();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                TreeViewer viewer = (TreeViewer)MembersView.this.getViewer();
                if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
                    viewer.setExpandedState(element, !viewer.getExpandedState(element));
                }
            }
        });
    }

    protected void restoreSelection() {
        IEditorPart editor = this.getViewSite().getPage().getActiveEditor();
        if (editor != null) {
            this.setSelectionFromEditor((IWorkbenchPart)editor);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void dispose() {
        super.dispose();
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected IContentProvider createContentProvider() {
        return new MembersViewContentProvider(this);
    }

    protected Object findInputForElement(Object element) {
        if (element instanceof ICModel || element instanceof ICProject || element instanceof ISourceRoot) {
            return null;
        }
        if (element instanceof ITypeInfo) {
            return element;
        }
        if (element instanceof ICElement) {
            ICElement celem = (ICElement)element;
            if (!celem.exists()) {
                return null;
            }
            if (TypeUtil.isDeclaringType((ICElement)celem)) {
                ICElement type = TypeUtil.getDeclaringType((ICElement)celem);
                if (type == null || type instanceof INamespace) {
                    return AllTypesCache.getTypeForElement((ICElement)celem, (boolean)true, (boolean)true, null);
                }
                return this.findInputForElement(type);
            }
            if (TypeUtil.isMemberType((ICElement)celem)) {
                return this.findInputForElement(TypeUtil.getDeclaringType((ICElement)celem));
            }
            ITranslationUnit tu = TypeUtil.getTranslationUnit((ICElement)celem);
            if (tu != null) {
                return this.getTypeForTU(tu);
            }
        }
        return null;
    }

    protected Object findElementToSelect(Object element) {
        if (this.isValidElement(element)) {
            return element;
        }
        return null;
    }
}

