/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableDescriptor;
import org.eclipse.cdt.debug.core.model.CVariableFormat;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.model.AbstractCValue;
import org.eclipse.cdt.debug.internal.core.model.AbstractCVariable;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CType;
import org.eclipse.cdt.debug.internal.core.model.CValueFactory;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;

public abstract class CVariable
extends AbstractCVariable
implements ICDIEventListener {
    private boolean fIsEnabled = true;
    private IInternalVariable fOriginal;
    private IInternalVariable fShadow;
    private String fName;
    private CVariableFormat fFormat = CVariableFormat.getFormat(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT));
    private boolean fIsDisposed = false;

    protected CVariable(CDebugElement parent, ICDIVariableDescriptor cdiVariableObject) {
        super(parent);
        if (cdiVariableObject != null) {
            this.setName(cdiVariableObject.getName());
            this.createOriginal(cdiVariableObject);
        }
        this.fIsEnabled = parent instanceof AbstractCValue ? ((AbstractCValue)parent).getParentVariable().isEnabled() : !this.isBookkeepingEnabled();
        this.getCDISession().getEventManager().addEventListener(this);
    }

    protected CVariable(CDebugElement parent, ICDIVariableDescriptor cdiVariableObject, String errorMessage) {
        super(parent);
        if (cdiVariableObject != null) {
            this.setName(cdiVariableObject.getName());
            this.createOriginal(cdiVariableObject);
        }
        this.fIsEnabled = !this.isBookkeepingEnabled();
        this.setStatus(2, MessageFormat.format(CoreModelMessages.getString("CVariable.1"), errorMessage));
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public ICType getType() throws DebugException {
        if (this.isDisposed()) {
            return null;
        }
        IInternalVariable iv = this.getCurrentInternalVariable();
        return iv != null ? iv.getType() : null;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public void setEnabled(boolean enabled) throws DebugException {
        IInternalVariable iv = this.getOriginal();
        if (iv != null) {
            iv.dispose(true);
        }
        if ((iv = this.getShadow()) != null) {
            iv.dispose(true);
        }
        this.fIsEnabled = enabled;
        this.fireChangeEvent(256);
    }

    public boolean canEnableDisable() {
        return !(this.getParent() instanceof IValue);
    }

    public boolean isArgument() {
        IInternalVariable iv = this.getOriginal();
        return iv != null ? iv.isArgument() : false;
    }

    public IValue getValue() throws DebugException {
        IInternalVariable iv;
        if (!this.isDisposed() && this.isEnabled() && (iv = this.getCurrentInternalVariable()) != null) {
            try {
                return iv.getValue();
            }
            catch (DebugException e) {
                this.setStatus(2, e.getMessage());
            }
        }
        return CValueFactory.NULL_VALUE;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public String getReferenceTypeName() throws DebugException {
        ICType type = this.getType();
        return type != null ? type.getName() : "";
    }

    public boolean hasValueChanged() throws DebugException {
        if (this.isDisposed()) {
            return false;
        }
        IInternalVariable iv = this.getCurrentInternalVariable();
        return iv != null ? iv.isChanged() : false;
    }

    public boolean supportsFormatting() {
        return true;
    }

    public CVariableFormat getFormat() {
        return this.fFormat;
    }

    public void changeFormat(CVariableFormat format) throws DebugException {
        this.setFormat(format);
        this.resetValue();
    }

    public boolean canCastToArray() {
        try {
            ICType type = this.getType();
            return this.getOriginal() != null && this.isEnabled() && type.isPointer();
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public void castToArray(int startIndex, int length) throws DebugException {
        IInternalVariable current = this.getCurrentInternalVariable();
        if (current != null) {
            IInternalVariable newVar = current.createShadow(startIndex, length);
            if (this.getShadow() != null) {
                this.getShadow().dispose(true);
            }
            this.setShadow(newVar);
            this.resetValue();
        }
    }

    public void setValue(String expression) throws DebugException {
        IInternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            String newExpression = this.processExpression(expression);
            iv.setValue(newExpression);
        }
    }

    public void setValue(IValue value) throws DebugException {
        CDebugElement.notSupported(CoreModelMessages.getString("CVariable.3"));
    }

    public boolean supportsValueModification() {
        try {
            return this.getCurrentInternalVariable().isEditable();
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return value.getDebugTarget().equals(this.getDebugTarget());
    }

    public boolean canCast() {
        return this.getOriginal() != null && this.isEnabled();
    }

    public String getCurrentType() {
        String typeName = "";
        try {
            typeName = this.getReferenceTypeName();
        }
        catch (DebugException debugException) {}
        return typeName;
    }

    public void cast(String type) throws DebugException {
        IInternalVariable current = this.getCurrentInternalVariable();
        if (current != null) {
            IInternalVariable newVar = current.createShadow(type);
            if (this.getShadow() != null) {
                this.getShadow().dispose(true);
            }
            this.setShadow(newVar);
            this.resetValue();
        }
    }

    public void restoreOriginal() throws DebugException {
        IInternalVariable iv;
        IInternalVariable oldVar = this.getShadow();
        this.setShadow(null);
        if (oldVar != null) {
            oldVar.dispose(true);
        }
        if ((iv = this.getOriginal()) != null) {
            iv.invalidateValue();
        }
        this.resetValue();
    }

    public boolean isCasted() {
        return this.getShadow() != null;
    }

    public void handleDebugEvents(ICDIEvent[] events) {
        IInternalVariable iv = this.getCurrentInternalVariable();
        if (iv == null) {
            return;
        }
        int i = 0;
        while (i < events.length) {
            ICDITarget target;
            ICDIEvent event = events[i];
            ICDIObject source = event.getSource();
            if (source != null && (target = source.getTarget()).equals(this.getCDITarget())) {
                if (event instanceof ICDIChangedEvent) {
                    if (source instanceof ICDIVariable && iv.isSameVariable((ICDIVariable)source)) {
                        this.handleChangedEvent((ICDIChangedEvent)event);
                    }
                } else if (event instanceof ICDIResumedEvent) {
                    this.handleResumedEvent((ICDIResumedEvent)event);
                }
            }
            ++i;
        }
    }

    private void handleResumedEvent(ICDIResumedEvent event) {
        boolean changed = false;
        if (this.hasErrors()) {
            this.resetStatus();
            changed = true;
            IInternalVariable iv = this.getCurrentInternalVariable();
            if (iv != null) {
                iv.invalidateValue();
            }
        }
        if (changed) {
            this.fireChangeEvent(256);
        }
    }

    private void handleChangedEvent(ICDIChangedEvent event) {
        IInternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            iv.setChanged(true);
            this.fireChangeEvent(256);
        }
    }

    private IInternalVariable getCurrentInternalVariable() {
        if (this.getShadow() != null) {
            return this.getShadow();
        }
        return this.getOriginal();
    }

    private IInternalVariable getOriginal() {
        return this.fOriginal;
    }

    protected void setOriginal(IInternalVariable original) {
        this.fOriginal = original;
    }

    private IInternalVariable getShadow() {
        return this.fShadow;
    }

    private void setShadow(IInternalVariable shadow) {
        this.fShadow = shadow;
    }

    protected boolean isBookkeepingEnabled() {
        boolean result = false;
        try {
            result = this.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", false);
        }
        catch (CoreException coreException) {}
        return result;
    }

    protected abstract void createOriginal(ICDIVariableDescriptor var1);

    protected boolean hasErrors() {
        return !this.isOK();
    }

    protected void setChanged(boolean changed) {
        IInternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            iv.setChanged(changed);
        }
    }

    protected void resetValue() {
        IInternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            this.resetStatus();
            iv.resetValue();
            this.fireChangeEvent(256);
        }
    }

    private String processExpression(String oldExpression) throws DebugException {
        return oldExpression;
    }

    public void dispose() {
        this.internalDispose(false);
        this.setDisposed(true);
    }

    protected int sizeof() {
        IInternalVariable iv = this.getCurrentInternalVariable();
        return iv != null ? iv.sizeof() : -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CVariable) {
            IInternalVariable iv = this.getOriginal();
            return iv != null ? iv.equals(((CVariable)obj).getOriginal()) : false;
        }
        return false;
    }

    protected boolean sameVariable(ICDIVariableDescriptor vo) {
        IInternalVariable iv = this.getOriginal();
        return iv != null && iv.isSameDescriptor(vo);
    }

    protected void setFormat(CVariableFormat format) {
        this.fFormat = format;
    }

    public String getExpressionString() throws DebugException {
        IInternalVariable iv = this.getCurrentInternalVariable();
        return iv != null ? iv.getQualifiedName() : null;
    }

    protected void preserve() {
        this.resetStatus();
        IInternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            iv.preserve();
        }
    }

    protected void internalDispose(boolean destroy) {
        this.getCDISession().getEventManager().removeEventListener(this);
        IInternalVariable iv = this.getOriginal();
        if (iv != null) {
            iv.dispose(destroy);
        }
        if ((iv = this.getShadow()) != null) {
            iv.dispose(destroy);
        }
    }

    protected boolean isDisposed() {
        return this.fIsDisposed;
    }

    protected void setDisposed(boolean isDisposed) {
        this.fIsDisposed = isDisposed;
    }

    protected void invalidateValue() {
        this.resetStatus();
        IInternalVariable iv = this.getCurrentInternalVariable();
        if (iv != null) {
            iv.invalidateValue();
        }
    }

    protected void setName(String name) {
        this.fName = name;
    }

    static interface IInternalVariable {
        public IInternalVariable createShadow(int var1, int var2) throws DebugException;

        public IInternalVariable createShadow(String var1) throws DebugException;

        public CType getType() throws DebugException;

        public String getQualifiedName() throws DebugException;

        public ICValue getValue() throws DebugException;

        public void setValue(String var1) throws DebugException;

        public boolean isChanged();

        public void setChanged(boolean var1);

        public void dispose(boolean var1);

        public boolean isSameDescriptor(ICDIVariableDescriptor var1);

        public boolean isSameVariable(ICDIVariable var1);

        public void resetValue();

        public boolean isEditable() throws DebugException;

        public boolean isArgument();

        public int sizeof();

        public void invalidateValue();

        public void preserve();
    }
}

