/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CreateMemberOperation;
import org.eclipse.cdt.internal.core.model.Util;

public class CreateMethodOperation
extends CreateMemberOperation {
    protected String[] fParameterTypes;
    protected String fSource;

    public CreateMethodOperation(IStructure parentElement, String name, String returnType, String source, String[] parameters, boolean force) {
        super(parentElement, name, returnType, force);
        this.fParameterTypes = parameters;
        this.fSource = source;
    }

    protected ICElement generateResultHandle() {
        return this.getStructure().getMethod(this.fName);
    }

    public String getMainTaskName() {
        return "operation.createMethodProgress";
    }

    protected ICModelStatus verifyNameCollision() {
        ICModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.fSource == null) {
            return new CModelStatus(984);
        }
        return CModelStatus.VERIFIED_OK;
    }

    protected String generateElement(ITranslationUnit unit) throws CModelException {
        StringBuffer sb = new StringBuffer();
        sb.append(this.fReturnType);
        sb.append(' ');
        sb.append(this.fName);
        sb.append('(');
        if (this.fParameterTypes != null) {
            int i = 0;
            while (i < this.fParameterTypes.length) {
                if (i != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(this.fParameterTypes[i]);
                ++i;
            }
        }
        sb.append(')').append(' ').append('{').append(Util.LINE_SEPARATOR);
        sb.append(this.fSource);
        sb.append(Util.LINE_SEPARATOR).append('}').append(Util.LINE_SEPARATOR);
        return sb.toString();
    }
}

