/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.net.URL;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIImages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ToolListLabelProvider
extends LabelProvider {
    private final Image IMG_TOOL = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_BUILD_TOOL);
    private final Image IMG_CAT = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_BUILD_CAT);
    private static final String TREE_LABEL = "BuildPropertyPage.label.ToolTree";
    private static final String ERROR_UNKNOWN_ELEMENT = "BuildPropertyPage.error.Unknown_tree_element";
    private ImageDescriptor descriptor = null;
    private ResourceManager manager = null;

    private Image getIconFromOptionCategory(IOptionCategory cat) {
        Image img = null;
        URL url = cat.getIconPath();
        if (url != null) {
            this.descriptor = ImageDescriptor.createFromURL((URL)url);
            this.manager = JFaceResources.getResources((Display)Display.getCurrent());
            Assert.isNotNull((Object)this.manager);
            img = this.manager.createImageWithDefault(this.descriptor);
            if (img == null) {
                System.err.println("Couldn't create image from URL \"" + url + "\", to display icon for Tool Options.");
            }
        }
        return img;
    }

    public Image getImage(Object element) {
        if (element instanceof ITool) {
            IOptionCategory cat;
            Image img;
            if (element instanceof IOptionCategory && (img = this.getIconFromOptionCategory(cat = (IOptionCategory)element)) != null) {
                return img;
            }
            return this.IMG_TOOL;
        }
        if (element instanceof IOptionCategory) {
            IOptionCategory cat = (IOptionCategory)element;
            Image img = this.getIconFromOptionCategory(cat);
            if (img != null) {
                return img;
            }
            return this.IMG_CAT;
        }
        throw this.unknownElement(element);
    }

    public String getText(Object element) {
        if (element instanceof ITool) {
            ITool tool = (ITool)element;
            return tool.getName();
        }
        if (element instanceof IOptionCategory) {
            IOptionCategory cat = (IOptionCategory)element;
            return cat.getName();
        }
        throw this.unknownElement(element);
    }

    protected RuntimeException unknownElement(Object element) {
        return new RuntimeException(ManagedBuilderUIMessages.getFormattedString(ERROR_UNKNOWN_ELEMENT, element.getClass().getName()));
    }

    public void dispose() {
        if (this.descriptor != null && this.manager != null) {
            this.manager.destroyImage(this.descriptor);
        }
    }
}

