/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;

public abstract class CPPScope
implements ICPPScope {
    private IASTNode physicalNode;
    protected CharArrayObjectMap bindings = null;
    private boolean isfull = false;
    static /* synthetic */ Class class$0;

    public CPPScope(IASTNode physicalNode) {
        this.physicalNode = physicalNode;
    }

    public IScope getParent() throws DOMException {
        return CPPVisitor.getContainingScope(this.physicalNode);
    }

    public IASTNode getPhysicalNode() {
        return this.physicalNode;
    }

    public void addName(IASTName name) {
        char[] c;
        Object o;
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if (name instanceof ICPPASTQualifiedName) {
            return;
        }
        if (name instanceof ICPPASTTemplateId) {
            name = ((ICPPASTTemplateId)name).getTemplateName();
        }
        if ((o = this.bindings.get(c = name.toCharArray())) != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(name);
            } else {
                ObjectSet temp = new ObjectSet(2);
                temp.put(o);
                temp.put(name);
                this.bindings.put(c, temp);
            }
        } else {
            this.bindings.put(c, name);
        }
    }

    public IBinding getBinding(IASTName name, boolean forceResolve) throws DOMException {
        char[] c = name.toCharArray();
        if (c.length == 0 || this.bindings == null) {
            return null;
        }
        Object obj = this.bindings.get(c);
        if (obj != null) {
            if (obj instanceof ObjectSet) {
                ObjectSet os = (ObjectSet)obj;
                if (forceResolve) {
                    return CPPSemantics.resolveAmbiguities(name, os.keyArray());
                }
                Object[] bs = null;
                int i = 0;
                while (i < os.size()) {
                    Object o = os.keyAt(i);
                    if (o instanceof IASTName) {
                        Class<?> clazz;
                        IASTName n = (IASTName)o;
                        if (n instanceof ICPPASTQualifiedName) {
                            IASTName[] ns = ((ICPPASTQualifiedName)n).getNames();
                            n = ns[ns.length - 1];
                        }
                        if ((clazz = class$0) == null) {
                            try {
                                clazz = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        bs = (IBinding[])ArrayUtil.append(clazz, bs, n.getBinding());
                    } else {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        bs = (IBinding[])ArrayUtil.append(clazz, bs, o);
                    }
                    ++i;
                }
                return CPPSemantics.resolveAmbiguities(name, bs);
            }
            if (obj instanceof IASTName) {
                IBinding binding = null;
                if (forceResolve && obj != name && obj != name.getParent()) {
                    binding = ((IASTName)obj).resolveBinding();
                } else {
                    IASTName n = (IASTName)obj;
                    if (n instanceof ICPPASTQualifiedName) {
                        IASTName[] ns = ((ICPPASTQualifiedName)n).getNames();
                        n = ns[ns.length - 1];
                    }
                    binding = n.getBinding();
                }
                if (binding instanceof ICPPUsingDeclaration) {
                    return CPPSemantics.resolveAmbiguities(name, ((ICPPUsingDeclaration)binding).getDelegates());
                }
                return binding;
            }
            return (IBinding)obj;
        }
        return null;
    }

    public void setFullyCached(boolean full) {
        this.isfull = full;
    }

    public boolean isFullyCached() {
        return this.isfull;
    }

    public void removeBinding(IBinding binding) {
        char[] key = binding.getNameCharArray();
        this.removeBinding(key, binding);
    }

    protected void removeBinding(char[] key, IBinding binding) {
        if (this.bindings == null || !this.bindings.containsKey(key)) {
            return;
        }
        Object obj = this.bindings.get(key);
        if (obj instanceof ObjectSet) {
            ObjectSet set = (ObjectSet)obj;
            int i = set.size() - 1;
            while (i > 0) {
                Object o = set.keyAt(i);
                if (o instanceof IBinding && o == binding || o instanceof IASTName && ((IASTName)o).getBinding() == binding) {
                    set.remove(o);
                }
                --i;
            }
            if (set.size() == 0) {
                this.bindings.remove(key, 0, key.length);
            }
        } else if (obj instanceof IBinding && obj == binding || obj instanceof IASTName && ((IASTName)obj).getBinding() == binding) {
            this.bindings.remove(key, 0, key.length);
        }
        this.isfull = false;
    }

    public IBinding[] find(String name) throws DOMException {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    public void flushCache() {
        this.isfull = false;
        if (this.bindings != null) {
            this.bindings.clear();
        }
    }

    public void addBinding(IBinding binding) {
        char[] c;
        Object o;
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if ((o = this.bindings.get(c = binding.getNameCharArray())) != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(binding);
            } else {
                ObjectSet set = new ObjectSet(2);
                set.put(o);
                set.put(binding);
                this.bindings.put(c, set);
            }
        } else {
            this.bindings.put(c, binding);
        }
    }

    public static class CPPScopeProblem
    extends ProblemBinding
    implements ICPPScope {
        public CPPScopeProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }
    }
}

