/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.KVStringPair;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SCDOptionsEnum;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CCommandDSC {
    private static final String SINGLE_SPACE = " ";
    private static final String CMD_DESCRIPTION_ELEM = "commandDescription";
    private static final String CMD_SI_ELEM = "commandScannerInfo";
    private static final String OPTION_ELEM = "option";
    private static final String SI_ITEM_ELEM = "siItem";
    private static final String KEY_ATTR = "key";
    private static final String VALUE_ATTR = "value";
    private static final String QUOTE_INCLUDE_ATTR = "quote";
    private static final String KIND_ATTR = "kind";
    private int commandId;
    private List compilerCommand = new ArrayList();
    private boolean discovered = false;
    private boolean cppFileType;
    private List symbols;
    private List includes;
    private List quoteIncludes;

    public CCommandDSC(boolean cppFileType) {
        this.cppFileType = cppFileType;
        this.symbols = new ArrayList();
        this.includes = new ArrayList();
        this.quoteIncludes = new ArrayList();
    }

    public boolean appliesToCPPFileType() {
        return this.cppFileType;
    }

    public void addSCOption(KVStringPair option) {
        this.compilerCommand.add(option);
    }

    public Integer getCommandIdAsInteger() {
        return new Integer(this.getCommandId());
    }

    public int getCommandId() {
        return this.commandId;
    }

    public void setCommandId(int commandId) {
        this.commandId = commandId;
    }

    public String toString() {
        String commandAsString = new String();
        Iterator i = this.compilerCommand.iterator();
        while (i.hasNext()) {
            KVStringPair optionPair = (KVStringPair)i.next();
            commandAsString = String.valueOf(commandAsString) + optionPair.getKey() + SINGLE_SPACE + optionPair.getValue() + SINGLE_SPACE;
        }
        return commandAsString.trim();
    }

    public int getId() {
        return this.commandId;
    }

    public String getSCDRunnableCommand(boolean quoteIncludePaths) {
        String commandAsString = new String();
        Iterator i = this.compilerCommand.iterator();
        while (i.hasNext()) {
            KVStringPair optionPair = (KVStringPair)i.next();
            if (optionPair.getKey().equals(SCDOptionsEnum.COMMAND.toString())) {
                commandAsString = String.valueOf(commandAsString) + optionPair.getValue() + SINGLE_SPACE;
                continue;
            }
            if (optionPair.getKey().equals(SCDOptionsEnum.IMACROS_FILE.toString()) || optionPair.getKey().equals(SCDOptionsEnum.INCLUDE_FILE.toString())) continue;
            if (quoteIncludePaths) {
                if (!optionPair.getKey().equals(SCDOptionsEnum.INCLUDE.toString())) continue;
                commandAsString = String.valueOf(commandAsString) + optionPair.getKey() + SINGLE_SPACE + "\"" + optionPair.getValue() + "\"" + SINGLE_SPACE;
                continue;
            }
            commandAsString = String.valueOf(commandAsString) + optionPair.getKey() + SINGLE_SPACE + optionPair.getValue() + SINGLE_SPACE;
        }
        return commandAsString.trim();
    }

    public List getImacrosFile() {
        ArrayList<String> imacrosFiles = new ArrayList<String>();
        Iterator i = this.compilerCommand.iterator();
        while (i.hasNext()) {
            KVStringPair optionPair = (KVStringPair)i.next();
            if (!optionPair.getKey().equals(SCDOptionsEnum.IMACROS_FILE.toString())) continue;
            imacrosFiles.add(optionPair.getValue());
        }
        return imacrosFiles;
    }

    public List getIncludeFile() {
        ArrayList<String> includeFiles = new ArrayList<String>();
        Iterator i = this.compilerCommand.iterator();
        while (i.hasNext()) {
            KVStringPair optionPair = (KVStringPair)i.next();
            if (!optionPair.getKey().equals(SCDOptionsEnum.INCLUDE_FILE.toString())) continue;
            includeFiles.add(optionPair.getValue());
        }
        return includeFiles;
    }

    public boolean equals(Object arg0) {
        if (arg0 != null && arg0.getClass().equals(this.getClass())) {
            CCommandDSC other = (CCommandDSC)arg0;
            return this.compilerCommand.equals(other.compilerCommand) && this.cppFileType == other.cppFileType;
        }
        return false;
    }

    public int hashCode() {
        return this.compilerCommand.hashCode();
    }

    public List getIncludes() {
        return this.includes;
    }

    public void setIncludes(List includes) {
        this.includes = includes;
    }

    public List getQuoteIncludes() {
        return this.quoteIncludes;
    }

    public void setQuoteIncludes(List includes) {
        this.quoteIncludes = includes;
    }

    public List getSymbols() {
        return this.symbols;
    }

    public void setSymbols(List symbols) {
        this.symbols = symbols;
    }

    public boolean isDiscovered() {
        return this.discovered;
    }

    public void setDiscovered(boolean discovered) {
        this.discovered = discovered;
    }

    public void serialize(Element cmdElem) {
        Element siItem;
        Document doc = cmdElem.getOwnerDocument();
        Element cmdDescElem = doc.createElement(CMD_DESCRIPTION_ELEM);
        Iterator i = this.compilerCommand.iterator();
        while (i.hasNext()) {
            Element optionElem = doc.createElement(OPTION_ELEM);
            KVStringPair option = (KVStringPair)i.next();
            optionElem.setAttribute(KEY_ATTR, option.getKey());
            optionElem.setAttribute(VALUE_ATTR, option.getValue());
            cmdDescElem.appendChild(optionElem);
        }
        cmdElem.appendChild(cmdDescElem);
        Element siElem = doc.createElement(CMD_SI_ELEM);
        Iterator j = this.quoteIncludes.iterator();
        while (j.hasNext()) {
            siItem = doc.createElement(SI_ITEM_ELEM);
            siItem.setAttribute(KIND_ATTR, "INCLUDE_PATH");
            siItem.setAttribute(VALUE_ATTR, (String)j.next());
            siItem.setAttribute(QUOTE_INCLUDE_ATTR, "true");
            siElem.appendChild(siItem);
        }
        j = this.includes.iterator();
        while (j.hasNext()) {
            siItem = doc.createElement(SI_ITEM_ELEM);
            siItem.setAttribute(KIND_ATTR, "INCLUDE_PATH");
            siItem.setAttribute(VALUE_ATTR, (String)j.next());
            siElem.appendChild(siItem);
        }
        j = this.symbols.iterator();
        while (j.hasNext()) {
            siItem = doc.createElement(SI_ITEM_ELEM);
            siItem.setAttribute(KIND_ATTR, "SYMBOL_DEFINITION");
            siItem.setAttribute(VALUE_ATTR, (String)j.next());
            siElem.appendChild(siItem);
        }
        cmdElem.appendChild(siElem);
    }

    public void deserialize(Element cmdElem) {
        NodeList siList;
        NodeList descList = cmdElem.getElementsByTagName(CMD_DESCRIPTION_ELEM);
        if (descList.getLength() > 0) {
            Element descElem = (Element)descList.item(0);
            NodeList optionList = descElem.getElementsByTagName(OPTION_ELEM);
            int i = 0;
            while (i < optionList.getLength()) {
                Element optionElem = (Element)optionList.item(i);
                String key = optionElem.getAttribute(KEY_ATTR);
                String value = optionElem.getAttribute(VALUE_ATTR);
                KVStringPair option = new KVStringPair(key, value);
                this.addSCOption(option);
                ++i;
            }
        }
        if ((siList = cmdElem.getElementsByTagName(CMD_SI_ELEM)).getLength() > 0) {
            Element siElem = (Element)siList.item(0);
            NodeList siItemList = siElem.getElementsByTagName(SI_ITEM_ELEM);
            int i = 0;
            while (i < siItemList.getLength()) {
                Element siItemElem = (Element)siItemList.item(i);
                String kind = siItemElem.getAttribute(KIND_ATTR);
                String value = siItemElem.getAttribute(VALUE_ATTR);
                String quote = siItemElem.getAttribute(QUOTE_INCLUDE_ATTR);
                if (kind.equals("INCLUDE_PATH")) {
                    if (quote.equals("true")) {
                        this.quoteIncludes.add(value);
                    } else {
                        this.includes.add(value);
                    }
                } else if (kind.equals("SYMBOL_DEFINITION")) {
                    this.symbols.add(value);
                }
                ++i;
            }
            this.setDiscovered(true);
        }
    }
}

