/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.List;
import org.eclipse.cdt.internal.corext.refactoring.base.Context;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatusEntry;
import org.eclipse.cdt.internal.ui.refactoring.IStatusContextViewer;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringStatusContentProvider;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringStatusEntryLabelProvider;
import org.eclipse.cdt.internal.ui.refactoring.StatusContextViewerDescriptor;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.util.ViewerPane;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.PageBook;

class RefactoringStatusViewer
extends SashForm {
    private RefactoringStatus fStatus;
    private TableViewer fTableViewer;
    private PageBook fContextViewerContainer;
    private ViewerPane fContextViewerPane;
    private Image fPaneImage;
    private StatusContextViewerDescriptor fCurrentDescriptor;
    private IStatusContextViewer fCurrentContextViewer;
    private NullContextViewer fNullContextViewer;
    private NextProblem fNextProblem;
    private PreviousProblem fPreviousProblem;
    static /* synthetic */ Class class$0;

    public RefactoringStatusViewer(Composite parent, int style) {
        super(parent, style | 0x200);
        this.createContents();
    }

    public void setStatus(RefactoringStatus status) {
        this.fStatus = status;
        if (this.fTableViewer.getInput() != this.fStatus) {
            RefactoringStatusEntry entry;
            this.fTableViewer.setInput((Object)this.fStatus);
            this.fTableViewer.getTable().getColumn(0).pack();
            ISelection selection = this.fTableViewer.getSelection();
            if (selection.isEmpty() && (entry = this.getFirstEntry()) != null) {
                this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)entry));
                this.showContextViewer(entry);
                this.fTableViewer.getControl().setFocus();
            }
            this.fNextProblem.update();
            this.fPreviousProblem.update();
        }
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        PixelConverter converter = new PixelConverter((Control)this);
        return new Point(converter.convertWidthInCharsToPixels(90), converter.convertHeightInCharsToPixels(25));
    }

    private void createContents() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        ViewerPane contextPane = new ViewerPane((Composite)this, 0x800800);
        contextPane.setText(RefactoringMessages.getString("RefactoringStatusViewer.Found_problems"));
        ToolBarManager tbm = contextPane.getToolBarManager();
        this.fNextProblem = new NextProblem();
        tbm.add((IAction)this.fNextProblem);
        this.fPreviousProblem = new PreviousProblem();
        tbm.add((IAction)this.fPreviousProblem);
        tbm.update(true);
        this.createTableViewer((Composite)contextPane);
        contextPane.setContent(this.fTableViewer.getControl());
        this.fContextViewerPane = new ViewerPane((Composite)this, 0x800800);
        this.fContextViewerContainer = new PageBook((Composite)this.fContextViewerPane, 0);
        this.fNullContextViewer = new NullContextViewer();
        this.fNullContextViewer.createControl((Composite)this.fContextViewerContainer);
        this.fContextViewerContainer.showPage(this.fNullContextViewer.getControl());
        this.fCurrentContextViewer = this.fNullContextViewer;
        this.fContextViewerPane.setContent((Control)this.fContextViewerContainer);
        this.fCurrentContextViewer = this.fNullContextViewer;
        this.fCurrentDescriptor = null;
        this.setWeights(new int[]{35, 65});
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (RefactoringStatusViewer.this.fPaneImage != null) {
                    RefactoringStatusViewer.this.fPaneImage.dispose();
                    RefactoringStatusViewer.this.fPaneImage = null;
                }
            }
        });
    }

    private void createTableViewer(Composite parent) {
        this.fTableViewer = new TableViewer(new Table(parent, 260));
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new RefactoringStatusEntryLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new RefactoringStatusContentProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RefactoringStatusViewer.this.entrySelected(event.getSelection());
                RefactoringStatusViewer.this.fNextProblem.update();
                RefactoringStatusViewer.this.fPreviousProblem.update();
            }
        });
        this.fTableViewer.setSorter((ViewerSorter)new RefactoringStatusSorter());
        Table tableControl = this.fTableViewer.getTable();
        GridData gd = new GridData(1808);
        tableControl.setLayoutData((Object)gd);
        TableColumn tc = new TableColumn(tableControl, 0);
        tc.setResizable(false);
    }

    private void entrySelected(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        Object first = ((IStructuredSelection)s).getFirstElement();
        if (!(first instanceof RefactoringStatusEntry)) {
            return;
        }
        RefactoringStatusEntry entry = (RefactoringStatusEntry)first;
        this.updateTitle(entry);
        this.showContextViewer(entry);
    }

    private void updateTitle(RefactoringStatusEntry first) {
        IAdaptable element = RefactoringStatusViewer.getCorrespondingElement(first);
        String title = null;
        ImageDescriptor imageDescriptor = null;
        if (element != null) {
            IWorkbenchAdapter adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IWorkbenchAdapter)element.getAdapter((Class)clazz)) != null) {
                title = adapter.getLabel((Object)element);
                imageDescriptor = adapter.getImageDescriptor((Object)element);
            }
        }
        if (title == null || title.length() == 0) {
            title = RefactoringMessages.getString("RefactoringStatusViewer.Problem_context");
        }
        this.fContextViewerPane.setText(title);
        if (imageDescriptor != null) {
            if (this.fPaneImage != null) {
                this.fPaneImage.dispose();
                this.fPaneImage = null;
            }
            this.fPaneImage = imageDescriptor.createImage((Device)this.fContextViewerPane.getDisplay());
            this.fContextViewerPane.setImage(this.fPaneImage);
        }
    }

    private static IAdaptable getCorrespondingElement(RefactoringStatusEntry first) {
        if (first.getContext() == null) {
            return null;
        }
        return first.getContext().getCorrespondingElement();
    }

    private void showContextViewer(RefactoringStatusEntry entry) {
    }

    private void showNullContextViewer() {
        this.fCurrentContextViewer = this.fNullContextViewer;
        this.fCurrentDescriptor = null;
        this.fContextViewerContainer.showPage(this.fCurrentContextViewer.getControl());
    }

    private RefactoringStatusEntry getFirstEntry() {
        if (this.fStatus == null || this.fStatus.getEntries().isEmpty()) {
            return null;
        }
        return (RefactoringStatusEntry)this.fStatus.getEntries().get(0);
    }

    private void revealElement(boolean next) {
        List entries = this.fStatus.getEntries();
        if (entries.isEmpty()) {
            return;
        }
        int index = this.fTableViewer.getTable().getSelectionIndex();
        int last = entries.size() - 1;
        boolean doIt = true;
        if (index == -1) {
            index = 0;
        } else if (next && index < last) {
            ++index;
        } else if (!next && index > 0) {
            --index;
        } else {
            doIt = false;
        }
        if (doIt) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(entries.get(index)));
        }
    }

    private static class NullContextViewer
    implements IStatusContextViewer {
        private Label fLabel;

        public void createControl(Composite parent) {
            this.fLabel = new Label(parent, 0x1800000);
            this.fLabel.setText(RefactoringMessages.getString("ErrorWizardPage.no_context_information_available"));
        }

        public void setInput(Context input) {
        }

        public Control getControl() {
            return this.fLabel;
        }
    }

    private class NextProblem
    extends Action {
        public NextProblem() {
            this.setImageDescriptor(CompareUI.DESC_ETOOL_NEXT);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_NEXT);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_NEXT);
            this.setToolTipText(RefactoringMessages.getString("ErrorWizardPage.next_Change"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.next_problem_action");
        }

        public void run() {
            RefactoringStatusViewer.this.revealElement(true);
        }

        public void update() {
            boolean enabled = false;
            List entries = null;
            if (RefactoringStatusViewer.this.fStatus != null && !(entries = RefactoringStatusViewer.this.fStatus.getEntries()).isEmpty()) {
                int index = RefactoringStatusViewer.this.fTableViewer.getTable().getSelectionIndex();
                enabled = index == -1 || index < entries.size() - 1;
            }
            this.setEnabled(enabled);
        }
    }

    private class PreviousProblem
    extends Action {
        public PreviousProblem() {
            this.setImageDescriptor(CompareUI.DESC_ETOOL_PREV);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_PREV);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_PREV);
            this.setToolTipText(RefactoringMessages.getString("ErrorWizardPage.previous_Change"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.previous_problem_action");
        }

        public void run() {
            RefactoringStatusViewer.this.revealElement(false);
        }

        public void update() {
            boolean enabled = false;
            if (RefactoringStatusViewer.this.fStatus != null && !RefactoringStatusViewer.this.fStatus.getEntries().isEmpty()) {
                int index = RefactoringStatusViewer.this.fTableViewer.getTable().getSelectionIndex();
                enabled = index == -1 || index > 0;
            }
            this.setEnabled(enabled);
        }
    }

    private static class RefactoringStatusSorter
    extends ViewerSorter {
        RefactoringStatusSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int r2;
            int r1 = ((RefactoringStatusEntry)e1).getSeverity();
            if (r1 < (r2 = ((RefactoringStatusEntry)e2).getSeverity())) {
                return 1;
            }
            if (r2 < r1) {
                return -1;
            }
            return 0;
        }
    }
}

