/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.cindexstorage.Index;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexInput;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IncludePattern
extends CSearchPattern {
    protected char[] simpleName;
    protected char[] decodedSimpleName;

    public IncludePattern(char[] name, int matchMode, ICSearchConstants.LimitTo limitTo, boolean caseSensitive) {
        super(matchMode, caseSensitive, limitTo);
        this.simpleName = name;
    }

    protected void decodeIndexEntry(IEntryResult entryResult) {
        this.decodedSimpleName = entryResult.getName().toCharArray();
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] fileRefs, int[][] offsets, int[][] offsetLengths, IndexInput input, ICSearchScope scope) throws IOException {
        int i = 0;
        int max = fileRefs.length;
        while (i < max) {
            IndexedFileEntry file = input.getIndexedFile(fileRefs[i]);
            String path = null;
            if (file != null && scope.encloses(path = file.getPath())) {
                requestor.acceptIncludeDeclaration(path, this.decodedSimpleName);
            }
            int j = 0;
            while (j < offsets[i].length) {
                BasicSearchMatch match = new BasicSearchMatch();
                match.setName(new String(this.decodedSimpleName));
                match.setLocatable(CSearchPattern.getMatchLocatable(offsets[i][j], offsetLengths[i][j]));
                match.setParentName("");
                match.setType(75);
                IFile tempFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
                if (tempFile != null && tempFile.exists()) {
                    match.setResource((IResource)tempFile);
                } else {
                    IPath tempPath = PathUtil.getWorkspaceRelativePath(file.getPath());
                    match.setPath(tempPath);
                    match.setReferringElement(tempPath);
                }
                requestor.acceptSearchMatch(match);
                ++j;
            }
            ++i;
        }
    }

    protected void resetIndexInfo() {
        this.decodedSimpleName = null;
    }

    public char[] indexEntryPrefix() {
        return Index.bestIncludePrefix(this._limitTo, this.simpleName, this._matchMode, this._caseSensitive);
    }

    protected boolean matchIndexEntry() {
        return this.simpleName == null || this.matchesName(this.simpleName, this.decodedSimpleName);
    }

    public int matchLevel(ISourceElementCallbackDelegate node, ICSearchConstants.LimitTo limit) {
        if (!(node instanceof IASTInclusion)) {
            return 0;
        }
        if (!this.canAccept(limit)) {
            return 0;
        }
        IASTInclusion inc = (IASTInclusion)node;
        String fileName = inc.getFullFileName();
        if (CharOperation.equals(this.simpleName, fileName.toCharArray(), this._caseSensitive)) {
            return 2;
        }
        return 0;
    }
}

