/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.actions;

import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConvertManagedBuildObject;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class ConvertTargetAction
extends ActionDelegate
implements IObjectActionDelegate {
    private String converterId = null;
    private String fromId = null;
    private String toId = null;
    private IConvertManagedBuildObject convertBuildObject = null;
    private IProject selectedProject = null;

    public static void initStartup() {
    }

    public void initConvertAction(IAction action) {
        this.convertBuildObject = null;
        String id = action.getId();
        try {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
            if (extensionPoint != null) {
                IExtension[] extensions = extensionPoint.getExtensions();
                new ArrayList(extensions.length);
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        String tmpConverterID;
                        IConfigurationElement element = configElements[j];
                        if (element.getName().equals("converter") && id.equals(tmpConverterID = element.getAttribute("id"))) {
                            this.convertBuildObject = (IConvertManagedBuildObject)element.createExecutableExtension("class");
                            this.fromId = element.getAttribute("fromId");
                            this.toId = element.getAttribute("toId");
                            return;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.initConvertAction(action);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object obj = sel.getFirstElement();
            if (obj instanceof IProject) {
                IProject project = (IProject)obj;
                this.setSelectedProject(project);
                try {
                    if (!project.hasNature("org.eclipse.cdt.managedbuilder.core.managedBuildNature")) {
                        action.setEnabled(false);
                        return;
                    }
                }
                catch (CoreException coreException) {}
                IProjectType projectType = this.getProjectType(project);
                if (this.isProjectConvertable(projectType)) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
            } else {
                action.setEnabled(false);
            }
        }
    }

    private IProjectType getProjectType(IProject project) {
        IProjectType projectType = null;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            IManagedProject managedProject = info.getManagedProject();
            projectType = managedProject.getProjectType();
        }
        return projectType;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isProjectConvertable(IProjectType projectType) {
        tmpProjectType = projectType;
        if (this.fromId != null) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            id = tmpProjectType.getId();
            if (this.fromId.equals(id)) {
                return true;
            }
            tmpProjectType = tmpProjectType.getSuperClass();
lbl8:
            // 2 sources

            ** while (tmpProjectType != null)
        }
lbl9:
        // 1 sources

        return false;
    }

    public void run(IAction action) {
        if (this.convertBuildObject != null) {
            Shell shell = ManagedBuilderUIPlugin.getDefault().getShell();
            boolean shouldConvert = MessageDialog.openQuestion((Shell)shell, (String)ManagedBuilderUIMessages.getResourceString("ProjectConvert.confirmdialog.title"), (String)ManagedBuilderUIMessages.getFormattedString("ProjectConvert.confirmdialog.message", new String[]{this.getSelectedProject().getName()}));
            if (shouldConvert) {
                this.convertBuildObject.convert((IBuildObject)this.getProjectType(this.getSelectedProject()), this.getFromId(), this.getToId(), true);
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private IConvertManagedBuildObject getConvertBuildObject() {
        return this.convertBuildObject;
    }

    private void setConvertBuildObject(IConvertManagedBuildObject convertBuildObject) {
        this.convertBuildObject = convertBuildObject;
    }

    private String getConverterId() {
        return this.converterId;
    }

    private void setConverterId(String converterId) {
        this.converterId = converterId;
    }

    private String getFromId() {
        return this.fromId;
    }

    private void setFromId(String fromId) {
        this.fromId = fromId;
    }

    private IProject getSelectedProject() {
        return this.selectedProject;
    }

    private void setSelectedProject(IProject selectedProject) {
        this.selectedProject = selectedProject;
    }

    private String getToId() {
        return this.toId;
    }

    private void setToId(String toId) {
        this.toId = toId;
    }
}

