/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.internal.ui.dialogs.SelectionStatusDialog;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BrowseEntryDialog
extends SelectionStatusDialog {
    private static final String PREFIX = "BuildPropertyCommon";
    private static final String LABEL = "BuildPropertyCommon.label";
    private static final String BROWSE = "BuildPropertyCommon.label.browse";
    private static final String HIDE = "hideAdvanced";
    private static final String SHOW = "showAdvanced";
    private static final String EMPTY = "NewFolderDialog.folderNameEmpty";
    private static final String ERROR_FOLDER_NAME_INVALID = "BuildPropertyCommon.error.Folder_name_invalid";
    private String title = "";
    private String message = "";
    private String folderName = "";
    private int basicShellHeight;
    private Button advancedButton = null;
    private Button browseButton = null;
    private Label errorMessageLabel;
    private Composite macroComposite;
    private Text text = null;

    public BrowseEntryDialog(Shell shell, String dialogTitle, String dialogMessage, String initialValue) {
        super(shell);
        if (dialogTitle != null) {
            this.title = dialogTitle;
        }
        if (dialogMessage != null) {
            this.message = dialogMessage;
        }
        if (initialValue != null) {
            this.folderName = initialValue;
        }
        this.setStatusLineAboveButtons(true);
    }

    protected void computeResult() {
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    private void createAdvancedBrowseArea(Composite parent) {
        this.advancedButton = new Button(parent, 8);
        Dialog.applyDialogFont((Control)this.advancedButton);
        this.advancedButton.setText(ManagedBuilderUIMessages.getResourceString(SHOW));
        this.setButtonLayoutData(this.advancedButton);
        GridData data = (GridData)this.advancedButton.getLayoutData();
        data.horizontalAlignment = 1;
        this.advancedButton.setLayoutData((Object)data);
        this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseEntryDialog.this.handleAdvancedPressed();
            }
        });
        this.advancedButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BrowseEntryDialog.this.advancedButton = null;
            }
        });
    }

    private void createBasicBrowseArea(Composite parent) {
        GridData data;
        Composite basicGroup = new Composite(parent, 0);
        basicGroup.setLayout((Layout)new GridLayout(2, false));
        basicGroup.setLayoutData((Object)new GridData(768));
        if (this.message != null) {
            Label label = new Label(basicGroup, 64);
            label.setText(this.message);
            data = new GridData(1794);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            data.horizontalSpan = 2;
            label.setLayoutData((Object)data);
            Dialog.applyDialogFont((Control)label);
        }
        this.text = new Text(basicGroup, 2052);
        data = new GridData(1808);
        data.widthHint = 200;
        this.text.setLayoutData((Object)data);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BrowseEntryDialog.this.validateLocation();
            }
        });
        Dialog.applyDialogFont((Control)this.text);
        this.browseButton = new Button(basicGroup, 8);
        Dialog.applyDialogFont((Control)this.browseButton);
        this.browseButton.setText(ManagedBuilderUIMessages.getResourceString(BROWSE));
        this.setButtonLayoutData(this.browseButton);
        data = (GridData)this.browseButton.getLayoutData();
        data.horizontalAlignment = 1;
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseEntryDialog.this.handleBrowsePressed();
            }
        });
        this.browseButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BrowseEntryDialog.this.browseButton = null;
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createBasicBrowseArea(composite);
        this.createAdvancedBrowseArea(composite);
        return composite;
    }

    public String getValue() {
        return this.folderName;
    }

    protected void handleAdvancedPressed() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        if (this.macroComposite == null) {
            this.basicShellHeight = shell.computeSize((int)-1, (int)-1, (boolean)true).y;
            Composite composite = (Composite)this.getDialogArea();
            this.macroComposite = ControlFactory.createComposite((Composite)composite, (int)1);
            shellSize = shell.computeSize(-1, -1, true);
            shell.setSize(shellSize);
            this.advancedButton.setText(ManagedBuilderUIMessages.getResourceString(HIDE));
        } else if (this.macroComposite.getVisible()) {
            this.macroComposite.setVisible(false);
            shell.setSize(shellSize.x, this.basicShellHeight);
            this.advancedButton.setText(ManagedBuilderUIMessages.getResourceString(SHOW));
        } else {
            this.macroComposite.setVisible(true);
            shellSize = shell.computeSize(-1, -1, true);
            shell.setSize(shellSize);
            this.advancedButton.setText(ManagedBuilderUIMessages.getResourceString(HIDE));
        }
    }

    protected void handleBrowsePressed() {
    }

    private void updateStatus(int severity, String message) {
        this.updateStatus((IStatus)new Status(severity, ManagedBuilderCorePlugin.getUniqueIdentifier(), severity, message, null));
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
    }

    protected void validateLocation() {
        this.folderName = this.text.getText();
        if (this.folderName == null || this.folderName.equals("")) {
            this.updateStatus(4, ManagedBuilderUIMessages.getResourceString(EMPTY));
            return;
        }
        Path path = new Path(this.folderName);
        if (!path.isValidPath(this.folderName)) {
            this.updateStatus(4, ManagedBuilderUIMessages.getResourceString(ERROR_FOLDER_NAME_INVALID));
            return;
        }
        this.updateStatus(0, "");
        this.getButton(0).setEnabled(true);
    }
}

