/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.modules;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.internal.ui.views.AbstractViewerState;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;

public class ModulesViewerState
extends AbstractViewerState {
    public ModulesViewerState(TreeViewer viewer) {
        super(viewer);
    }

    protected IPath encodeElement(TreeItem item) throws DebugException {
        String name = this.getTreeItemName(item);
        Path path = new Path(name);
        TreeItem parent = item.getParentItem();
        while (parent != null) {
            name = this.getTreeItemName(parent);
            path = new Path(name).append((IPath)path);
            parent = parent.getParentItem();
        }
        return path;
    }

    protected Object decodePath(IPath path, TreeViewer viewer) throws DebugException {
        ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        String[] names = path.segments();
        Object parent = viewer.getInput();
        Object element = null;
        int i = 0;
        while (i < names.length) {
            element = null;
            Object[] children = contentProvider.getChildren(parent);
            int j = 0;
            while (j < children.length) {
                String name = this.getElementName(children[j]);
                if (names[i].equals(name)) {
                    element = children[j];
                    break;
                }
                ++j;
            }
            if (element == null) {
                return null;
            }
            parent = element;
            ++i;
        }
        return element;
    }

    private String getTreeItemName(TreeItem item) {
        Object data = item.getData();
        String name = null;
        if (data instanceof ICModule) {
            name = ((ICModule)data).getName();
        } else if (data instanceof ICElement) {
            name = ((ICElement)data).getElementName();
        }
        return name;
    }

    private String getElementName(Object element) {
        if (element instanceof ICModule) {
            return ((ICModule)element).getName();
        }
        if (element instanceof ICElement) {
            return ((ICElement)element).getElementName();
        }
        return null;
    }
}

