/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.MemoryBlock;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataReadMemory;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryCreatedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataReadMemoryInfo;

public class MemoryManager
extends Manager {
    ICDIMemoryBlock[] EMPTY_MEMORY_BLOCKS = new ICDIMemoryBlock[0];
    Map blockMap = new Hashtable();

    public MemoryManager(Session session) {
        super(session, true);
    }

    synchronized List getMemoryBlockList(Target target) {
        List blockList = (List)this.blockMap.get(target);
        if (blockList == null) {
            blockList = Collections.synchronizedList(new ArrayList());
            this.blockMap.put(target, blockList);
        }
        return blockList;
    }

    public void update(Target target) {
        MISession miSession = target.getMISession();
        List blockList = this.getMemoryBlockList(target);
        MemoryBlock[] blocks = blockList.toArray(new MemoryBlock[blockList.size()]);
        ArrayList eventList = new ArrayList(blocks.length);
        int i = 0;
        while (i < blocks.length) {
            if (!blocks[i].isFrozen()) {
                try {
                    this.update(blocks[i], eventList);
                }
                catch (CDIException cDIException) {}
            }
            ++i;
        }
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        miSession.fireEvents(events);
    }

    public BigInteger[] update(MemoryBlock block, List aList) throws CDIException {
        Target target = (Target)block.getTarget();
        MISession miSession = target.getMISession();
        MemoryBlock newBlock = this.cloneBlock(block);
        boolean newAddress = !newBlock.getStartAddress().equals(block.getStartAddress());
        BigInteger[] array = this.compareBlocks(block, newBlock);
        block.setMIDataReadMemoryInfo(newBlock.getMIDataReadMemoryInfo());
        if (array.length > 0 || newAddress) {
            if (aList != null) {
                aList.add(new MIMemoryChangedEvent(miSession, array));
            } else {
                miSession.fireEvent(new MIMemoryChangedEvent(miSession, array));
            }
        }
        return array;
    }

    BigInteger[] compareBlocks(MemoryBlock oldBlock, MemoryBlock newBlock) throws CDIException {
        byte[] oldBytes = oldBlock.getBytes();
        byte[] newBytes = newBlock.getBytes();
        ArrayList<BigInteger> aList = new ArrayList<BigInteger>(newBytes.length);
        BigInteger distance = newBlock.getStartAddress().subtract(oldBlock.getStartAddress());
        int diff = distance.intValue();
        if (Math.abs(diff) < newBytes.length) {
            int i = 0;
            while (i < newBytes.length) {
                if (i + diff < oldBytes.length && i + diff >= 0 && oldBytes[i + diff] != newBytes[i]) {
                    aList.add(newBlock.getStartAddress().add(BigInteger.valueOf(i)));
                }
                ++i;
            }
        }
        return aList.toArray(new BigInteger[aList.size()]);
    }

    MemoryBlock cloneBlock(MemoryBlock block) throws CDIException {
        Target target = (Target)block.getTarget();
        String exp = block.getExpression();
        int wordSize = block.getWordSize();
        boolean little = target.isLittleEndian();
        MIDataReadMemoryInfo info = this.createMIDataReadMemoryInfo(target.getMISession(), exp, (int)block.getLength(), wordSize);
        return new MemoryBlock(target, exp, wordSize, little, info);
    }

    MIDataReadMemoryInfo createMIDataReadMemoryInfo(MISession miSession, String exp, int units, int wordSize) throws CDIException {
        CommandFactory factory = miSession.getCommandFactory();
        MIDataReadMemory mem = factory.createMIDataReadMemory(0L, exp, 0, wordSize, 1, units, null);
        try {
            miSession.postCommand(mem);
            MIDataReadMemoryInfo info = mem.getMIDataReadMemoryInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            return info;
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIMemoryBlock createMemoryBlock(Target target, String address, int units, int wordSize) throws CDIException {
        boolean little = target.isLittleEndian();
        MIDataReadMemoryInfo info = this.createMIDataReadMemoryInfo(target.getMISession(), address, units, wordSize);
        MemoryBlock block = new MemoryBlock(target, address, wordSize, little, info);
        List blockList = this.getMemoryBlockList(target);
        blockList.add(block);
        MISession miSession = target.getMISession();
        miSession.fireEvent(new MIMemoryCreatedEvent(miSession, block.getStartAddress(), block.getLength()));
        return block;
    }

    public MemoryBlock[] getMemoryBlocks(MISession miSession) {
        Session session = (Session)this.getSession();
        Target target = session.getTarget(miSession);
        List blockList = this.getMemoryBlockList(target);
        return blockList.toArray(new MemoryBlock[blockList.size()]);
    }

    public ICDIMemoryBlock[] getMemoryBlocks(Target target) throws CDIException {
        List blockList = this.getMemoryBlockList(target);
        return blockList.toArray(new ICDIMemoryBlock[blockList.size()]);
    }

    public void removeAllBlocks(Target target) throws CDIException {
        ICDIMemoryBlock[] blocks = this.getMemoryBlocks(target);
        this.removeBlocks(target, blocks);
    }

    public void removeBlocks(Target target, ICDIMemoryBlock[] memoryBlocks) throws CDIException {
        List blockList = (List)this.blockMap.get(target);
        if (blockList != null) {
            blockList.removeAll(Arrays.asList(memoryBlocks));
        }
    }
}

