/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core.scannerconfig;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.make.core.MakeScannerInfo;
import org.eclipse.cdt.make.core.scannerconfig.DiscoveredScannerInfoProvider;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class DiscoveredScannerInfo
implements IScannerInfo {
    private IProject project;
    private LinkedHashMap discoveredPaths;
    private LinkedHashMap discoveredSymbols;
    private ArrayList activePaths;
    private ArrayList removedPaths;
    private ArrayList activeSymbols;
    private ArrayList removedSymbols;
    private MakeScannerInfo userInfo;

    public DiscoveredScannerInfo(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public synchronized Map getDefinedSymbols() {
        Map dSymbols = ScannerConfigUtil.scSymbolEntryMap2Map(this.discoveredSymbols);
        dSymbols.putAll(this.userInfo.getDefinedSymbols());
        return dSymbols;
    }

    public synchronized String[] getIncludePaths() {
        String[] iPaths = new String[this.getUserIncludePaths().length + this.getActiveIncludePaths().length];
        System.arraycopy(this.getUserIncludePaths(), 0, iPaths, 0, this.getUserIncludePaths().length);
        System.arraycopy(this.getActiveIncludePaths(), 0, iPaths, this.getUserIncludePaths().length, this.getActiveIncludePaths().length);
        return iPaths;
    }

    public MakeScannerInfo getUserScannerInfo() {
        return this.userInfo;
    }

    public synchronized void setUserScannerInfo(MakeScannerInfo info) {
        this.userInfo = info;
    }

    public LinkedHashMap getDiscoveredIncludePaths() {
        if (this.discoveredPaths == null) {
            return new LinkedHashMap();
        }
        return new LinkedHashMap(this.discoveredPaths);
    }

    public synchronized void setDiscoveredIncludePaths(LinkedHashMap paths) {
        this.discoveredPaths = new LinkedHashMap(paths);
        this.createPathLists();
    }

    private void createPathLists() {
        List aPaths = this.getActivePathList();
        aPaths.clear();
        List rPaths = this.getRemovedPathList();
        rPaths.clear();
        Iterator i = this.discoveredPaths.keySet().iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            Boolean removed = (Boolean)this.discoveredPaths.get(path);
            if (removed == null || !removed.booleanValue()) {
                aPaths.add(path);
                continue;
            }
            rPaths.add(path);
        }
    }

    public LinkedHashMap getDiscoveredSymbolDefinitions() {
        if (this.discoveredSymbols == null) {
            return new LinkedHashMap();
        }
        return new LinkedHashMap(this.discoveredSymbols);
    }

    public synchronized void setDiscoveredSymbolDefinitions(LinkedHashMap symbols) {
        this.discoveredSymbols = new LinkedHashMap(symbols);
        this.createSymbolsLists();
    }

    private void createSymbolsLists() {
        List aSymbols = this.getActiveSymbolsList();
        aSymbols.clear();
        List rSymbols = this.getRemovedSymbolsList();
        rSymbols.clear();
        aSymbols.addAll(ScannerConfigUtil.scSymbolsSymbolEntryMap2List(this.discoveredSymbols, true));
        rSymbols.addAll(ScannerConfigUtil.scSymbolsSymbolEntryMap2List(this.discoveredSymbols, false));
    }

    public String[] getUserIncludePaths() {
        if (this.userInfo == null) {
            return new String[0];
        }
        return this.userInfo.getIncludePaths();
    }

    public String[] getActiveIncludePaths() {
        return this.getActivePathList().toArray(new String[this.getActivePathList().size()]);
    }

    public String[] getRemovedIncludePaths() {
        return this.getRemovedPathList().toArray(new String[this.getRemovedPathList().size()]);
    }

    public String[] getUserSymbolDefinitions() {
        if (this.userInfo == null) {
            return new String[0];
        }
        return this.userInfo.getPreprocessorSymbols();
    }

    public String[] getActiveSymbolDefinitions() {
        return this.getActiveSymbolsList().toArray(new String[this.getActiveSymbolsList().size()]);
    }

    public String[] getRemovedSymbolDefinitions() {
        return this.getRemovedSymbolsList().toArray(new String[this.getRemovedSymbolsList().size()]);
    }

    public String[] getPreprocessorSymbols() {
        String[] userSymbols = this.getUserSymbolDefinitions();
        String[] discActiveSymbols = this.getActiveSymbolDefinitions();
        String[] rv = new String[userSymbols.length + discActiveSymbols.length];
        System.arraycopy(userSymbols, 0, rv, 0, userSymbols.length);
        System.arraycopy(discActiveSymbols, 0, rv, userSymbols.length, discActiveSymbols.length);
        return rv;
    }

    private List getActivePathList() {
        if (this.activePaths == null) {
            this.activePaths = new ArrayList();
        }
        return this.activePaths;
    }

    private List getRemovedPathList() {
        if (this.removedPaths == null) {
            this.removedPaths = new ArrayList();
        }
        return this.removedPaths;
    }

    private List getActiveSymbolsList() {
        if (this.activeSymbols == null) {
            this.activeSymbols = new ArrayList();
        }
        return this.activeSymbols;
    }

    private List getRemovedSymbolsList() {
        if (this.removedSymbols == null) {
            this.removedSymbols = new ArrayList();
        }
        return this.removedSymbols;
    }

    public void update() throws CoreException {
        DiscoveredScannerInfoProvider.updateScannerInfo(this);
    }

    public void setUserIncludePaths(List userPaths) {
        this.userInfo.setIncludePaths(userPaths.toArray(new String[userPaths.size()]));
    }

    public void setUserDefinedSymbols(List userSymbols) {
        this.userInfo.setPreprocessorSymbols(userSymbols.toArray(new String[userSymbols.size()]));
    }
}

