/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class AbstractGCCBOPConsoleParserUtility {
    private IProject project;
    private IPath fBaseDirectory;
    private Vector fDirectoryStack = new Vector();
    private IMarkerGenerator fMarkerGenerator;
    private ArrayList fErrors = new ArrayList();

    public AbstractGCCBOPConsoleParserUtility(IProject project, IPath workingDirectory, IMarkerGenerator markerGenerator) {
        this.project = project;
        this.fBaseDirectory = project.getLocation();
        if (workingDirectory != null) {
            this.pushDirectory(workingDirectory);
        }
    }

    protected IPath getBaseDirectory() {
        return this.fBaseDirectory;
    }

    protected Vector getDirectoryStack() {
        return this.fDirectoryStack;
    }

    protected ArrayList getErrors() {
        return this.fErrors;
    }

    protected IMarkerGenerator getMarkerGenerator() {
        return this.fMarkerGenerator;
    }

    protected IProject getProject() {
        return this.project;
    }

    public IPath getWorkingDirectory() {
        if (this.fDirectoryStack.size() != 0) {
            return (IPath)this.fDirectoryStack.lastElement();
        }
        return this.fBaseDirectory;
    }

    protected void pushDirectory(IPath dir) {
        if (dir != null) {
            IPath pwd = null;
            if (this.fBaseDirectory.isPrefixOf(dir)) {
                pwd = dir.removeFirstSegments(this.fBaseDirectory.segmentCount());
            } else if (dir.toString().startsWith("/cygdrive/")) {
                char driveLetter = dir.toString().charAt(10);
                driveLetter = Character.isLowerCase(driveLetter) ? Character.toUpperCase(driveLetter) : driveLetter;
                StringBuffer buf = new StringBuffer();
                buf.append(driveLetter);
                buf.append(':');
                String drive = buf.toString();
                pwd = dir.removeFirstSegments(2);
                pwd = pwd.setDevice(drive);
                pwd = pwd.makeAbsolute();
            } else {
                pwd = dir;
            }
            this.fDirectoryStack.addElement(pwd);
        }
    }

    protected IPath popDirectory() {
        int i = this.getDirectoryLevel();
        if (i != 0) {
            IPath dir = (IPath)this.fDirectoryStack.lastElement();
            this.fDirectoryStack.removeElementAt(i - 1);
            return dir;
        }
        return new Path("");
    }

    protected int getDirectoryLevel() {
        return this.fDirectoryStack.size();
    }

    public void changeMakeDirectory(String dir, int dirLevel, boolean enterDir) {
        if (enterDir) {
            int parseLevel = this.getDirectoryLevel();
            while (dirLevel < parseLevel) {
                this.popDirectory();
                parseLevel = this.getDirectoryLevel();
            }
            this.pushDirectory((IPath)new Path(dir));
        } else {
            this.popDirectory();
        }
    }

    public boolean reportProblems() {
        boolean reset = false;
        Iterator iter = this.fErrors.iterator();
        while (iter.hasNext()) {
            Problem problem = (Problem)iter.next();
            if (problem.severity == 3) {
                reset = true;
            }
            if (problem.file == null) {
                this.fMarkerGenerator.addMarker((IResource)this.project, problem.lineNumber, problem.description, problem.severity, problem.variableName);
                continue;
            }
            this.fMarkerGenerator.addMarker(problem.file, problem.lineNumber, problem.description, problem.severity, problem.variableName);
        }
        this.fErrors.clear();
        return reset;
    }

    public void generateMarker(IResource file, int lineNumber, String desc, int severity, String varName) {
        if (this.fMarkerGenerator != null) {
            Problem problem = new Problem(file, lineNumber, desc, severity, varName);
            this.fErrors.add(problem);
        }
    }

    protected class Problem {
        protected IResource file;
        protected int lineNumber;
        protected String description;
        protected int severity;
        protected String variableName;

        public Problem(IResource file, int lineNumber, String desciption, int severity, String variableName) {
            this.file = file;
            this.lineNumber = lineNumber;
            this.description = desciption;
            this.severity = severity;
            this.variableName = variableName;
        }
    }
}

