/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.io.FileNotFoundException;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStatusHandler;

public class LocalAttachLaunchDelegate
extends AbstractCLaunchDelegate {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IBinaryParser.IBinaryObject exeFile = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(LaunchMessages.getString("LocalAttachLaunchDelegate.Attaching_to_Local_C_Application"), 10);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            monitor.worked(1);
            ICProject cproject = this.verifyCProject(config);
            IPath exePath = AbstractCLaunchDelegate.getProgramPath(config);
            if (exePath != null && !exePath.isEmpty()) {
                if (!exePath.isAbsolute()) {
                    IFile wsProgramPath = cproject.getProject().getFile(exePath);
                    exePath = wsProgramPath.getLocation();
                }
                if (!exePath.toFile().exists()) {
                    this.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_file_does_not_exist"), new FileNotFoundException(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.PROGRAM_PATH_not_found", exePath.toOSString())), 104);
                }
                exeFile = this.verifyBinary(cproject, exePath);
            }
            if (mode.equals("debug")) {
                ICDebugConfiguration debugConfig = this.getDebugConfig(config);
                ICDISession dsession = null;
                String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
                if (debugMode.equals("attach")) {
                    if (config.getAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", -1) == -1) {
                        int pid = this.promptForProcessID(config);
                        if (pid == -1) {
                            this.cancel(LaunchMessages.getString("LocalAttachLaunchDelegate.No_Process_ID_selected"), 107);
                        }
                        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                        wc.setAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", pid);
                        wc.launch(mode, (IProgressMonitor)new SubProgressMonitor(monitor, 9));
                        wc.setAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", null);
                        this.cancel("", -1);
                    } else {
                        dsession = debugConfig.createDebugger().createDebuggerSession(launch, exeFile, (IProgressMonitor)new SubProgressMonitor(monitor, 8));
                        try {
                            this.setDefaultSourceLocator(launch, config);
                            ICDITarget[] targets = dsession.getTargets();
                            int i = 0;
                            while (i < targets.length) {
                                CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)cproject.getProject(), (ICDITarget)targets[i], (String)this.renderTargetLabel(debugConfig), null, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)true, (boolean)false);
                                ++i;
                            }
                        }
                        catch (CoreException e) {
                            try {
                                dsession.terminate();
                                throw e;
                            }
                            catch (CDIException cDIException) {}
                            throw e;
                        }
                    }
                }
            }
            Object var13_18 = null;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected int promptForProcessID(ILaunchConfiguration config) throws CoreException {
        Object result;
        Status fPromptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
        Status processPrompt = new Status(1, "org.eclipse.cdt.launch", 100, "", null);
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)fPromptStatus);
        if (prompter != null && (result = prompter.handleStatus((IStatus)processPrompt, (Object)config)) instanceof Integer) {
            return (Integer)result;
        }
        return -1;
    }

    protected String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }
}

