/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeCacheChangedListener;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.IWorkingCopyProvider;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.TypeCache;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheDelta;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheMessages;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacherJob;
import org.eclipse.cdt.internal.core.browser.cache.TypeLocatorJob;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;

public class TypeCacheManager
implements ITypeCacheChangedListener,
IndexManager.IIndexerSelectionListener {
    private static final TypeCacheManager fgInstance = new TypeCacheManager();
    private Map fCacheMap;
    private IWorkingCopyProvider fWorkingCopyProvider;
    private ArrayList fChangeListeners = new ArrayList();
    private static final int INITIAL_TYPE_MAP_SIZE = 50;
    private Map fTypeToElementMap = new HashMap(50);
    private Map fElementToTypeMap = new HashMap(50);
    private boolean processTypeCacheEvents = true;
    private static final int PATH_ENTRY_FLAGS = 265984;

    private TypeCacheManager() {
        this.fCacheMap = new HashMap();
        CModelManager.getDefault().getIndexManager().subscribeForIndexerChangeNotifications(this);
    }

    public static TypeCacheManager getInstance() {
        return fgInstance;
    }

    protected void finalize() throws Throwable {
        CModelManager.getDefault().getIndexManager().unSubscribeForIndexerChangeNotifications(this);
        super.finalize();
    }

    public void setWorkingCopyProvider(IWorkingCopyProvider workingCopyProvider) {
        this.fWorkingCopyProvider = workingCopyProvider;
    }

    public synchronized void updateProject(IProject project) {
        this.fTypeToElementMap.clear();
        this.fElementToTypeMap.clear();
        this.addCacheDelta(project, null);
    }

    public synchronized void processElementChanged(ElementChangedEvent event, boolean enableIndexing) {
        int deltaCount = this.processDelta(event.getDelta());
        if (deltaCount > 0) {
            this.fTypeToElementMap.clear();
            this.fElementToTypeMap.clear();
            this.reconcile(enableIndexing, 40, 0);
        }
    }

    private int processDelta(ICElementDelta delta) {
        ICElementDelta[] children;
        ICElement elem = delta.getElement();
        boolean added = delta.getKind() == 1;
        boolean removed = delta.getKind() == 2;
        boolean contentChanged = (delta.getFlags() & 1) != 0;
        boolean pathEntryChanged = (delta.getFlags() & 0x40F00) != 0;
        boolean openedOrClosed = (delta.getFlags() & 0x80) != 0 || (delta.getFlags() & 0x40) != 0;
        boolean hasChildren = (delta.getFlags() & 8) != 0;
        int deltaCount = 0;
        switch (elem.getElementType()) {
            case 11: 
            case 12: {
                ICProject cProject = elem.getCProject();
                IProject project = cProject.getProject();
                if (!added && !removed && !pathEntryChanged && !openedOrClosed) break;
                this.addCacheDelta(project, delta);
                ++deltaCount;
                break;
            }
            case 60: {
                ICProject cProject = elem.getCProject();
                IProject project = cProject.getProject();
                ITranslationUnit unit = (ITranslationUnit)elem;
                if (unit.isWorkingCopy()) {
                    return deltaCount += this.processWorkingCopyDelta(delta);
                }
                if (!added && !removed && !pathEntryChanged && !contentChanged) break;
                this.addCacheDelta(project, delta);
                ++deltaCount;
                break;
            }
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 75: 
            case 80: 
            case 83: {
                ICProject cProject = elem.getCProject();
                IProject project = cProject.getProject();
                if (!added && !removed) break;
                this.addCacheDelta(project, delta);
                ++deltaCount;
            }
        }
        if (hasChildren && (children = delta.getAffectedChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                deltaCount += this.processDelta(children[i]);
                ++i;
            }
        }
        return deltaCount;
    }

    private void addCacheDelta(IProject project, ICElementDelta delta) {
        if (delta == null) {
            this.getCache(project).addDelta(new TypeCacheDelta(project));
        } else {
            this.getCache(project).addDelta(new TypeCacheDelta(project, delta));
        }
    }

    private int processWorkingCopyDelta(ICElementDelta delta) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ITypeCache getCache(IProject project) {
        Map map = this.fCacheMap;
        synchronized (map) {
            ITypeCache cache = (ITypeCache)this.fCacheMap.get(project);
            if (cache == null) {
                cache = new TypeCache(project, this.fWorkingCopyProvider, this);
                this.fCacheMap.put(project, cache);
            }
            return cache;
        }
    }

    public synchronized void reconcile(boolean enableIndexing, int priority, int delay) {
        if (!this.processTypeCacheEvents) {
            return;
        }
        TypeSearchScope workspaceScope = new TypeSearchScope(true);
        IProject[] projects = workspaceScope.getEnclosingProjects();
        int i = 0;
        while (i < projects.length) {
            ITypeCache cache = this.getCache(projects[i]);
            cache.reconcile(enableIndexing, priority, delay);
            ++i;
        }
    }

    public synchronized void reconcileAndWait(boolean enableIndexing, int priority, IProgressMonitor monitor) {
        if (!this.processTypeCacheEvents) {
            return;
        }
        TypeSearchScope workspaceScope = new TypeSearchScope(true);
        IProject[] projects = workspaceScope.getEnclosingProjects();
        int i = 0;
        while (i < projects.length) {
            ITypeCache cache = this.getCache(projects[i]);
            cache.reconcileAndWait(enableIndexing, priority, monitor);
            ++i;
        }
    }

    public void cancelJobs() {
        IJobManager jobManager = Platform.getJobManager();
        jobManager.cancel(TypeCacherJob.FAMILY);
        jobManager.cancel(TypeLocatorJob.FAMILY);
    }

    public ITypeInfo[] locateSuperTypesAndWait(ITypeInfo info, boolean enableIndexing, int priority, IProgressMonitor monitor) {
        ITypeInfo[] superTypes = info.getSuperTypes();
        if (superTypes == null) {
            IProject project = info.getEnclosingProject();
            this.getCache(project).cancelJobs();
            this.getCache(project).locateSupertypesAndWait(info, priority, monitor);
            superTypes = info.getSuperTypes();
            this.reconcile(enableIndexing, 40, 0);
        }
        return superTypes;
    }

    public ITypeInfo[] locateSubTypesAndWait(ITypeInfo info, boolean enableIndexing, int priority, IProgressMonitor monitor) {
        ITypeInfo[] subTypes = info.getSubTypes();
        if (subTypes == null) {
            IProject project = info.getEnclosingProject();
            this.getCache(project).cancelJobs();
            this.getCache(project).locateSubtypesAndWait(info, priority, monitor);
            subTypes = info.getSubTypes();
            this.reconcile(enableIndexing, 40, 0);
        }
        return subTypes;
    }

    public void updateCache(ITypeSearchScope scope, IProgressMonitor monitor) {
        IProject[] projects = scope.getEnclosingProjects();
        monitor.beginTask(TypeCacheMessages.getString("AllTypesCache.updateCache.taskName"), projects.length);
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            this.getCache(project).reconcileAndWait(true, 20, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ++i;
        }
        monitor.done();
    }

    public ITypeReference resolveTypeLocation(ITypeInfo info, IProgressMonitor monitor, boolean enableIndexing) {
        ITypeReference location = info.getResolvedReference();
        if (location == null) {
            IProject project = info.getEnclosingProject();
            ITypeCache cache = this.getCache(project);
            cache.cancelJobs();
            cache.locateTypeAndWait(info, 20, monitor);
            location = info.getResolvedReference();
            this.reconcile(enableIndexing, 40, 0);
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypeCacheChangedListener(ITypeCacheChangedListener listener) {
        ArrayList arrayList = this.fChangeListeners;
        synchronized (arrayList) {
            if (!this.fChangeListeners.contains(listener)) {
                this.fChangeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTypeCacheChangedListener(ITypeCacheChangedListener listener) {
        ArrayList arrayList = this.fChangeListeners;
        synchronized (arrayList) {
            this.fChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void typeCacheChanged(final IProject project) {
        ArrayList listeners;
        ArrayList arrayList = this.fChangeListeners;
        synchronized (arrayList) {
            listeners = (ArrayList)this.fChangeListeners.clone();
        }
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            final ITypeCacheChangedListener listener = (ITypeCacheChangedListener)i.next();
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    Status status = new Status(4, "org.eclipse.cdt.core", 4, "Exception occurred in listener of type cache change notification", e);
                    CCorePlugin.log((IStatus)status);
                }

                public void run() throws Exception {
                    listener.typeCacheChanged(project);
                }
            });
        }
    }

    public ITypeInfo getTypeForElement(ICElement element, boolean forceUpdate, boolean forceResolve, boolean enableIndexing, IProgressMonitor monitor) {
        ITypeInfo cachedInfo;
        if (element.exists() && (cachedInfo = (ITypeInfo)this.fElementToTypeMap.get(element)) != null && cachedInfo.exists()) {
            return cachedInfo;
        }
        IQualifiedTypeName qualifiedName = TypeUtil.getFullyQualifiedName(element);
        if (qualifiedName != null) {
            ITypeInfo info;
            ICProject cProject = element.getCProject();
            IProject project = cProject.getProject();
            ITypeCache cache = this.getCache(project);
            if (!cache.isUpToDate() && forceUpdate) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                cache.reconcileAndWait(true, 20, monitor);
            }
            if ((info = cache.getType(element.getElementType(), qualifiedName)) != null) {
                ITypeReference ref = info.getResolvedReference();
                if (ref == null && forceResolve) {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    ref = this.resolveTypeLocation(info, monitor, enableIndexing);
                }
                this.fElementToTypeMap.put(element, info);
                return info;
            }
        }
        return null;
    }

    public ICElement getElementForType(ITypeInfo type, boolean forceUpdate, boolean forceResolve, boolean enableIndexing, IProgressMonitor monitor) {
        ICElement[] elems;
        ITypeReference ref;
        ICElement cachedElem;
        if (type.exists() && (cachedElem = (ICElement)this.fTypeToElementMap.get(type)) != null && cachedElem.exists()) {
            return cachedElem;
        }
        IProject project = type.getEnclosingProject();
        ITypeCache cache = this.getCache(project);
        if (!cache.isUpToDate() && forceUpdate) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            cache.reconcileAndWait(true, 20, monitor);
        }
        if ((ref = type.getResolvedReference()) == null && forceResolve) {
            ref = this.resolveTypeLocation(type, monitor, enableIndexing);
        }
        if (ref != null && (elems = ref.getCElements()) != null && elems.length > 0) {
            ICElement foundElem = elems[0];
            if (elems.length > 1) {
                int i = 0;
                while (i < elems.length) {
                    ICElement elem = elems[i];
                    if (elem.getElementType() == type.getCElementType() && elem.getElementName().equals(type.getName())) {
                        foundElem = elem;
                        break;
                    }
                    ++i;
                }
            }
            if (foundElem != null) {
                this.fTypeToElementMap.put(type, foundElem);
                return foundElem;
            }
        }
        return null;
    }

    public boolean getProcessTypeCacheEvents() {
        return this.processTypeCacheEvents;
    }

    public void setProcessTypeCacheEvents(boolean processTypeCacheEvents) {
        this.processTypeCacheEvents = processTypeCacheEvents;
    }

    public void indexerSelectionChanged(IProject project) {
        this.addCacheDelta(project, null);
    }
}

