/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;
import org.eclipse.cdt.managedbuilder.internal.envvar.DefaultContextInfo;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarCollector;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarDescriptor;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarOperationProcessor;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.IContextInfo;
import org.eclipse.cdt.managedbuilder.internal.envvar.UserDefinedEnvironmentSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.EclipseVariablesMacroSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.eclipse.cdt.managedbuilder.internal.ui.MacrosSetBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuildOptionBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.NewEnvVarDialog;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroStatus;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildPreferencePage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildPropertyPage;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class EnvironmentBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "EnvironmentBlock";
    private static final String LABEL = "EnvironmentBlock.label";
    private static final String USER_VAR = "EnvironmentBlock.label.user.var";
    private static final String SYSTEM_VAR = "EnvironmentBlock.label.system.var";
    private static final String HEADER = "EnvironmentBlock.label.header";
    private static final String HEADER_NAME = "EnvironmentBlock.label.header.name";
    private static final String HEADER_VALUE = "EnvironmentBlock.label.header.value";
    private static final String BUTTON = "EnvironmentBlock.label.button";
    private static final String BUTTON_NEW = "EnvironmentBlock.label.button.new";
    private static final String BUTTON_EDIT = "EnvironmentBlock.label.button.edit";
    private static final String BUTTON_DELETE = "EnvironmentBlock.label.button.delete";
    private static final String BUTTON_UNDEF = "EnvironmentBlock.label.button.undef";
    private static final String BUTTON_CHECK_SHOW_PARENT = "EnvironmentBlock.label.button.check.chow.parent";
    private static final String VALUE_UNDEF = "EnvironmentBlock.label.value.undef";
    private static final String DELETE_CONFIRM_TITLE = "EnvironmentBlock.label.delete.confirm.title";
    private static final String DELETE_CONFIRM_MESSAGE = "EnvironmentBlock.label.delete.confirm.message";
    private static final String DELETE_ALL_CONFIRM_TITLE = "EnvironmentBlock.label.delete.all.confirm.title";
    private static final String DELETE_ALL_CONFIRM_MESSAGE = "EnvironmentBlock.label.delete.all.confirm.message";
    private static final String[] fHiddenVariables = new String[]{EnvVarOperationProcessor.normalizeName((String)"CWD"), EnvVarOperationProcessor.normalizeName((String)"PWD")};
    private static final int IDX_BUTTON_NEW = 0;
    private static final int IDX_BUTTON_EDIT = 1;
    private static final int IDX_BUTTON_UNDEF = 2;
    private static final int IDX_BUTTON_DELETE = 3;
    private HashSet fDeletedUserVariableNames;
    private Map fAddedUserVariables;
    private boolean fDeleteAll = false;
    private boolean fModified = false;
    private boolean fShowParentViewCheckBox = true;
    private boolean fIsEditable = true;
    private static final Object fInexistentContext = new Object();
    private Object fContext = fInexistentContext;
    private boolean fShowParentVariables = false;
    private IContextInfo fSystemContextInfo;
    private IContextInfo fCurrentContextInfo;
    private IContextInfo fParentContextInfo;
    private boolean fUseDefaultParentContextInfo = true;
    private UserDefinedEnvironmentSupplier fUserSupplier;
    private TableViewer fEditableTable;
    private TableViewer fNonEditableTable;
    private static final String[] fEditableTableColumnProps = new String[]{"editable name", "editable value"};
    private static final String[] fNonEditableTableColumnProps = new String[]{"noneditable name", "noneditable value"};
    private static final String[] fTableColumnNames = new String[]{ManagedBuilderUIMessages.getResourceString("EnvironmentBlock.label.header.name"), ManagedBuilderUIMessages.getResourceString("EnvironmentBlock.label.header.value")};
    private static final ColumnLayoutData[] fTableColumnLayouts = new ColumnLayoutData[]{new ColumnPixelData(150), new ColumnPixelData(250)};
    private Set fIncorrectlyDefinedVariablesNames = new HashSet();
    private Button fShowParentButton;
    private Composite fParent;
    private Label fStatusLabel;
    private Button fNewButton;
    private Button fEditButton;
    private Button fUndefButton;
    private Button fDeleteButton;

    public EnvironmentBlock(ICOptionContainer parent, String title, boolean editable, boolean showParentViewCheckBox) {
        super(title);
        super.setContainer(parent);
        this.fIsEditable = editable;
        this.fShowParentViewCheckBox = showParentViewCheckBox;
    }

    private Map getUserVariables() {
        HashMap<String, IBuildEnvironmentVariable> map = new HashMap<String, IBuildEnvironmentVariable>();
        if (this.fUserSupplier != null && !this.fDeleteAll) {
            IBuildEnvironmentVariable[] vars = this.fUserSupplier.getVariables(this.fContext);
            if (vars != null) {
                int i = 0;
                while (i < vars.length) {
                    String name = vars[i].getName();
                    if (!ManagedBuildManager.getEnvironmentVariableProvider().isVariableCaseSensitive()) {
                        name = name.toUpperCase();
                    }
                    map.put(name, vars[i]);
                    ++i;
                }
            }
            Iterator<Object> iter = this.getDeletedUserVariableNames().iterator();
            while (iter.hasNext()) {
                map.remove((String)iter.next());
            }
            iter = this.getAddedUserVariables().values().iterator();
            while (iter.hasNext()) {
                IBuildEnvironmentVariable var = (IBuildEnvironmentVariable)iter.next();
                String name = var.getName();
                if (!ManagedBuildManager.getEnvironmentVariableProvider().isVariableCaseSensitive()) {
                    name = name.toUpperCase();
                }
                map.put(name, var);
            }
        }
        return map;
    }

    private HashSet getDeletedUserVariableNames() {
        if (this.fDeletedUserVariableNames == null) {
            this.fDeletedUserVariableNames = new HashSet();
        }
        return this.fDeletedUserVariableNames;
    }

    private Map getAddedUserVariables() {
        if (this.fAddedUserVariables == null) {
            this.fAddedUserVariables = new HashMap();
        }
        return this.fAddedUserVariables;
    }

    private void addUserVariable(String name, String value, int op, String delimiter) {
        if (!this.canCreate(name)) {
            return;
        }
        this.fDeleteAll = false;
        BuildEnvVar newVar = new BuildEnvVar(name, value, op, delimiter);
        if (!ManagedBuildManager.getEnvironmentVariableProvider().isVariableCaseSensitive()) {
            name = name.toUpperCase();
        }
        this.getDeletedUserVariableNames().remove(name);
        this.getAddedUserVariables().put(name, newVar);
        this.fModified = true;
    }

    private void deleteUserVariable(String name) {
        this.fDeleteAll = false;
        if (!ManagedBuildManager.getEnvironmentVariableProvider().isVariableCaseSensitive()) {
            name = name.toUpperCase();
        }
        this.getAddedUserVariables().remove(name);
        this.getDeletedUserVariableNames().add(name);
        this.fModified = true;
    }

    private void deleteAllUserVariables() {
        this.fDeleteAll = true;
        this.getDeletedUserVariableNames().clear();
        this.getAddedUserVariables().clear();
        this.fModified = true;
    }

    public boolean isModified() {
        return this.fModified;
    }

    public void setModified(boolean modified) {
        this.fModified = modified;
    }

    private IBuildEnvironmentVariable getUserVariable(String name) {
        Map vars = this.getUserVariables();
        if (vars == null) {
            return null;
        }
        if (!ManagedBuildManager.getEnvironmentVariableProvider().isVariableCaseSensitive()) {
            name = name.toUpperCase();
        }
        return (IBuildEnvironmentVariable)vars.get(name);
    }

    private void applyUserVariables() {
        if (this.fUserSupplier != null) {
            if (this.fDeleteAll) {
                this.fUserSupplier.deleteAll(this.fContext);
            } else {
                Iterator<Object> iter = this.getDeletedUserVariableNames().iterator();
                while (iter.hasNext()) {
                    this.fUserSupplier.deleteVariable((String)iter.next(), this.fContext);
                }
                iter = this.getAddedUserVariables().values().iterator();
                while (iter.hasNext()) {
                    IBuildEnvironmentVariable var = (IBuildEnvironmentVariable)iter.next();
                    this.fUserSupplier.createVariable(var.getName(), var.getValue(), var.getOperation(), var.getDelimiter(), this.fContext);
                }
                this.getDeletedUserVariableNames().clear();
                this.getAddedUserVariables().clear();
            }
        }
    }

    private void storeUserVariables() {
        this.applyUserVariables();
        if (this.fUserSupplier != null) {
            this.fUserSupplier.serialize(false);
        }
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        int size = ((IStructuredSelection)event.getSelection()).size();
        this.fEditButton.setEnabled(size == 1);
        this.fUndefButton.setEnabled(size > 0);
        this.fDeleteButton.setEnabled(size > 0);
    }

    private void handleCustomButtonPressed(int index) {
        switch (index) {
            case 0: {
                IBuildEnvironmentVariable var;
                NewEnvVarDialog dlg = new NewEnvVarDialog(this.fParent.getShell(), this, null);
                if (dlg.open() != 0 || (var = dlg.getDefinedVariable()) == null) break;
                this.addUserVariable(var.getName(), var.getValue(), var.getOperation(), var.getDelimiter());
                this.updateValues();
                break;
            }
            case 1: {
                IBuildEnvironmentVariable var;
                NewEnvVarDialog dlg;
                IBuildEnvironmentVariable[] vars = this.getSelectedUserVariables();
                if (vars == null || vars.length != 1 || (dlg = new NewEnvVarDialog(this.fParent.getShell(), this, this.getUserVariable(vars[0].getName()))).open() != 0 || (var = dlg.getDefinedVariable()) == null) break;
                this.addUserVariable(var.getName(), var.getValue(), var.getOperation(), var.getDelimiter());
                this.updateValues();
                break;
            }
            case 2: {
                IBuildEnvironmentVariable[] vars = this.getSelectedUserVariables();
                if (vars == null) break;
                int i = 0;
                while (i < vars.length) {
                    this.addUserVariable(vars[i].getName(), null, 2, null);
                    ++i;
                }
                this.updateValues();
                break;
            }
            case 3: {
                IBuildEnvironmentVariable[] vars = this.getSelectedUserVariables();
                if (vars == null || vars.length <= 0 || !MessageDialog.openQuestion((Shell)this.fParent.getShell(), (String)ManagedBuilderUIMessages.getResourceString(DELETE_CONFIRM_TITLE), (String)ManagedBuilderUIMessages.getResourceString(DELETE_CONFIRM_MESSAGE))) break;
                int i = 0;
                while (i < vars.length) {
                    this.deleteUserVariable(vars[i].getName());
                    ++i;
                }
                this.updateValues();
            }
        }
    }

    private IBuildEnvironmentVariable[] getSelectedUserVariables() {
        if (this.fEditableTable == null) {
            return null;
        }
        List list = ((IStructuredSelection)this.fEditableTable.getSelection()).toList();
        return list.toArray(new IBuildEnvironmentVariable[list.size()]);
    }

    public void setContext(Object context) {
        if (context == this.fContext) {
            return;
        }
        this.fContext = context;
        IEnvironmentVariableProvider provider = ManagedBuildManager.getEnvironmentVariableProvider();
        IEnvironmentVariableSupplier[] suppliers = provider.getSuppliers(this.fContext);
        if (suppliers != null && suppliers.length != 0 && suppliers[0] instanceof UserDefinedEnvironmentSupplier) {
            this.fUserSupplier = (UserDefinedEnvironmentSupplier)suppliers[0];
        }
        this.fSystemContextInfo = new SystemContextInfo(context);
        this.fCurrentContextInfo = new CurrentContextInfo(context);
    }

    public void setParentContextInfo(IContextInfo info) {
        this.fParentContextInfo = info;
        this.fUseDefaultParentContextInfo = false;
    }

    public void resetDefaultParentContextInfo() {
        this.fUseDefaultParentContextInfo = true;
        this.fParentContextInfo = null;
    }

    public IContextInfo getContextInfo() {
        return this.fCurrentContextInfo;
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (this.fUserSupplier == null) {
            return;
        }
        this.storeUserVariables();
        this.setModified(false);
    }

    public void performDefaults() {
        if (MessageDialog.openQuestion((Shell)this.fParent.getShell(), (String)ManagedBuilderUIMessages.getResourceString(DELETE_ALL_CONFIRM_TITLE), (String)ManagedBuilderUIMessages.getResourceString(DELETE_ALL_CONFIRM_MESSAGE))) {
            this.deleteAllUserVariables();
            this.updateValues();
        }
    }

    public void updateValues() {
        if (this.fCurrentContextInfo == null) {
            return;
        }
        try {
            EnvironmentVariableProvider provider;
            EnvVarCollector v;
            IMacroContextInfo macroContextInfo;
            Object context = this.fCurrentContextInfo.getContext();
            int contextType = 0;
            Object contextData = null;
            if (context instanceof IConfiguration) {
                contextType = 3;
                contextData = context;
            } else if (context instanceof IManagedProject) {
                contextType = 4;
                contextData = context;
            } else if (context instanceof IWorkspace) {
                contextType = 5;
                contextData = context;
            } else {
                contextType = 7;
                contextData = null;
            }
            BuildMacroProvider macroProvider = this.obtainMacroProvider();
            if (macroProvider != null && (macroContextInfo = macroProvider.getMacroContextInfo(contextType, contextData)) != null && (v = (provider = (EnvironmentVariableProvider)ManagedBuildManager.getEnvironmentVariableProvider()).getVariables(this.fCurrentContextInfo, true)) != null) {
                EnvVarUIMacroSubstitutor substitutor = new EnvVarUIMacroSubstitutor(macroContextInfo, null, " ");
                EnvVarDescriptor[] vars = v.toArray(false);
                int i = 0;
                while (i < vars.length) {
                    MacroResolver.checkMacros((String)vars[i].getValue(), (IMacroSubstitutor)substitutor);
                    ++i;
                }
            }
            this.updateState(null);
        }
        catch (BuildMacroException e) {
            this.updateState(e);
        }
        this.updateUserVariables();
        this.updateSystemVariables();
    }

    private void updateUserVariables() {
        if (this.fEditableTable == null || this.fContext == fInexistentContext) {
            return;
        }
        if (this.fUserSupplier != null) {
            Collection vars = this.getUserVariables().values();
            Iterator iter = vars.iterator();
            ArrayList<IBuildEnvironmentVariable> list = new ArrayList<IBuildEnvironmentVariable>(vars.size());
            while (iter.hasNext()) {
                IBuildEnvironmentVariable sysVar;
                IBuildEnvironmentVariable var;
                IBuildEnvironmentVariable userVar = (IBuildEnvironmentVariable)iter.next();
                if (userVar == null || (var = EnvVarOperationProcessor.performOperation((IBuildEnvironmentVariable)(sysVar = this.getSystemVariable(userVar.getName(), true)), (IBuildEnvironmentVariable)userVar)) == null) continue;
                list.add(var);
            }
            this.fEditableTable.setInput((Object)list.toArray(new IBuildEnvironmentVariable[list.size()]));
        }
    }

    private void updateSystemVariables() {
        if (this.fNonEditableTable == null || this.fContext == fInexistentContext) {
            return;
        }
        ArrayList<IBuildEnvironmentVariable> list = new ArrayList<IBuildEnvironmentVariable>();
        IBuildEnvironmentVariable[] vars = this.getSystemVariables(this.fShowParentVariables);
        if (vars != null && vars.length != 0) {
            int i = 0;
            while (i < vars.length) {
                if (vars[i] != null) {
                    list.add(vars[i]);
                }
                ++i;
            }
        }
        this.fNonEditableTable.setInput((Object)list.toArray(new IBuildEnvironmentVariable[list.size()]));
    }

    public IBuildEnvironmentVariable getSystemVariable(String name, boolean includeParentLevels) {
        if (name == null) {
            return null;
        }
        if (this.fSystemContextInfo == null) {
            return null;
        }
        if (!this.canDisplay(name)) {
            return null;
        }
        return EnvironmentVariableProvider.getDefault().getVariable(name, this.fSystemContextInfo, includeParentLevels);
    }

    public IBuildEnvironmentVariable[] getSystemVariables(boolean includeParentLevels) {
        EnvironmentVariableProvider provider = (EnvironmentVariableProvider)ManagedBuildManager.getEnvironmentVariableProvider();
        EnvVarCollector variables = provider.getVariables(this.fSystemContextInfo, includeParentLevels);
        if (variables == null) {
            return null;
        }
        return this.filterVariables((IBuildEnvironmentVariable[])variables.toArray(false));
    }

    public void createControl(Composite parent) {
        FormData fd;
        Label nameLabel;
        this.fParent = parent;
        FormLayout layout = new FormLayout();
        Control buttonsControl = null;
        Control listControl = null;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        if (this.fIsEditable) {
            nameLabel = new Label(composite, 16384);
            nameLabel.setFont(composite.getFont());
            nameLabel.setText(ManagedBuilderUIMessages.getResourceString(USER_VAR));
            fd = new FormData();
            fd.top = new FormAttachment(0, 2);
            fd.left = new FormAttachment(0, 0);
            nameLabel.setLayoutData((Object)fd);
            listControl = this.createTableControl(composite, true);
            buttonsControl = this.createButtonsControl(composite);
            fd = new FormData();
            fd.top = new FormAttachment((Control)nameLabel, 0);
            fd.right = new FormAttachment(100, 0);
            buttonsControl.setLayoutData((Object)fd);
            fd = new FormData();
            fd.top = new FormAttachment((Control)nameLabel, 0);
            fd.left = new FormAttachment(0, 0);
            fd.right = new FormAttachment(buttonsControl, -5);
            fd.bottom = new FormAttachment(50, -15);
            listControl.setLayoutData((Object)fd);
        }
        nameLabel = new Label(composite, 16384);
        nameLabel.setFont(composite.getFont());
        nameLabel.setText(ManagedBuilderUIMessages.getResourceString(SYSTEM_VAR));
        fd = new FormData();
        fd.top = this.fIsEditable ? new FormAttachment(listControl, 2) : new FormAttachment(0, 2);
        fd.left = new FormAttachment(0, 0);
        nameLabel.setLayoutData((Object)fd);
        this.fStatusLabel = new Label(composite, 16384);
        this.fStatusLabel.setFont(composite.getFont());
        this.fStatusLabel.setForeground(JFaceResources.getColorRegistry().get("ERROR_COLOR"));
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -10);
        fd.left = new FormAttachment(0, 10);
        fd.right = new FormAttachment(100, -10);
        this.fStatusLabel.setLayoutData((Object)fd);
        if (this.fShowParentViewCheckBox) {
            this.fShowParentButton = new Button(composite, 32);
            this.fShowParentButton.setFont(composite.getFont());
            this.fShowParentButton.setText(ManagedBuilderUIMessages.getResourceString(BUTTON_CHECK_SHOW_PARENT));
            fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.bottom = new FormAttachment((Control)this.fStatusLabel, -10);
            this.fShowParentButton.setLayoutData((Object)fd);
            this.fShowParentButton.setSelection(this.fShowParentVariables);
            this.fShowParentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EnvironmentBlock.this.fShowParentVariables = EnvironmentBlock.this.fShowParentButton.getSelection();
                    EnvironmentBlock.this.updateSystemVariables();
                }
            });
        }
        listControl = this.createTableControl(composite, false);
        fd = new FormData();
        fd.top = new FormAttachment((Control)nameLabel, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = buttonsControl != null ? new FormAttachment(buttonsControl, -5) : new FormAttachment(100, 0);
        fd.bottom = this.fShowParentButton != null ? new FormAttachment((Control)this.fShowParentButton, -2) : new FormAttachment((Control)this.fStatusLabel, -10);
        listControl.setLayoutData((Object)fd);
        this.setControl((Control)composite);
    }

    private Control createTableControl(Composite parent, boolean editable) {
        Composite listControl = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 1;
        listControl.setLayout((Layout)gl);
        TableViewer tableViewer = new TableViewer(listControl, 68354);
        Table table = tableViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < fTableColumnNames.length) {
            tableLayout.addColumnData(fTableColumnLayouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(EnvironmentBlock.fTableColumnLayouts[i].resizable);
            tc.setText(fTableColumnNames[i]);
            ++i;
        }
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        tableViewer.getControl().setLayoutData((Object)gd);
        tableViewer.setContentProvider((IContentProvider)new EnvironmentContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new EnvironmentLabelProvider(editable));
        tableViewer.setSorter(new ViewerSorter());
        if (editable) {
            tableViewer.setColumnProperties(fEditableTableColumnProps);
            this.fEditableTable = tableViewer;
            tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EnvironmentBlock.this.handleSelectionChanged(event);
                }
            });
            tableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (!EnvironmentBlock.this.fEditableTable.getSelection().isEmpty()) {
                        EnvironmentBlock.this.handleCustomButtonPressed(1);
                    }
                }
            });
            table.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 127) {
                        EnvironmentBlock.this.handleCustomButtonPressed(3);
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
        } else {
            tableViewer.setColumnProperties(fNonEditableTableColumnProps);
            this.fNonEditableTable = tableViewer;
        }
        return listControl;
    }

    private Control createButtonsControl(Composite parent) {
        Composite buttonsControl = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 1;
        buttonsControl.setLayout((Layout)gl);
        this.fNewButton = this.createPushButton(buttonsControl, ManagedBuilderUIMessages.getResourceString(BUTTON_NEW), null);
        this.fNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentBlock.this.handleCustomButtonPressed(0);
            }
        });
        GridData gd = new GridData(768);
        gd.heightHint = SWTUtil.getButtonHeigthHint((Button)this.fNewButton);
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)this.fNewButton);
        this.fNewButton.setLayoutData((Object)gd);
        this.fEditButton = this.createPushButton(buttonsControl, ManagedBuilderUIMessages.getResourceString(BUTTON_EDIT), null);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentBlock.this.handleCustomButtonPressed(1);
            }
        });
        gd = new GridData(768);
        gd.heightHint = SWTUtil.getButtonHeigthHint((Button)this.fEditButton);
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)this.fEditButton);
        this.fEditButton.setLayoutData((Object)gd);
        this.fUndefButton = this.createPushButton(buttonsControl, ManagedBuilderUIMessages.getResourceString(BUTTON_UNDEF), null);
        this.fUndefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentBlock.this.handleCustomButtonPressed(2);
            }
        });
        gd = new GridData(768);
        gd.heightHint = SWTUtil.getButtonHeigthHint((Button)this.fUndefButton);
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)this.fUndefButton);
        this.fUndefButton.setLayoutData((Object)gd);
        this.fDeleteButton = this.createPushButton(buttonsControl, ManagedBuilderUIMessages.getResourceString(BUTTON_DELETE), null);
        this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentBlock.this.handleCustomButtonPressed(3);
            }
        });
        gd = new GridData(768);
        gd.heightHint = SWTUtil.getButtonHeigthHint((Button)this.fDeleteButton);
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)this.fDeleteButton);
        this.fDeleteButton.setLayoutData((Object)gd);
        return buttonsControl;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public Object getContext() {
        return this.fContext;
    }

    public void displayParentVariables(boolean display) {
        this.fShowParentVariables = display;
        if (this.fShowParentButton != null) {
            this.fShowParentButton.setSelection(this.fShowParentVariables);
        }
        this.updateSystemVariables();
    }

    protected boolean canDisplay(String name) {
        return this.canCreate(name);
    }

    public boolean canCreate(String name) {
        if ((name = EnvVarOperationProcessor.normalizeName((String)name)) == null) {
            return false;
        }
        if (fHiddenVariables != null) {
            int i = 0;
            while (i < fHiddenVariables.length) {
                if (name.equals(fHiddenVariables[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected IBuildEnvironmentVariable[] filterVariables(IBuildEnvironmentVariable[] variables) {
        return EnvVarOperationProcessor.filterVariables((IBuildEnvironmentVariable[])variables, (String[])fHiddenVariables);
    }

    private void updateState(BuildMacroException e) {
        this.fIncorrectlyDefinedVariablesNames.clear();
        if (e != null) {
            this.fStatusLabel.setText(e.getMessage());
            this.fStatusLabel.setVisible(true);
            IBuildMacroStatus[] statuses = e.getMacroStatuses();
            int i = 0;
            while (i < statuses.length) {
                String name = statuses[i].getMacroName();
                if (name != null) {
                    this.fIncorrectlyDefinedVariablesNames.add(name);
                }
                ++i;
            }
        } else {
            this.fStatusLabel.setVisible(false);
        }
    }

    protected BuildMacroProvider obtainMacroProvider() {
        MacrosSetBlock block;
        ICOptionContainer page;
        ICOptionContainer container = this.getContainer();
        ManagedBuildOptionBlock optionBlock = null;
        if (container instanceof BuildPropertyPage) {
            page = (BuildPropertyPage)container;
            optionBlock = page.getOptionBlock();
        } else if (container instanceof BuildPreferencePage) {
            page = (BuildPreferencePage)container;
            optionBlock = page.getOptionBlock();
        }
        if (optionBlock != null && (block = optionBlock.getMacrosBlock()) != null) {
            return block.getBuildMacroProvider();
        }
        return (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider();
    }

    private class SystemContextInfo
    extends DefaultContextInfo {
        protected SystemContextInfo(Object context) {
            super(context);
        }

        protected IEnvironmentVariableSupplier[] getSuppliers(Object context) {
            IEnvironmentVariableSupplier[] suppliers = super.getSuppliers(context);
            if (suppliers == null || suppliers.length == 0) {
                return null;
            }
            ArrayList<IEnvironmentVariableSupplier> list = new ArrayList<IEnvironmentVariableSupplier>();
            int i = 0;
            while (i < suppliers.length) {
                if (!(suppliers[i] instanceof UserDefinedEnvironmentSupplier)) {
                    list.add(suppliers[i]);
                }
                ++i;
            }
            return list.toArray(new IEnvironmentVariableSupplier[list.size()]);
        }

        public IContextInfo getNext() {
            if (EnvironmentBlock.this.fUseDefaultParentContextInfo) {
                return super.getNext();
            }
            return EnvironmentBlock.this.fParentContextInfo;
        }
    }

    private class CurrentContextInfo
    extends DefaultContextInfo {
        protected CurrentContextInfo(Object context) {
            super(context);
        }

        public IEnvironmentVariableSupplier[] getSuppliers(Object context) {
            IEnvironmentVariableSupplier[] suppliers = super.getSuppliers(context);
            if (suppliers == null || suppliers.length == 0) {
                return suppliers;
            }
            if (!(suppliers[0] instanceof UserDefinedEnvironmentSupplier)) {
                return suppliers;
            }
            ArrayList<IEnvironmentVariableSupplier> list = new ArrayList<IEnvironmentVariableSupplier>(suppliers.length);
            list.add(new UIVariableSupplier());
            int i = 1;
            while (i < suppliers.length) {
                list.add(suppliers[i]);
                ++i;
            }
            return list.toArray(new IEnvironmentVariableSupplier[list.size()]);
        }

        public IContextInfo getNext() {
            if (EnvironmentBlock.this.fUseDefaultParentContextInfo) {
                return super.getNext();
            }
            return EnvironmentBlock.this.fParentContextInfo;
        }
    }

    private class UIVariableSupplier
    implements IEnvironmentVariableSupplier {
        UIVariableSupplier() {
        }

        public IBuildEnvironmentVariable getVariable(String name, Object context) {
            if (context != EnvironmentBlock.this.fContext) {
                return null;
            }
            return (IBuildEnvironmentVariable)EnvironmentBlock.this.getUserVariables().get(name);
        }

        public IBuildEnvironmentVariable[] getVariables(Object context) {
            if (context != EnvironmentBlock.this.fContext) {
                return null;
            }
            Collection vars = EnvironmentBlock.this.getUserVariables().values();
            return vars.toArray(new IBuildEnvironmentVariable[vars.size()]);
        }
    }

    private class EnvironmentContentProvider
    implements IStructuredContentProvider {
        EnvironmentContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class EnvironmentLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider,
    ITableFontProvider,
    IColorProvider {
        private boolean fUser;

        public EnvironmentLabelProvider(boolean user) {
            this.fUser = user;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IBuildEnvironmentVariable var = (IBuildEnvironmentVariable)element;
            switch (columnIndex) {
                case 0: {
                    return var.getName();
                }
                case 1: {
                    if (var.getOperation() == 2) {
                        return ManagedBuilderUIMessages.getResourceString(EnvironmentBlock.VALUE_UNDEF);
                    }
                    return var.getValue();
                }
            }
            return "";
        }

        public Font getFont(Object element) {
            return this.getFont(element, 0);
        }

        public Font getFont(Object element, int columnIndex) {
            IBuildEnvironmentVariable var = (IBuildEnvironmentVariable)element;
            switch (columnIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    if (var.getOperation() != 2) break;
                    return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
                }
            }
            if (!this.fUser && EnvironmentBlock.this.getUserVariable(var.getName()) != null) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        public Color getForeground(Object element) {
            IBuildEnvironmentVariable var = (IBuildEnvironmentVariable)element;
            boolean incorrect = false;
            String name = var.getName();
            if (this.fUser || EnvironmentBlock.this.getUserVariable(name) == null) {
                incorrect = EnvironmentBlock.this.fIncorrectlyDefinedVariablesNames.contains(name);
            }
            if (incorrect) {
                return JFaceResources.getColorRegistry().get("ERROR_COLOR");
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    private class EnvVarUIMacroSubstitutor
    extends DefaultMacroSubstitutor {
        public EnvVarUIMacroSubstitutor(IMacroContextInfo contextInfo, String inexistentMacroValue, String listDelimiter) {
            super(contextInfo, inexistentMacroValue, listDelimiter);
        }

        public EnvVarUIMacroSubstitutor(int contextType, Object contextData, String inexistentMacroValue, String listDelimiter) {
            super(contextType, contextData, inexistentMacroValue, listDelimiter);
        }

        protected DefaultMacroSubstitutor.ResolvedMacro resolveMacro(IBuildMacro macro) throws BuildMacroException {
            if (macro instanceof EclipseVariablesMacroSupplier.EclipseVarMacro) {
                EclipseVariablesMacroSupplier.EclipseVarMacro eclipseVarMacro = (EclipseVariablesMacroSupplier.EclipseVarMacro)macro;
                IStringVariable var = eclipseVarMacro.getVariable();
                String value = null;
                value = var instanceof IDynamicVariable ? "dynamic<" + var.getName() + ">" : macro.getStringValue();
                return new DefaultMacroSubstitutor.ResolvedMacro((DefaultMacroSubstitutor)this, macro.getName(), value);
            }
            return super.resolveMacro(macro);
        }
    }
}

